/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.impl;

import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.slf4j.Logger;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.metadata.MetadataConfig;
import org.uberfire.ext.metadata.engine.MetaIndexEngine;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.ext.metadata.model.KCluster;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;

@Dependent
public class IndexStatusOracle {
    private final Logger logger;
    private final MetaIndexEngine indexEngine;

    public IndexStatusOracle() {
        this(null, null);
    }

    @Inject
    public IndexStatusOracle(MetadataConfig config, Logger logger) {
        this.logger = logger;
        this.indexEngine = config.getIndexEngine();
    }

    public boolean isIndexed(WorkspaceProject project) {
        Optional<KCluster> clusterOf = this.kClusterOf(project);
        return clusterOf.map(cluster -> this.indexEngine.isIndexReady(cluster)).orElse(false);
    }

    private Optional<KCluster> kClusterOf(WorkspaceProject project) {
        try {
            Path rootPath = Paths.convert((org.uberfire.backend.vfs.Path)project.getRootPath());
            FileSystem fileSystem = rootPath.getFileSystem();
            KCluster cluster = KObjectUtil.toKCluster((FileSystem)fileSystem);
            return Optional.of(cluster);
        }
        catch (Throwable t) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("Unable to lookup KCluster for project: %s", project), t);
            }
            return Optional.empty();
        }
    }
}

