/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.impl;

import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.kie.workbench.common.screens.impl.LibraryIndexer;
import org.kie.workbench.common.screens.library.api.ProjectAssetListUpdated;
import org.kie.workbench.common.screens.library.api.Remote;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.metadata.event.BatchIndexEvent;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class LibraryAssetUpdateNotifier {
    private final WorkspaceProjectService projectService;
    private final Event<ProjectAssetListUpdated> assetListUpdateEvent;
    private final LibraryIndexer libraryIndexer;

    public LibraryAssetUpdateNotifier() {
        this(null, null, null);
    }

    @Inject
    public LibraryAssetUpdateNotifier(WorkspaceProjectService projectService, LibraryIndexer libraryIndexer, @Remote Event<ProjectAssetListUpdated> assetListUpdateEvent) {
        this.projectService = projectService;
        this.libraryIndexer = libraryIndexer;
        this.assetListUpdateEvent = assetListUpdateEvent;
    }

    public void notifyOnUpdatedAssets(@Observes BatchIndexEvent event) {
        event.getIndexed().stream().map(kobject -> kobject.getKey()).map(path -> org.uberfire.java.nio.file.Paths.get((String)path, (String[])new String[0])).filter(path -> this.libraryIndexer.supportsPath((Path)path)).flatMap(path -> {
            try {
                WorkspaceProject project = this.projectService.resolveProject(Paths.convert((Path)path));
                return project == null ? Stream.empty() : Stream.of(project);
            }
            catch (Throwable t) {
                return Stream.empty();
            }
        }).map(project -> new ProjectAssetListUpdated(project)).findFirst().ifPresent(clientEvent -> this.assetListUpdateEvent.fire(clientEvent));
    }
}

