/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.Package;
import org.kie.workbench.common.screens.impl.LibraryAssetTypeDefinition;
import org.kie.workbench.common.services.refactoring.KPropertyImpl;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.AbstractFileIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.util.KObjectUtil;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KObjectKey;
import org.uberfire.ext.metadata.model.KProperty;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class LibraryIndexer
extends AbstractFileIndexer {
    private static final Logger logger = LoggerFactory.getLogger(LibraryIndexer.class);
    private static final String LIBRARY_CLASSIFIER = "library";
    private LibraryAssetTypeDefinition filter;

    public LibraryIndexer() {
    }

    @Inject
    public LibraryIndexer(LibraryAssetTypeDefinition filter) {
        this.filter = filter;
    }

    void setIOService(IOService ioService) {
        this.ioService = ioService;
    }

    void setModuleService(KieModuleService moduleService) {
        this.moduleService = moduleService;
    }

    public boolean supportsPath(Path path) {
        return this.filter.accept(Paths.convert((Path)path));
    }

    protected DefaultIndexBuilder fillIndexBuilder(Path path) throws Exception {
        KieModule module = this.getModule(path);
        if (module == null) {
            logger.debug("Unable to index " + path.toUri().toString() + ": module could not be resolved.");
            return null;
        }
        Package pkg = this.getPackage(path);
        if (pkg == null) {
            logger.debug("Unable to index " + path.toUri().toString() + ": package could not be resolved.");
            return null;
        }
        DefaultIndexBuilder builder = new DefaultIndexBuilder(Paths.convert((Path)path).getFileName(), (Module)module, pkg){

            public Set<KProperty<?>> build() {
                HashSet indexElements = new HashSet();
                indexElements.add((KProperty<?>)new KPropertyImpl("libraryFileName", (Object)this.fileName));
                indexElements.add((KProperty<?>)new KPropertyImpl("filenamesorted", (Object)this.fileName.toLowerCase(), false, true));
                if (this.module.getRootPath() != null) {
                    String moduleRootUri = this.module.getRootPath().toURI();
                    indexElements.add((KProperty<?>)new KPropertyImpl("libraryProjectRoot", (Object)moduleRootUri));
                }
                if (this.module.getModuleName() != null) {
                    String moduleName = this.module.getModuleName();
                    indexElements.add((KProperty<?>)new KPropertyImpl("projectName", (Object)moduleName));
                }
                if (this.pkgName == null) {
                    this.pkgName = this.pkg.getPackageName();
                }
                if (this.pkgName != null) {
                    indexElements.add((KProperty<?>)new KPropertyImpl("packageName", (Object)this.pkgName));
                }
                return indexElements;
            }
        };
        return builder;
    }

    public KObject toKObject(Path path) {
        KObject index = null;
        try {
            DefaultIndexBuilder builder = this.fillIndexBuilder(path);
            Set indexElements = null;
            indexElements = builder != null ? builder.build() : Collections.emptySet();
            index = KObjectUtil.toKObject((Path)path, (String)LIBRARY_CLASSIFIER, (Set)indexElements);
        }
        catch (Exception e) {
            logger.error("Unable to index '" + path.toUri().toString() + "'.", (Object)e.getMessage(), (Object)e);
        }
        return index;
    }

    public KObjectKey toKObjectKey(Path path) {
        return KObjectUtil.toKObjectKey((Path)path, (String)LIBRARY_CLASSIFIER);
    }

    protected KieModule getModule(Path path) {
        return (KieModule)this.moduleService.resolveModule(Paths.convert((Path)path));
    }

    protected Package getPackage(Path path) {
        return this.moduleService.resolvePackage(Paths.convert((Path)path));
    }
}

