/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.ext.uberfire.social.activities.model.SocialUser;
import org.ext.uberfire.social.activities.service.SocialUserRepositoryAPI;
import org.guvnor.common.services.project.context.WorkspaceProjectContextChangeEvent;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.guvnor.structure.security.OrganizationalUnitAction;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.screens.examples.model.ExampleOrganizationalUnit;
import org.kie.workbench.common.screens.examples.model.ExampleProject;
import org.kie.workbench.common.screens.examples.model.ExampleRepository;
import org.kie.workbench.common.screens.examples.service.ExamplesService;
import org.kie.workbench.common.screens.explorer.backend.server.ExplorerServiceHelper;
import org.kie.workbench.common.screens.explorer.model.FolderItem;
import org.kie.workbench.common.screens.explorer.model.FolderItemType;
import org.kie.workbench.common.screens.impl.FindAllLibraryAssetsQuery;
import org.kie.workbench.common.screens.impl.IndexStatusOracle;
import org.kie.workbench.common.screens.library.api.AssetInfo;
import org.kie.workbench.common.screens.library.api.AssetQueryResult;
import org.kie.workbench.common.screens.library.api.LibraryInfo;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.api.OrganizationalUnitRepositoryInfo;
import org.kie.workbench.common.screens.library.api.ProjectAssetsQuery;
import org.kie.workbench.common.screens.library.api.index.LibraryValueFileExtensionIndexTerm;
import org.kie.workbench.common.screens.library.api.index.LibraryValueFileNameIndexTerm;
import org.kie.workbench.common.screens.library.api.index.LibraryValueModuleRootPathIndexTerm;
import org.kie.workbench.common.screens.library.api.preferences.LibraryInternalPreferences;
import org.kie.workbench.common.screens.library.api.preferences.LibraryPreferences;
import org.kie.workbench.common.screens.projecteditor.util.NewWorkspaceProjectUtils;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRequest;
import org.kie.workbench.common.services.refactoring.service.RefactoringQueryService;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.attribute.FileTime;
import org.uberfire.paging.PageResponse;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;

@Service
@ApplicationScoped
public class LibraryServiceImpl
implements LibraryService {
    private static final Pattern STRIP_DOT_GIT = Pattern.compile("\\.git$");
    private static final Logger log = LoggerFactory.getLogger(LibraryServiceImpl.class);
    private RefactoringQueryService refactoringQueryService;
    private OrganizationalUnitService ouService;
    private LibraryPreferences preferences;
    private LibraryInternalPreferences internalPreferences;
    private AuthorizationManager authorizationManager;
    private SessionInfo sessionInfo;
    private ExplorerServiceHelper explorerServiceHelper;
    private WorkspaceProjectService projectService;
    private KieModuleService moduleService;
    private ExamplesService examplesService;
    private IOService ioService;
    private SocialUserRepositoryAPI socialUserRepositoryAPI;
    private IndexStatusOracle indexOracle;
    private RepositoryService repoService;

    public LibraryServiceImpl() {
    }

    @Inject
    public LibraryServiceImpl(OrganizationalUnitService ouService, RefactoringQueryService refactoringQueryService, LibraryPreferences preferences, AuthorizationManager authorizationManager, SessionInfo sessionInfo, ExplorerServiceHelper explorerServiceHelper, WorkspaceProjectService projectService, KieModuleService moduleService, ExamplesService examplesService, RepositoryService repoService, @Named(value="ioStrategy") IOService ioService, LibraryInternalPreferences internalPreferences, SocialUserRepositoryAPI socialUserRepositoryAPI, IndexStatusOracle indexOracle) {
        this.ouService = ouService;
        this.refactoringQueryService = refactoringQueryService;
        this.preferences = preferences;
        this.authorizationManager = authorizationManager;
        this.sessionInfo = sessionInfo;
        this.explorerServiceHelper = explorerServiceHelper;
        this.projectService = projectService;
        this.moduleService = moduleService;
        this.examplesService = examplesService;
        this.repoService = repoService;
        this.ioService = ioService;
        this.internalPreferences = internalPreferences;
        this.socialUserRepositoryAPI = socialUserRepositoryAPI;
        this.indexOracle = indexOracle;
    }

    public OrganizationalUnitRepositoryInfo getDefaultOrganizationalUnitRepositoryInfo() {
        return this.getOrganizationalUnitRepositoryInfo(this.getDefaultOrganizationalUnit());
    }

    public OrganizationalUnitRepositoryInfo getOrganizationalUnitRepositoryInfo(OrganizationalUnit selectedOrganizationalUnit) {
        if (selectedOrganizationalUnit == null) {
            return null;
        }
        List<OrganizationalUnit> organizationalUnits = this.getOrganizationalUnits();
        OrganizationalUnit organizationalUnit = this.getOrganizationalUnit(selectedOrganizationalUnit.getIdentifier(), organizationalUnits).get();
        ArrayList repositories = new ArrayList(organizationalUnit.getRepositories());
        return new OrganizationalUnitRepositoryInfo(organizationalUnits, organizationalUnit, repositories);
    }

    public LibraryInfo getLibraryInfo(OrganizationalUnit organizationalUnit) {
        Collection result = this.projectService.getAllWorkspaceProjects(organizationalUnit);
        for (WorkspaceProject workspaceProject : result) {
            if (workspaceProject.getMainModule() == null) continue;
            workspaceProject.getMainModule().setNumberOfAssets(this.getNumberOfAssets(workspaceProject));
        }
        return new LibraryInfo(result);
    }

    public WorkspaceProject createProject(String projectName, OrganizationalUnit selectedOrganizationalUnit, String projectDescription, DeploymentMode deploymentMode) {
        GAV gav = this.createGAV(projectName, selectedOrganizationalUnit);
        POM pom = this.createPOM(projectName, projectDescription, gav);
        return this.projectService.newProject(selectedOrganizationalUnit, pom, deploymentMode);
    }

    public WorkspaceProject createProject(OrganizationalUnit activeOrganizationalUnit, POM pom, DeploymentMode mode) {
        return this.projectService.newProject(activeOrganizationalUnit, pom, mode);
    }

    public WorkspaceProject importProject(OrganizationalUnit targetOU, String repositoryURL, String username, String password) {
        RepositoryEnvironmentConfigurations config = new RepositoryEnvironmentConfigurations();
        config.setOrigin(repositoryURL);
        if (username != null && password != null) {
            config.setUserName(username);
            config.setPassword(password);
        }
        String targetProjectName = this.inferProjectName(repositoryURL);
        Repository repo = this.repoService.createRepository(targetOU, GitRepository.SCHEME.toString(), targetProjectName, config);
        return this.projectService.resolveProject(repo);
    }

    public WorkspaceProject importProject(OrganizationalUnit organizationalUnit, ExampleProject exampleProject) {
        ExampleOrganizationalUnit exampleOrganizationalUnit = new ExampleOrganizationalUnit(organizationalUnit.getName());
        List<ExampleProject> exampleProjects = Collections.singletonList(exampleProject);
        WorkspaceProjectContextChangeEvent projectContextChangeEvent = this.examplesService.setupExamples(exampleOrganizationalUnit, exampleProjects);
        return projectContextChangeEvent.getWorkspaceProject();
    }

    private String inferProjectName(String repositoryURL) {
        return Optional.of(repositoryURL).map(url -> java.nio.file.Paths.get(repositoryURL, new String[0])).map(path -> path.getFileName().toString()).map(fileName -> STRIP_DOT_GIT.matcher((CharSequence)fileName)).map(matcher -> matcher.replaceFirst("")).orElse("new-project");
    }

    public Boolean thereIsAProjectInTheWorkbench() {
        return !this.projectService.getAllWorkspaceProjects().isEmpty();
    }

    public AssetQueryResult getProjectAssets(ProjectAssetsQuery query) {
        PortablePreconditions.checkNotNull((String)"query", (Object)query);
        boolean projectStillExists = this.ioService.exists(Paths.convert((Path)query.getProject().getBranch().getPath()));
        if (!projectStillExists) {
            return AssetQueryResult.nonexistent();
        }
        if (!this.indexOracle.isIndexed(query.getProject())) {
            return AssetQueryResult.unindexed();
        }
        HashSet<ValueIndexTerm> queryTerms = this.buildProjectAssetsQuery(query);
        PageResponse findRulesByProjectQuery = this.refactoringQueryService.query(new RefactoringPageRequest(FindAllLibraryAssetsQuery.NAME, queryTerms, query.getStartIndex(), Integer.valueOf(query.getAmount()), Boolean.TRUE));
        List assets = findRulesByProjectQuery.getPageRowList().stream().map(row -> {
            Path path = (Path)row.getValue();
            return new FolderItem((Object)path, path.getFileName(), FolderItemType.FILE, false, Paths.readLockedBy((Path)path), Collections.emptyList(), this.explorerServiceHelper.getRestrictedOperations(path));
        }).collect(Collectors.toList());
        return AssetQueryResult.normal(assets.stream().map(asset -> {
            AssetInfo info = null;
            try {
                Map attributes = this.ioService.readAttributes(Paths.convert((Path)((Path)asset.getItem())));
                FileTime lastModifiedFileTime = (FileTime)this.getAttribute("lastModifiedTime", attributes).get();
                FileTime createdFileTime = (FileTime)this.getAttribute("creationTime", attributes).get();
                Date lastModifiedTime = new Date(lastModifiedFileTime.toMillis());
                Date createdTime = new Date(createdFileTime.toMillis());
                info = new AssetInfo(asset, lastModifiedTime, createdTime);
            }
            catch (NoSuchFileException nfe) {
                log.debug("File '" + asset.getFileName() + "' in LibraryIndex but not VFS. Suspected deletion. Skipping.");
            }
            return Optional.ofNullable(info);
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    private HashSet<ValueIndexTerm> buildProjectAssetsQuery(ProjectAssetsQuery query) {
        HashSet<ValueIndexTerm> queryTerms = new HashSet<ValueIndexTerm>();
        queryTerms.add((ValueIndexTerm)new LibraryValueModuleRootPathIndexTerm(query.getProject().getRootPath().toURI()));
        if (query.hasFilter()) {
            queryTerms.add((ValueIndexTerm)new LibraryValueFileNameIndexTerm("*" + query.getFilter() + "*", ValueIndexTerm.TermSearchType.WILDCARD));
        }
        if (query.hasExtension()) {
            queryTerms.add((ValueIndexTerm)new LibraryValueFileExtensionIndexTerm(query.getExtensions()));
        }
        return queryTerms;
    }

    public Boolean hasProjects(OrganizationalUnit organizationalUnit) {
        return !this.projectService.getAllWorkspaceProjects(organizationalUnit).isEmpty();
    }

    public Boolean hasAssets(WorkspaceProject project) {
        PortablePreconditions.checkNotNull((String)"LibraryServiceImpl.project", (Object)project);
        boolean projectStillExists = this.ioService.exists(Paths.convert((Path)project.getRootPath()));
        if (!projectStillExists) {
            return false;
        }
        Package defaultPackage = this.moduleService.resolveDefaultPackage(project.getMainModule());
        return this.explorerServiceHelper.hasAssets(defaultPackage);
    }

    public Set<ExampleProject> getExampleProjects() {
        String importProjectsUrl = this.getCustomImportProjectsUrl();
        ExampleRepository repository = importProjectsUrl == null || importProjectsUrl.isEmpty() ? this.examplesService.getPlaygroundRepository() : new ExampleRepository(importProjectsUrl);
        Set projects = this.examplesService.getProjects(repository);
        return projects;
    }

    public Set<ExampleProject> getProjects(String repositoryUrl) {
        return this.getProjects(repositoryUrl, null, null);
    }

    public Set<ExampleProject> getProjects(String repositoryUrl, String userName, String password) {
        if (repositoryUrl == null) {
            return this.getExampleProjects();
        }
        ExampleRepository repository = new ExampleRepository(repositoryUrl, userName, password);
        return this.examplesService.getProjects(repository);
    }

    public List<OrganizationalUnit> getOrganizationalUnits() {
        return new ArrayList<OrganizationalUnit>(this.ouService.getOrganizationalUnits());
    }

    public GAV createGAV(String projectName, OrganizationalUnit selectedOrganizationalUnit) {
        LibraryPreferences preferences = this.getPreferences();
        String artifactId = NewWorkspaceProjectUtils.sanitizeProjectName((String)projectName);
        return new GAV(selectedOrganizationalUnit.getDefaultGroupId(), artifactId, preferences.getProjectPreferences().getVersion());
    }

    public List<SocialUser> getAllUsers() {
        return this.socialUserRepositoryAPI.findAllUsers().stream().filter(user -> !user.getUserName().equals("system")).collect(Collectors.toList());
    }

    String getCustomImportProjectsUrl() {
        return System.getProperty("org.kie.project.examples.repository.url");
    }

    LibraryPreferences getPreferences() {
        this.preferences.load();
        return this.preferences;
    }

    LibraryInternalPreferences getInternalPreferences() {
        this.internalPreferences.load();
        return this.internalPreferences;
    }

    POM createPOM(String projectName, String projectDescription, GAV gav) {
        return new POM(projectName, projectDescription, "", gav);
    }

    private Optional<Object> getAttribute(String attribute, Map<String, Object> attributes) {
        return attributes.entrySet().stream().filter(entry -> attribute.equals(entry.getKey())).map(Map.Entry::getValue).findFirst();
    }

    public int getNumberOfAssets(ProjectAssetsQuery query) {
        HashSet<ValueIndexTerm> queryTerms = this.buildProjectAssetsQuery(query);
        return this.refactoringQueryService.queryHitCount(new RefactoringPageRequest(FindAllLibraryAssetsQuery.NAME, queryTerms, 0, null));
    }

    public int getNumberOfAssets(WorkspaceProject module) {
        HashSet<LibraryValueModuleRootPathIndexTerm> queryTerms = new HashSet<LibraryValueModuleRootPathIndexTerm>();
        queryTerms.add(new LibraryValueModuleRootPathIndexTerm(module.getRootPath().toURI()));
        return this.refactoringQueryService.queryHitCount(new RefactoringPageRequest(FindAllLibraryAssetsQuery.NAME, queryTerms, 0, null, Boolean.TRUE));
    }

    public OrganizationalUnit getDefaultOrganizationalUnit() {
        List<OrganizationalUnit> organizationalUnits;
        Optional<OrganizationalUnit> defaultOU;
        String defaultOUIdentifier = this.getInternalPreferences().getLastOpenedOrganizationalUnit();
        if (defaultOUIdentifier == null || defaultOUIdentifier.isEmpty()) {
            defaultOUIdentifier = this.getPreferences().getOrganizationalUnitPreferences().getName();
        }
        if ((defaultOU = this.getOrganizationalUnit(defaultOUIdentifier, organizationalUnits = this.getOrganizationalUnits())).isPresent()) {
            return defaultOU.get();
        }
        if (!organizationalUnits.isEmpty()) {
            return organizationalUnits.get(0);
        }
        return this.createDefaultOrganizationalUnit();
    }

    private OrganizationalUnit createDefaultOrganizationalUnit() {
        if (!this.authorizationManager.authorize((ResourceType)OrganizationalUnit.RESOURCE_TYPE, (ResourceAction)OrganizationalUnitAction.CREATE, this.sessionInfo.getIdentity())) {
            return null;
        }
        LibraryPreferences preferences = this.getPreferences();
        ArrayList<String> contributors = new ArrayList<String>();
        contributors.add(preferences.getOrganizationalUnitPreferences().getOwner());
        return this.ouService.createOrganizationalUnit(preferences.getOrganizationalUnitPreferences().getName(), preferences.getOrganizationalUnitPreferences().getOwner(), preferences.getOrganizationalUnitPreferences().getGroupId(), Collections.emptyList(), contributors);
    }

    private Optional<OrganizationalUnit> getOrganizationalUnit(String identifier, Collection<OrganizationalUnit> organizationalUnits) {
        return organizationalUnits.stream().filter(p -> p.getIdentifier().equalsIgnoreCase(identifier)).findFirst();
    }
}

