/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens;

import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.screens.library.api.ProjectInfo;
import org.kie.workbench.common.screens.library.client.events.ProjectDetailEvent;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.kie.workbench.common.screens.library.client.util.ResourceUtils;
import org.kie.workbench.common.widgets.client.handlers.NewResourceHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.client.workbench.events.PlaceGainFocusEvent;
import org.uberfire.mvp.PlaceRequest;

@WorkbenchScreen(identifier="EmptyProjectScreen")
public class EmptyProjectScreen {
    private View view;
    private ResourceUtils resourceUtils;
    private NewResourcePresenter newResourcePresenter;
    private PlaceManager placeManager;
    private LibraryPlaces libraryPlaces;
    private NewResourceHandler uploadHandler;
    ProjectInfo projectInfo;

    @Inject
    public EmptyProjectScreen(View view, ResourceUtils resourceUtils, NewResourcePresenter newResourcePresenter, PlaceManager placeManager, LibraryPlaces libraryPlaces) {
        this.view = view;
        this.resourceUtils = resourceUtils;
        this.newResourcePresenter = newResourcePresenter;
        this.placeManager = placeManager;
        this.libraryPlaces = libraryPlaces;
    }

    public void onStartup(@Observes ProjectDetailEvent projectDetailEvent) {
        this.projectInfo = projectDetailEvent.getProjectInfo();
        this.view.init(this);
        this.resourceUtils.getOrderedNewResourceHandlers().stream().filter(newResourceHandler -> newResourceHandler.canCreate()).forEach(newResourceHandler -> {
            if (ResourceUtils.isUploadHandler(newResourceHandler)) {
                this.uploadHandler = newResourceHandler;
            } else if (!ResourceUtils.isPackageHandler(newResourceHandler) && !ResourceUtils.isProjectHandler(newResourceHandler)) {
                this.view.addResourceHandler((NewResourceHandler)newResourceHandler);
            }
        });
        this.view.setProjectName(this.projectInfo.getProject().getProjectName());
        this.placeManager.closePlace("LibraryScreen");
    }

    public void refreshOnFocus(@Observes PlaceGainFocusEvent placeGainFocusEvent) {
        PlaceRequest place = placeGainFocusEvent.getPlace();
        if (this.projectInfo != null && place.getIdentifier().equals("EmptyProjectScreen")) {
            this.libraryPlaces.goToProject(this.projectInfo);
        }
    }

    public void goToSettings() {
        this.libraryPlaces.goToSettings(this.projectInfo);
    }

    public NewResourceHandler getUploadHandler() {
        return this.uploadHandler;
    }

    public NewResourcePresenter getNewResourcePresenter() {
        return this.newResourcePresenter;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return "Empty Project Screen";
    }

    @WorkbenchPartView
    public UberElement<EmptyProjectScreen> getView() {
        return this.view;
    }

    public static interface View
    extends UberElement<EmptyProjectScreen> {
        public void setProjectName(String var1);

        public void addResourceHandler(NewResourceHandler var1);
    }
}

