/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens;

import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.screens.examples.model.ExampleProject;
import org.kie.workbench.common.screens.library.api.LibraryInfo;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.api.ProjectInfo;
import org.kie.workbench.common.screens.library.client.events.ProjectDetailEvent;
import org.kie.workbench.common.screens.library.client.perspective.LibraryPerspective;
import org.kie.workbench.common.screens.library.client.util.ExamplesUtils;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@WorkbenchScreen(identifier="LibraryScreen", owningPerspective=LibraryPerspective.class)
public class LibraryScreen {
    LibraryInfo libraryInfo;
    private View view;
    private PlaceManager placeManager;
    private LibraryPlaces libraryPlaces;
    private Event<ProjectDetailEvent> projectDetailEvent;
    private Caller<LibraryService> libraryService;
    private ExamplesUtils examplesUtils;

    @Inject
    public LibraryScreen(View view, PlaceManager placeManager, LibraryPlaces libraryPlaces, Event<ProjectDetailEvent> projectDetailEvent, Caller<LibraryService> libraryService, ExamplesUtils examplesUtils) {
        this.view = view;
        this.placeManager = placeManager;
        this.libraryPlaces = libraryPlaces;
        this.projectDetailEvent = projectDetailEvent;
        this.libraryService = libraryService;
        this.examplesUtils = examplesUtils;
    }

    @PostConstruct
    public void setup() {
        Repository selectedRepository = this.libraryPlaces.getSelectedRepository();
        String selectedBranch = this.libraryPlaces.getSelectedBranch();
        ((LibraryService)this.libraryService.call((RemoteCallback)new RemoteCallback<LibraryInfo>(){

            public void callback(LibraryInfo libraryInfo) {
                LibraryScreen.this.updateLibrary(libraryInfo);
            }
        })).getLibraryInfo(selectedRepository, selectedBranch);
        this.placeManager.closePlace("EmptyLibraryScreen");
    }

    private void updateLibrary(LibraryInfo libraryInfo) {
        this.libraryInfo = libraryInfo;
        this.view.clearFilterText();
        this.setupProjects(libraryInfo.getProjects());
    }

    private void setupProjects(Set<Project> projects) {
        this.view.clearProjects();
        projects.stream().forEach(p -> this.view.addProject(p.getProjectName(), this.detailsCommand((Project)p), this.selectCommand((Project)p)));
    }

    public void newProject() {
        this.libraryPlaces.goToNewProject();
    }

    public void updateProjectsBy(String filter) {
        if (this.libraryInfo != null) {
            Set<Project> filteredProjects = this.filterProjects(filter);
            this.setupProjects(filteredProjects);
        }
    }

    public void importProject(ExampleProject exampleProject) {
        this.examplesUtils.importProject(exampleProject);
    }

    public void updateImportProjects() {
        this.examplesUtils.getExampleProjects((ParameterizedCommand<Set<ExampleProject>>)((ParameterizedCommand)exampleProjects -> {
            this.view.clearImportProjectsContainer();
            for (ExampleProject exampleProject : exampleProjects) {
                this.view.addProjectToImport(exampleProject);
            }
        }));
    }

    Command selectCommand(Project project) {
        return () -> {
            ProjectInfo projectInfo = this.getProjectInfo(project);
            this.libraryPlaces.goToProject(projectInfo);
        };
    }

    Command detailsCommand(Project project) {
        return () -> {
            ProjectInfo projectInfo = this.getProjectInfo(project);
            this.projectDetailEvent.fire((Object)new ProjectDetailEvent(projectInfo));
        };
    }

    Set<Project> filterProjects(String filter) {
        return this.libraryInfo.getProjects().stream().filter(p -> p.getProjectName() != null).filter(p -> p.getProjectName().toUpperCase().startsWith(filter.toUpperCase())).collect(Collectors.toSet());
    }

    private ProjectInfo getProjectInfo(Project project) {
        return new ProjectInfo(this.libraryPlaces.getSelectedOrganizationalUnit(), this.libraryPlaces.getSelectedRepository(), this.libraryPlaces.getSelectedBranch(), project);
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return "Library Screen";
    }

    @WorkbenchPartView
    public UberElement<LibraryScreen> getView() {
        return this.view;
    }

    public static interface View
    extends UberElement<LibraryScreen> {
        public void clearProjects();

        public void addProject(String var1, Command var2, Command var3);

        public void clearFilterText();

        public void addProjectToImport(ExampleProject var1);

        public void clearImportProjectsContainer();
    }
}

