/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens;

import com.google.gwt.user.client.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.SinkNative;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.examples.model.ExampleProject;
import org.kie.workbench.common.screens.library.client.screens.LibraryScreen;
import org.kie.workbench.common.screens.library.client.screens.ProjectsDetailScreen;
import org.kie.workbench.common.screens.library.client.widgets.ImportExampleListItemWidget;
import org.kie.workbench.common.screens.library.client.widgets.NewProjectButtonWidget;
import org.kie.workbench.common.screens.library.client.widgets.ProjectItemWidget;
import org.uberfire.mvp.Command;

@Templated
public class LibraryView
implements LibraryScreen.View,
IsElement {
    private LibraryScreen presenter;
    @Inject
    private ProjectsDetailScreen projectsDetailScreen;
    @Inject
    private TranslationService ts;
    @Inject
    private ManagedInstance<ImportExampleListItemWidget> importExampleListItemWidgets;
    @Inject
    private ManagedInstance<ProjectItemWidget> itemWidgetsInstances;
    @Inject
    private NewProjectButtonWidget newProjectButtonWidget;
    @Inject
    @DataField(value="main-container")
    Div mainContainer;
    @Inject
    @DataField(value="details-container")
    Div detailsContainer;
    @Inject
    @DataField(value="project-list")
    Div projectList;
    @Inject
    @DataField(value="import-project-container")
    UnorderedList importProjectContainer;
    @Inject
    @DataField(value="filter-text")
    Input filterText;
    @Inject
    @DataField(value="new-project-container")
    Div newProjectContainer;
    @Inject
    @DataField(value="import-example")
    Button importProject;
    private ProjectItemWidget selectedProjectItemWidget;
    private boolean importProjectLoaded = false;

    public void init(LibraryScreen presenter) {
        this.presenter = presenter;
        this.selectedProjectItemWidget = null;
        this.filterText.setAttribute("placeholder", this.ts.getTranslation("LibraryView.Filter"));
        this.detailsContainer.appendChild((Node)this.projectsDetailScreen.getView().getElement());
        this.newProjectContainer.appendChild((Node)this.newProjectButtonWidget.getView().getElement());
    }

    @Override
    public void clearProjects() {
        DOMUtil.removeAllChildren((Node)this.projectList);
    }

    @Override
    public void addProject(String project, Command details, Command select) {
        ProjectItemWidget projectItemWidget = (ProjectItemWidget)this.itemWidgetsInstances.get();
        projectItemWidget.init(project, this.detailsCommand(details, projectItemWidget), select);
        this.projectList.appendChild((Node)projectItemWidget.getElement());
    }

    private Command detailsCommand(Command details, ProjectItemWidget projectItemWidget) {
        return () -> {
            details.execute();
            if (projectItemWidget.equals(this.selectedProjectItemWidget)) {
                this.mainContainer.getClassList().add("col-md-12");
                this.mainContainer.getClassList().add("col-lg-12");
                this.mainContainer.getClassList().remove("col-md-8");
                this.mainContainer.getClassList().remove("col-lg-9");
                this.detailsContainer.getClassList().add("hidden");
                this.detailsContainer.getClassList().remove("col-md-4");
                this.detailsContainer.getClassList().remove("col-lg-3");
                projectItemWidget.unselect();
                this.selectedProjectItemWidget = null;
            } else {
                if (this.selectedProjectItemWidget == null) {
                    this.mainContainer.getClassList().remove("col-md-12");
                    this.mainContainer.getClassList().remove("col-lg-12");
                    this.mainContainer.getClassList().add("col-md-8");
                    this.mainContainer.getClassList().add("col-lg-9");
                    this.detailsContainer.getClassList().remove("hidden");
                    this.detailsContainer.getClassList().add("col-md-4");
                    this.detailsContainer.getClassList().add("col-lg-3");
                } else {
                    this.selectedProjectItemWidget.unselect();
                }
                projectItemWidget.select();
                this.selectedProjectItemWidget = projectItemWidget;
            }
        };
    }

    @Override
    public void addProjectToImport(ExampleProject exampleProject) {
        ImportExampleListItemWidget importExampleListItem = (ImportExampleListItemWidget)this.importExampleListItemWidgets.get();
        importExampleListItem.init(exampleProject.getName(), exampleProject.getDescription(), () -> this.presenter.importProject(exampleProject));
        this.importProjectContainer.appendChild((Node)importExampleListItem.getElement());
    }

    @Override
    public void clearImportProjectsContainer() {
        this.importProjectContainer.setInnerHTML("");
    }

    @Override
    public void clearFilterText() {
        this.filterText.setValue("");
    }

    @SinkNative(value=1)
    @EventHandler(value={"import-example"})
    public void importExample(Event e) {
        if (!this.importProjectLoaded) {
            this.presenter.updateImportProjects();
            this.importProjectLoaded = true;
        }
    }

    @SinkNative(value=512)
    @EventHandler(value={"filter-text"})
    public void filterTextChange(Event e) {
        this.presenter.updateProjectsBy(this.filterText.getValue());
    }
}

