/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens;

import com.google.gwt.core.client.GWT;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.model.Project;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.library.api.LibraryInfo;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.api.ProjectInfo;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.NotificationEvent;

@WorkbenchScreen(identifier="NewProjectScreen")
public class NewProjectScreen {
    LibraryInfo libraryInfo;
    private Caller<LibraryService> libraryService;
    private PlaceManager placeManager;
    private BusyIndicatorView busyIndicatorView;
    private Event<NotificationEvent> notificationEvent;
    private LibraryPlaces libraryPlaces;
    private View view;
    private TranslationService ts;
    private SessionInfo sessionInfo;
    private Event<NewProjectEvent> newProjectEvent;

    @Inject
    public NewProjectScreen(Caller<LibraryService> libraryService, PlaceManager placeManager, BusyIndicatorView busyIndicatorView, Event<NotificationEvent> notificationEvent, LibraryPlaces libraryPlaces, View view, TranslationService ts, SessionInfo sessionInfo, Event<NewProjectEvent> newProjectEvent) {
        this.libraryService = libraryService;
        this.placeManager = placeManager;
        this.busyIndicatorView = busyIndicatorView;
        this.notificationEvent = notificationEvent;
        this.libraryPlaces = libraryPlaces;
        this.view = view;
        this.ts = ts;
        this.sessionInfo = sessionInfo;
        this.newProjectEvent = newProjectEvent;
    }

    @OnStartup
    public void load() {
        this.view.init(this);
        ((LibraryService)this.libraryService.call((RemoteCallback)new RemoteCallback<LibraryInfo>(){

            public void callback(LibraryInfo libraryInfo) {
                NewProjectScreen.this.libraryInfo = libraryInfo;
            }
        })).getLibraryInfo(this.libraryPlaces.getSelectedRepository(), this.libraryPlaces.getSelectedBranch());
    }

    public void cancel() {
        this.libraryPlaces.goToLibrary();
        this.placeManager.closePlace("NewProjectScreen");
    }

    public void createProject(String projectName) {
        this.busyIndicatorView.showBusyIndicator(this.ts.getTranslation("NewProjectScreen.Saving"));
        ((LibraryService)this.libraryService.call(this.getSuccessCallback(), this.getErrorCallBack())).createProject(projectName, this.libraryPlaces.getSelectedRepository(), this.getBaseURL());
    }

    private RemoteCallback<KieProject> getSuccessCallback() {
        return project -> {
            this.newProjectEvent.fire((Object)new NewProjectEvent((Project)project, this.sessionInfo.getId(), this.sessionInfo.getIdentity().getIdentifier()));
            this.hideLoadingBox();
            this.notifySuccess();
            this.goToProject((KieProject)project);
            this.placeManager.closePlace("NewProjectScreen");
        };
    }

    private ErrorCallback<?> getErrorCallBack() {
        return (o, throwable) -> {
            this.hideLoadingBox();
            this.notificationEvent.fire((Object)new NotificationEvent(this.ts.getTranslation("NewProjectScreen.Error"), NotificationEvent.NotificationType.ERROR));
            return false;
        };
    }

    String getBaseURL() {
        String url = GWT.getModuleBaseURL();
        String baseUrl = url.replace(GWT.getModuleName() + "/", "");
        return baseUrl;
    }

    private void goToProject(KieProject project) {
        ProjectInfo projectInfo = new ProjectInfo(this.libraryPlaces.getSelectedOrganizationalUnit(), this.libraryPlaces.getSelectedRepository(), this.libraryInfo.getSelectedBranch(), (Project)project);
        this.libraryPlaces.goToProject(projectInfo);
    }

    private void notifySuccess() {
        this.notificationEvent.fire((Object)new NotificationEvent(this.ts.getTranslation("Project_Created"), NotificationEvent.NotificationType.SUCCESS));
    }

    private void hideLoadingBox() {
        this.busyIndicatorView.hideBusyIndicator();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.ts.getTranslation("New_Project_Screen");
    }

    @WorkbenchPartView
    public UberElement<NewProjectScreen> getView() {
        return this.view;
    }

    public static interface View
    extends UberElement<NewProjectScreen> {
    }
}

