/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.ext.uberfire.social.activities.client.widgets.utils.SocialDateFormatter;
import org.guvnor.common.services.project.context.ProjectContextChangeEvent;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.explorer.client.utils.Classifier;
import org.kie.workbench.common.screens.explorer.client.utils.Utils;
import org.kie.workbench.common.screens.explorer.model.FolderItemType;
import org.kie.workbench.common.screens.library.api.AssetInfo;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.api.ProjectInfo;
import org.kie.workbench.common.screens.library.client.events.AssetDetailEvent;
import org.kie.workbench.common.screens.library.client.events.ProjectDetailEvent;
import org.kie.workbench.common.screens.library.client.perspective.LibraryPerspective;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.client.workbench.events.PlaceGainFocusEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.util.URIUtil;

@WorkbenchScreen(identifier="ProjectScreen", owningPerspective=LibraryPerspective.class)
public class ProjectScreen {
    private View view;
    private LibraryPlaces libraryPlaces;
    private TranslationService ts;
    private Caller<LibraryService> libraryService;
    private Classifier assetClassifier;
    private Event<AssetDetailEvent> assetDetailEvent;
    private Event<ProjectContextChangeEvent> projectContextChangeEvent;
    private BusyIndicatorView busyIndicatorView;
    private ProjectInfo projectInfo;
    private List<AssetInfo> assets;

    @Inject
    public ProjectScreen(View view, LibraryPlaces libraryPlaces, TranslationService ts, Caller<LibraryService> libraryService, Classifier assetClassifier, Event<AssetDetailEvent> assetDetailEvent, Event<ProjectContextChangeEvent> projectContextChangeEvent, BusyIndicatorView busyIndicatorView) {
        this.view = view;
        this.libraryPlaces = libraryPlaces;
        this.ts = ts;
        this.libraryService = libraryService;
        this.assetClassifier = assetClassifier;
        this.assetDetailEvent = assetDetailEvent;
        this.projectContextChangeEvent = projectContextChangeEvent;
        this.busyIndicatorView = busyIndicatorView;
    }

    public void onStartup(@Observes ProjectDetailEvent projectDetailEvent) {
        this.projectInfo = projectDetailEvent.getProjectInfo();
        this.loadProjectInfo();
        this.view.setProjectName(this.projectInfo.getProject().getProjectName());
    }

    public void refreshOnFocus(@Observes PlaceGainFocusEvent placeGainFocusEvent) {
        PlaceRequest place = placeGainFocusEvent.getPlace();
        if (this.projectInfo != null && place.getIdentifier().equals("ProjectScreen")) {
            this.loadProjectInfo();
        }
    }

    public void updateAssetsBy(String filter) {
        if (this.assets != null) {
            List<AssetInfo> filteredAssets = this.filterAssets(this.assets, filter);
            this.setupAssets(filteredAssets);
        }
    }

    public void goToSettings() {
        this.assetDetailEvent.fire((Object)new AssetDetailEvent(this.projectInfo, null));
    }

    public String getProjectName() {
        return this.projectInfo.getProject().getProjectName();
    }

    List<AssetInfo> filterAssets(List<AssetInfo> assets, String filter) {
        return assets.stream().filter(a -> a.getFolderItem().getFileName().toUpperCase().startsWith(filter.toUpperCase())).collect(Collectors.toList());
    }

    String getLastModifiedTime(AssetInfo asset) {
        return this.ts.format("LastModified", new Object[0]) + " " + SocialDateFormatter.format((Date)asset.getLastModifiedTime());
    }

    String getCreatedTime(AssetInfo asset) {
        return this.ts.format("Created", new Object[0]) + " " + SocialDateFormatter.format((Date)asset.getCreatedTime());
    }

    Command selectCommand(Path assetPath) {
        return () -> this.libraryPlaces.goToAsset(this.projectInfo, assetPath);
    }

    Command detailsCommand(Path assetPath) {
        return this.selectCommand(assetPath);
    }

    private void loadProjectInfo() {
        this.busyIndicatorView.showBusyIndicator(this.ts.getTranslation("LoadingAssets"));
        ((LibraryService)this.libraryService.call((RemoteCallback)new RemoteCallback<List<AssetInfo>>(){

            public void callback(List<AssetInfo> assetsList) {
                ProjectScreen.this.assets = assetsList;
                ProjectScreen.this.loadProject(ProjectScreen.this.assets);
                ProjectScreen.this.busyIndicatorView.hideBusyIndicator();
            }
        })).getProjectAssets(this.projectInfo.getProject());
    }

    private void loadProject(List<AssetInfo> assets) {
        this.setupAssets(assets);
    }

    private void setupAssets(List<AssetInfo> assets) {
        this.view.clearAssets();
        assets.stream().forEach(asset -> {
            if (!asset.getFolderItem().getType().equals((Object)FolderItemType.FOLDER)) {
                ClientResourceType assetResourceType = this.assetClassifier.findResourceType(asset.getFolderItem());
                String assetName = Utils.getBaseFileName((String)asset.getFolderItem().getFileName(), (String)assetResourceType.getSuffix());
                this.view.addAsset(assetName, this.getAssetPath((AssetInfo)asset), assetResourceType.getDescription(), assetResourceType.getIcon(), this.getLastModifiedTime((AssetInfo)asset), this.getCreatedTime((AssetInfo)asset), this.detailsCommand((Path)asset.getFolderItem().getItem()), this.selectCommand((Path)asset.getFolderItem().getItem()));
            }
        });
    }

    private String getAssetPath(AssetInfo asset) {
        String fullPath = ((Path)asset.getFolderItem().getItem()).toURI();
        String projectRootPath = this.projectInfo.getProject().getRootPath().toURI();
        String relativeAssetPath = fullPath.substring(projectRootPath.length() + 1);
        String decodedRelativeAssetPath = URIUtil.decode((String)relativeAssetPath);
        return decodedRelativeAssetPath;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return "Project Screen";
    }

    @WorkbenchPartView
    public UberElement<ProjectScreen> getView() {
        return this.view;
    }

    public static interface View
    extends UberElement<ProjectScreen> {
        public void setProjectName(String var1);

        public void clearAssets();

        public void addAsset(String var1, String var2, String var3, IsWidget var4, String var5, String var6, Command var7, Command var8);
    }
}

