/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.context.ProjectContext;
import org.guvnor.common.services.project.context.ProjectContextChangeEvent;
import org.guvnor.common.services.project.events.DeleteProjectEvent;
import org.guvnor.common.services.project.events.RenameProjectEvent;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.common.client.dom.Element;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.examples.client.wizard.ExamplesWizard;
import org.kie.workbench.common.screens.library.api.LibraryPreferences;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.api.ProjectInfo;
import org.kie.workbench.common.screens.library.client.events.AssetDetailEvent;
import org.kie.workbench.common.screens.library.client.events.ProjectDetailEvent;
import org.kie.workbench.common.screens.library.client.perspective.LibraryPerspective;
import org.kie.workbench.common.screens.library.client.util.ExamplesUtils;
import org.kie.workbench.common.screens.library.client.util.ResourceUtils;
import org.kie.workbench.common.screens.library.client.widgets.LibraryToolbarPresenter;
import org.kie.workbench.common.widgets.client.handlers.NewResourceSuccessEvent;
import org.kie.workbench.common.workbench.client.docks.AuthoringWorkbenchDocks;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.workbench.events.PlaceGainFocusEvent;
import org.uberfire.ext.editor.commons.client.event.ConcurrentRenameAcceptedEvent;
import org.uberfire.ext.widgets.common.client.breadcrumbs.UberfireBreadcrumbs;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.ConditionalPlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;

@ApplicationScoped
public class LibraryPlaces {
    public static final String LIBRARY_PERSPECTIVE = "LibraryPerspective";
    public static final String NEW_PROJECT_SCREEN = "NewProjectScreen";
    public static final String EMPTY_LIBRARY_SCREEN = "EmptyLibraryScreen";
    public static final String LIBRARY_SCREEN = "LibraryScreen";
    public static final String EMPTY_PROJECT_SCREEN = "EmptyProjectScreen";
    public static final String PROJECT_SCREEN = "ProjectScreen";
    public static final String PROJECT_DETAIL_SCREEN = "ProjectsDetailScreen";
    public static final String PROJECT_SETTINGS = "projectScreen";
    public static final String PROJECT_EXPLORER = "org.kie.guvnor.explorer";
    public static final String MESSAGES = "org.kie.workbench.common.screens.messageconsole.MessageConsole";
    public static final List<String> LIBRARY_PLACES = Collections.unmodifiableList(new ArrayList<String>(7){
        {
            this.add(LibraryPlaces.NEW_PROJECT_SCREEN);
            this.add(LibraryPlaces.EMPTY_LIBRARY_SCREEN);
            this.add(LibraryPlaces.LIBRARY_SCREEN);
            this.add(LibraryPlaces.EMPTY_PROJECT_SCREEN);
            this.add(LibraryPlaces.PROJECT_SCREEN);
            this.add(LibraryPlaces.PROJECT_DETAIL_SCREEN);
            this.add(LibraryPlaces.PROJECT_SETTINGS);
        }
    });
    private UberfireBreadcrumbs breadcrumbs;
    private TranslationService ts;
    private Event<ProjectDetailEvent> projectDetailEvent;
    private Event<AssetDetailEvent> assetDetailEvent;
    private ResourceUtils resourceUtils;
    private Caller<LibraryService> libraryService;
    private PlaceManager placeManager;
    private LibraryPerspective libraryPerspective;
    private ProjectContext projectContext;
    private LibraryToolbarPresenter libraryToolbar;
    private AuthoringWorkbenchDocks docks;
    private LibraryPreferences libraryPreferences;
    private Event<ProjectContextChangeEvent> projectContextChangeEvent;
    private ExamplesUtils examplesUtils;
    private Event<NotificationEvent> notificationEvent;
    private ManagedInstance<ExamplesWizard> examplesWizards;
    private boolean docksReady = false;
    private boolean docksHidden = true;
    private Project lastViewedProject = null;
    private boolean closingLibraryPlaces = false;

    @Inject
    public LibraryPlaces(UberfireBreadcrumbs breadcrumbs, TranslationService ts, Event<ProjectDetailEvent> projectDetailEvent, Event<AssetDetailEvent> assetDetailEvent, ResourceUtils resourceUtils, Caller<LibraryService> libraryService, PlaceManager placeManager, LibraryPerspective libraryPerspective, ProjectContext projectContext, LibraryToolbarPresenter libraryToolbar, AuthoringWorkbenchDocks docks, LibraryPreferences libraryPreferences, Event<ProjectContextChangeEvent> projectContextChangeEvent, ExamplesUtils examplesUtils, Event<NotificationEvent> notificationEvent, ManagedInstance<ExamplesWizard> examplesWizards) {
        this.breadcrumbs = breadcrumbs;
        this.ts = ts;
        this.projectDetailEvent = projectDetailEvent;
        this.assetDetailEvent = assetDetailEvent;
        this.resourceUtils = resourceUtils;
        this.libraryService = libraryService;
        this.placeManager = placeManager;
        this.libraryPerspective = libraryPerspective;
        this.projectContext = projectContext;
        this.libraryToolbar = libraryToolbar;
        this.docks = docks;
        this.libraryPreferences = libraryPreferences;
        this.projectContextChangeEvent = projectContextChangeEvent;
        this.examplesUtils = examplesUtils;
        this.notificationEvent = notificationEvent;
        this.examplesWizards = examplesWizards;
    }

    public ProjectInfo getProjectInfo() {
        return new ProjectInfo(this.projectContext.getActiveOrganizationalUnit(), this.projectContext.getActiveRepository(), this.projectContext.getActiveBranch(), this.projectContext.getActiveProject());
    }

    public void onSelectPlaceEvent(@Observes PlaceGainFocusEvent placeGainFocusEvent) {
        if (this.placeManager.getStatus(LIBRARY_PERSPECTIVE).equals((Object)PlaceStatus.OPEN) && !this.closingLibraryPlaces) {
            ProjectInfo projectInfo = this.getProjectInfo();
            PlaceRequest place = placeGainFocusEvent.getPlace();
            if (place instanceof PathPlaceRequest) {
                PathPlaceRequest pathPlaceRequest = (PathPlaceRequest)place;
                this.setupLibraryBreadCrumbsForAsset(projectInfo, (Path)pathPlaceRequest.getPath());
                this.showDocks();
            } else if (this.isLibraryPlace(place)) {
                this.hideDocks();
                if (place.getIdentifier().equals(PROJECT_SETTINGS)) {
                    this.setupLibraryBreadCrumbsForAsset(projectInfo, null);
                } else if (projectInfo.getProject() != null && (place.getIdentifier().equals(PROJECT_SCREEN) || place.getIdentifier().equals(EMPTY_PROJECT_SCREEN))) {
                    this.setupLibraryBreadCrumbsForProject(projectInfo);
                }
            }
        }
    }

    public void hideDocks() {
        if (!this.docksHidden) {
            this.docks.hide();
            this.docksHidden = true;
        }
    }

    public void showDocks() {
        if (this.docksHidden) {
            if (!this.docksReady) {
                this.docks.setup(LIBRARY_PERSPECTIVE, (PlaceRequest)new DefaultPlaceRequest(PROJECT_EXPLORER));
                this.docksReady = true;
            }
            this.docks.show();
            this.docksHidden = false;
            this.libraryPreferences.load(loadedLibraryPreferences -> {
                if (loadedLibraryPreferences.isProjectExplorerExpanded()) {
                    this.docks.expandProjectExplorer();
                }
            }, parameter -> {});
        }
    }

    private boolean isLibraryPlace(PlaceRequest place) {
        return LIBRARY_PLACES.contains(place.getIdentifier());
    }

    public void newResourceCreated(@Observes NewResourceSuccessEvent newResourceSuccessEvent) {
        if (this.placeManager.getStatus(LIBRARY_PERSPECTIVE).equals((Object)PlaceStatus.OPEN)) {
            this.assetDetailEvent.fire((Object)new AssetDetailEvent(this.getProjectInfo(), newResourceSuccessEvent.getPath()));
        }
    }

    public void assetRenamedAccepted(@Observes ConcurrentRenameAcceptedEvent concurrentRenameAcceptedEvent) {
        if (this.placeManager.getStatus(LIBRARY_PERSPECTIVE).equals((Object)PlaceStatus.OPEN)) {
            ProjectInfo projectInfo = this.getProjectInfo();
            ObservablePath path = concurrentRenameAcceptedEvent.getPath();
            this.goToAsset(projectInfo, (Path)path);
            this.setupLibraryBreadCrumbsForAsset(projectInfo, (Path)path);
        }
    }

    public void projectDeleted(@Observes DeleteProjectEvent deleteProjectEvent) {
        if (this.placeManager.getStatus(LIBRARY_PERSPECTIVE).equals((Object)PlaceStatus.OPEN) && deleteProjectEvent.getProject().equals((Object)this.lastViewedProject)) {
            this.goToLibrary();
            this.notificationEvent.fire((Object)new NotificationEvent(this.ts.getTranslation("ProjectDeleted"), NotificationEvent.NotificationType.DEFAULT));
        }
    }

    public void projectRenamed(@Observes RenameProjectEvent renameProjectEvent) {
        if (this.placeManager.getStatus(LIBRARY_PERSPECTIVE).equals((Object)PlaceStatus.OPEN)) {
            Project activeProject = this.projectContext.getActiveProject();
            if (renameProjectEvent.getOldProject().equals((Object)activeProject)) {
                this.setupLibraryBreadCrumbsForAsset(new ProjectInfo(this.projectContext.getActiveOrganizationalUnit(), this.projectContext.getActiveRepository(), this.projectContext.getActiveBranch(), renameProjectEvent.getNewProject()), null);
                this.lastViewedProject = renameProjectEvent.getNewProject();
            }
        }
    }

    public void assetSelected(@Observes AssetDetailEvent assetDetails) {
        this.goToAsset(assetDetails.getProjectInfo(), assetDetails.getPath());
    }

    public void projectContextChange() {
        ProjectInfo projectInfo = new ProjectInfo(this.projectContext.getActiveOrganizationalUnit(), this.projectContext.getActiveRepository(), this.projectContext.getActiveBranch(), this.projectContext.getActiveProject());
        if (this.placeManager.getStatus(LIBRARY_PERSPECTIVE).equals((Object)PlaceStatus.OPEN)) {
            if (this.libraryToolbar.getSelectedOrganizationalUnit() != null && !this.projectContext.getActiveOrganizationalUnit().equals(this.libraryToolbar.getSelectedOrganizationalUnit()) || this.libraryToolbar.getSelectedRepository() != null && !this.projectContext.getActiveRepository().equals(this.libraryToolbar.getSelectedRepository()) || this.libraryToolbar.getSelectedBranch() != null && !this.projectContext.getActiveBranch().equals(this.libraryToolbar.getSelectedBranch())) {
                this.libraryToolbar.setSelectedInfo(this.projectContext.getActiveOrganizationalUnit(), this.projectContext.getActiveRepository(), () -> {
                    if (this.projectContext.getActiveProject() != null) {
                        this.goToProject(projectInfo, false);
                    }
                });
            } else if (this.projectContext.getActiveProject() != null && !this.projectContext.getActiveProject().equals((Object)this.lastViewedProject)) {
                this.goToProject(projectInfo, false);
            }
        }
    }

    public void setupToolBar() {
        this.breadcrumbs.clearBreadCrumbsAndToolBars(LIBRARY_PERSPECTIVE);
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.getOURepoLabel(), () -> this.goToLibrary());
        this.breadcrumbs.addToolbar(LIBRARY_PERSPECTIVE, (Element)this.libraryToolbar.getView().getElement());
    }

    public void setupLibraryBreadCrumbs() {
        this.breadcrumbs.clearBreadCrumbs(LIBRARY_PERSPECTIVE);
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.getOURepoLabel(), () -> this.goToLibrary());
    }

    public void setupLibraryBreadCrumbsForNewProject() {
        this.breadcrumbs.clearBreadCrumbs(LIBRARY_PERSPECTIVE);
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.getOURepoLabel(), () -> this.goToLibrary());
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.ts.getTranslation("NewProject"), () -> this.goToNewProject());
    }

    public void setupLibraryBreadCrumbsForProject(ProjectInfo projectInfo) {
        this.breadcrumbs.clearBreadCrumbs(LIBRARY_PERSPECTIVE);
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.getOURepoLabel(), () -> this.goToLibrary());
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, projectInfo.getProject().getProjectName(), () -> this.goToProject(projectInfo));
    }

    public void setupLibraryBreadCrumbsForAsset(ProjectInfo projectInfo, Path path) {
        String assetName = path != null ? this.resourceUtils.getBaseFileName(path) : this.ts.format("Settings", new Object[0]);
        this.breadcrumbs.clearBreadCrumbs(LIBRARY_PERSPECTIVE);
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.getOURepoLabel(), () -> this.goToLibrary());
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, projectInfo.getProject().getProjectName(), () -> this.goToProject(projectInfo));
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, assetName, () -> this.goToAsset(projectInfo, path));
    }

    public void refresh() {
        this.libraryToolbar.init(() -> {
            this.setupToolBar();
            this.goToLibrary();
            this.examplesUtils.refresh();
        });
    }

    public void goToLibrary() {
        this.goToLibrary(null);
    }

    public void goToLibrary(final Command callback) {
        ((LibraryService)this.libraryService.call((RemoteCallback)new RemoteCallback<Boolean>(){

            public void callback(Boolean hasProjects) {
                ((LibraryService)LibraryPlaces.this.libraryService.call(libraryInfo -> {
                    PlaceRequest placeRequest = new ConditionalPlaceRequest(LibraryPlaces.LIBRARY_SCREEN).when(p -> hasProjects).orElse((PlaceRequest)new DefaultPlaceRequest(LibraryPlaces.EMPTY_LIBRARY_SCREEN));
                    PartDefinitionImpl part = new PartDefinitionImpl(placeRequest);
                    part.setSelectable(false);
                    LibraryPlaces.this.closeLibraryPlaces();
                    LibraryPlaces.this.placeManager.goTo((PartDefinition)part, LibraryPlaces.this.libraryPerspective.getRootPanel());
                    LibraryPlaces.this.setupLibraryBreadCrumbs();
                    LibraryPlaces.this.hideDocks();
                    if (callback != null) {
                        callback.execute();
                    } else {
                        LibraryPlaces.this.projectContextChangeEvent.fire((Object)new ProjectContextChangeEvent(LibraryPlaces.this.getSelectedOrganizationalUnit(), LibraryPlaces.this.getSelectedRepository(), LibraryPlaces.this.getSelectedBranch()));
                    }
                })).getLibraryInfo(LibraryPlaces.this.getSelectedRepository(), LibraryPlaces.this.getSelectedBranch());
            }
        })).hasProjects(this.getSelectedRepository(), this.getSelectedBranch());
    }

    public void goToProject(ProjectInfo projectInfo) {
        this.goToProject(projectInfo, true);
    }

    public void goToProject(ProjectInfo projectInfo, boolean fireProjectContextChangeEvent) {
        ((LibraryService)this.libraryService.call(hasAssets -> {
            PlaceRequest projectScreen = new ConditionalPlaceRequest(PROJECT_SCREEN).when(p -> (Boolean)hasAssets).orElse((PlaceRequest)new DefaultPlaceRequest(EMPTY_PROJECT_SCREEN));
            PartDefinitionImpl part = new PartDefinitionImpl(projectScreen);
            part.setSelectable(false);
            boolean goToProject = true;
            if (!projectInfo.getProject().equals((Object)this.lastViewedProject)) {
                goToProject = this.closeAllPlacesOrNothing();
            }
            if (goToProject) {
                this.placeManager.goTo((PartDefinition)part, this.libraryPerspective.getRootPanel());
                this.projectDetailEvent.fire((Object)new ProjectDetailEvent(projectInfo));
                this.lastViewedProject = projectInfo.getProject();
                if (fireProjectContextChangeEvent) {
                    this.projectContextChangeEvent.fire((Object)new ProjectContextChangeEvent(projectInfo.getOrganizationalUnit(), projectInfo.getRepository(), projectInfo.getBranch(), projectInfo.getProject()));
                }
                this.setupLibraryBreadCrumbsForProject(projectInfo);
            }
        })).hasAssets(projectInfo.getProject());
    }

    public void goToAsset(ProjectInfo projectInfo, Path path) {
        PlaceRequest placeRequest = this.generatePlaceRequest(path);
        this.placeManager.goTo(placeRequest);
        if (path != null) {
            ObservablePath observablePath = ((PathPlaceRequest)placeRequest).getPath();
            observablePath.onRename(() -> this.setupLibraryBreadCrumbsForAsset(projectInfo, (Path)observablePath));
        }
    }

    public void goToNewProject() {
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest(NEW_PROJECT_SCREEN);
        PartDefinitionImpl part = new PartDefinitionImpl((PlaceRequest)placeRequest);
        part.setSelectable(false);
        this.closeLibraryPlaces();
        this.placeManager.goTo((PartDefinition)part, this.libraryPerspective.getRootPanel());
        this.setupLibraryBreadCrumbsForNewProject();
    }

    public void goToSettings(ProjectInfo projectInfo) {
        this.assetDetailEvent.fire((Object)new AssetDetailEvent(projectInfo, null));
    }

    public void goToImportProjectWizard() {
        String organizationalUnitName = this.projectContext.getActiveOrganizationalUnit().getName();
        String repositoryAlias = this.projectContext.getActiveRepository().getAlias();
        ExamplesWizard examplesWizard = (ExamplesWizard)this.examplesWizards.get();
        examplesWizard.start();
        examplesWizard.setDefaultTargetOrganizationalUnit(organizationalUnitName);
        examplesWizard.setDefaultTargetRepository(repositoryAlias);
    }

    public void goToMessages() {
        this.placeManager.goTo(MESSAGES);
    }

    public OrganizationalUnit getSelectedOrganizationalUnit() {
        return this.libraryToolbar.getSelectedOrganizationalUnit();
    }

    public Repository getSelectedRepository() {
        return this.libraryToolbar.getSelectedRepository();
    }

    public String getSelectedBranch() {
        return this.libraryToolbar.getSelectedBranch();
    }

    PlaceRequest generatePlaceRequest(Path path) {
        if (path == null) {
            return new DefaultPlaceRequest(PROJECT_SETTINGS);
        }
        return this.createPathPlaceRequest(path);
    }

    PathPlaceRequest createPathPlaceRequest(Path path) {
        return new PathPlaceRequest(path);
    }

    private String getOURepoLabel() {
        return this.getSelectedOrganizationalUnit().getName() + " (" + this.getSelectedRepository().getAlias() + ")";
    }

    void closeLibraryPlaces() {
        this.closingLibraryPlaces = true;
        LIBRARY_PLACES.forEach(place -> this.placeManager.closePlace(place));
        this.closingLibraryPlaces = false;
    }

    boolean closeAllPlacesOrNothing() {
        this.closingLibraryPlaces = true;
        boolean placesClosed = this.placeManager.closeAllPlacesOrNothing();
        this.closingLibraryPlaces = false;
        return placesClosed;
    }
}

