/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.widgets;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.common.client.api.Caller;
import org.kie.workbench.common.screens.library.api.LibraryPreferences;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.api.OrganizationalUnitRepositoryInfo;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.mvp.Command;

@ApplicationScoped
public class LibraryToolbarPresenter {
    private View view;
    private Caller<LibraryService> libraryService;
    private LibraryPreferences libraryPreferences;
    private PlaceManager placeManager;
    private LibraryPlaces libraryPlaces;
    private OrganizationalUnitRepositoryInfo info;
    private OrganizationalUnit selectedOrganizationalUnit;
    private Repository selectedRepository;
    private String selectedBranch;

    @Inject
    public LibraryToolbarPresenter(View view, Caller<LibraryService> libraryService, LibraryPreferences libraryPreferences, PlaceManager placeManager, LibraryPlaces libraryPlaces) {
        this.view = view;
        this.libraryService = libraryService;
        this.libraryPreferences = libraryPreferences;
        this.placeManager = placeManager;
        this.libraryPlaces = libraryPlaces;
    }

    public void init(Command callback) {
        ((LibraryService)this.libraryService.call(info -> {
            this.info = info;
            this.view.init(this);
            this.setupOrganizationUnits((OrganizationalUnitRepositoryInfo)info);
            this.setupRepositories((OrganizationalUnitRepositoryInfo)info);
            this.selectedOrganizationalUnit = info.getSelectedOrganizationalUnit();
            this.selectedRepository = info.getSelectedRepository();
            this.selectedBranch = info.getSelectedRepository().getDefaultBranch();
            this.setBranchSelectorVisibility();
            callback.execute();
        })).getDefaultOrganizationalUnitRepositoryInfo();
        this.libraryPreferences.load(loadedLibraryPreferences -> this.view.setOrganizationalUnitLabel(loadedLibraryPreferences.getOuAlias()), parameter -> {});
    }

    public void setSelectedInfo(OrganizationalUnit organizationalUnit, Repository repository, Command callback) {
        ((LibraryService)this.libraryService.call(newInfo -> {
            this.setupOrganizationUnits((OrganizationalUnitRepositoryInfo)newInfo);
            newInfo.setSelectedRepository(repository);
            this.refreshLibrary((OrganizationalUnitRepositoryInfo)newInfo, callback);
        })).getOrganizationalUnitRepositoryInfo(organizationalUnit);
    }

    private void setupOrganizationUnits(OrganizationalUnitRepositoryInfo info) {
        this.view.clearOrganizationalUnits();
        info.getOrganizationalUnits().forEach(ou -> this.view.addOrganizationUnit(ou.getIdentifier()));
        this.view.setSelectedOrganizationalUnit(info.getSelectedOrganizationalUnit().getIdentifier());
    }

    private void setupRepositories(OrganizationalUnitRepositoryInfo info) {
        this.view.clearRepositories();
        info.getRepositories().forEach(repo -> this.view.addRepository(repo.getAlias()));
        this.view.setSelectedRepository(info.getSelectedRepository().getAlias());
        this.setUpBranches(info.getSelectedRepository().getDefaultBranch(), info.getSelectedRepository());
    }

    private void setUpBranches(String selectedBranch, Repository repository) {
        this.view.clearBranches();
        for (String branchName : repository.getBranches()) {
            this.view.addBranch(branchName);
        }
        this.view.setSelectedBranch(selectedBranch);
    }

    void onUpdateSelectedOrganizationalUnit() {
        OrganizationalUnit selectedOrganizationalUnit = this.getViewSelectedOrganizationalUnit();
        ((LibraryService)this.libraryService.call(newInfo -> this.refreshLibrary((OrganizationalUnitRepositoryInfo)newInfo))).getOrganizationalUnitRepositoryInfo(selectedOrganizationalUnit);
        this.libraryPreferences.setOuIdentifier(selectedOrganizationalUnit.getIdentifier());
        this.libraryPreferences.save();
    }

    void onUpdateSelectedRepository() {
        this.refreshLibrary(null);
        this.setUpBranches(this.selectedBranch, this.selectedRepository);
        this.libraryPreferences.setRepositoryAlias(this.selectedRepository.getAlias());
        this.libraryPreferences.save();
    }

    void onUpdateSelectedBranch() {
        this.refreshLibrary(null);
    }

    private void refreshLibrary(OrganizationalUnitRepositoryInfo newInfo) {
        this.refreshLibrary(newInfo, null);
    }

    private void refreshLibrary(OrganizationalUnitRepositoryInfo newInfo, Command callback) {
        if (this.placeManager.closeAllPlacesOrNothing()) {
            if (newInfo != null) {
                this.info = newInfo;
                this.setupRepositories(this.info);
            }
            this.selectedOrganizationalUnit = this.getViewSelectedOrganizationalUnit();
            this.selectedRepository = this.getViewSelectedRepository();
            this.selectedBranch = this.getViewSelectedBranch();
            this.setBranchSelectorVisibility();
            this.libraryPlaces.goToLibrary(callback);
        } else {
            this.view.setSelectedOrganizationalUnit(this.selectedOrganizationalUnit.getIdentifier());
            this.view.setSelectedRepository(this.selectedRepository.getAlias());
            this.setUpBranches(this.selectedBranch, this.selectedRepository);
        }
    }

    private void setBranchSelectorVisibility() {
        this.view.setBranchSelectorVisibility(this.selectedRepository.getBranches().size() > 1);
    }

    private String getViewSelectedBranch() {
        if (!this.selectedRepository.getBranches().contains(this.view.getSelectedBranch())) {
            return this.selectedRepository.getDefaultBranch();
        }
        return this.view.getSelectedBranch();
    }

    public OrganizationalUnit getSelectedOrganizationalUnit() {
        return this.selectedOrganizationalUnit;
    }

    public Repository getSelectedRepository() {
        return this.selectedRepository;
    }

    private OrganizationalUnit getViewSelectedOrganizationalUnit() {
        return this.info.getOrganizationalUnits().stream().filter(ou -> ou.getIdentifier().equals(this.view.getSelectedOrganizationalUnit())).findFirst().get();
    }

    private Repository getViewSelectedRepository() {
        return this.info.getRepositories().stream().filter(repo -> repo.getAlias().equals(this.view.getSelectedRepository())).findFirst().get();
    }

    public UberElement<LibraryToolbarPresenter> getView() {
        return this.view;
    }

    public String getSelectedBranch() {
        return this.selectedBranch;
    }

    public static interface View
    extends UberElement<LibraryToolbarPresenter> {
        public void setOrganizationalUnitLabel(String var1);

        public void clearOrganizationalUnits();

        public void addOrganizationUnit(String var1);

        public String getSelectedOrganizationalUnit();

        public void setSelectedOrganizationalUnit(String var1);

        public void clearRepositories();

        public void addRepository(String var1);

        public String getSelectedRepository();

        public void setSelectedRepository(String var1);

        public void clearBranches();

        public void addBranch(String var1);

        public String getSelectedBranch();

        public void setSelectedBranch(String var1);

        public void setBranchSelectorVisibility(boolean var1);
    }
}

