/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.widgets;

import javax.inject.Inject;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Document;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Label;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Option;
import org.jboss.errai.common.client.dom.Select;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.widgets.LibraryToolbarPresenter;

@Templated
public class LibraryToolbarView
implements LibraryToolbarPresenter.View,
IsElement {
    @Inject
    Document document;
    @Inject
    @DataField
    Label organizationalUnitsLabel;
    @Inject
    @DataField
    Select organizationalUnits;
    @Inject
    @DataField
    Select repositories;
    @Inject
    @DataField
    Label branchesLabel;
    @Inject
    @DataField
    Select branches;
    private LibraryToolbarPresenter presenter;

    public void init(LibraryToolbarPresenter presenter) {
        this.presenter = presenter;
        this.organizationalUnits.setOnchange(event -> presenter.onUpdateSelectedOrganizationalUnit());
        this.repositories.setOnchange(event -> presenter.onUpdateSelectedRepository());
        this.branches.setOnchange(event -> presenter.onUpdateSelectedBranch());
    }

    @Override
    public void setOrganizationalUnitLabel(String label) {
        this.organizationalUnitsLabel.setTextContent(label + ": ");
    }

    @Override
    public void clearOrganizationalUnits() {
        DOMUtil.removeAllChildren((Node)this.organizationalUnits);
    }

    @Override
    public void addOrganizationUnit(String identifier) {
        this.organizationalUnits.add((HTMLElement)this.createOption(identifier));
    }

    @Override
    public String getSelectedOrganizationalUnit() {
        return this.organizationalUnits.getValue();
    }

    @Override
    public void setSelectedOrganizationalUnit(String identifier) {
        this.organizationalUnits.setValue(identifier);
    }

    @Override
    public void clearRepositories() {
        DOMUtil.removeAllChildren((Node)this.repositories);
    }

    @Override
    public void addRepository(String alias) {
        this.repositories.add((HTMLElement)this.createOption(alias));
    }

    @Override
    public String getSelectedRepository() {
        return this.repositories.getValue();
    }

    @Override
    public void setSelectedRepository(String alias) {
        this.repositories.setValue(alias);
    }

    @Override
    public void clearBranches() {
        DOMUtil.removeAllChildren((Node)this.branches);
    }

    @Override
    public void addBranch(String branchName) {
        this.branches.add((HTMLElement)this.createOption(branchName));
    }

    @Override
    public String getSelectedBranch() {
        return this.branches.getValue();
    }

    @Override
    public void setSelectedBranch(String branchName) {
        this.branches.setValue(branchName);
    }

    @Override
    public void setBranchSelectorVisibility(boolean visible) {
        this.branches.getStyle().setProperty("visibility", this.getVisibility(visible));
        this.branchesLabel.getStyle().setProperty("visibility", this.getVisibility(visible));
        if (visible) {
            this.expand((HTMLElement)this.branches);
            this.expand((HTMLElement)this.branchesLabel);
        } else {
            this.shrink((HTMLElement)this.branches);
            this.shrink((HTMLElement)this.branchesLabel);
        }
    }

    private void shrink(HTMLElement element) {
        element.getStyle().setProperty("width", "0px");
        element.getStyle().setProperty("border", "0px");
        element.getStyle().setProperty("padding", "0px");
    }

    private void expand(HTMLElement element) {
        element.getStyle().removeProperty("width");
        element.getStyle().removeProperty("border");
        element.getStyle().removeProperty("padding");
    }

    private String getVisibility(boolean visible) {
        if (visible) {
            return "visible";
        }
        return "hidden";
    }

    private Option createOption(String ou) {
        Option option = (Option)this.document.createElement("option");
        option.setText(ou);
        return option;
    }
}

