/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.widgets;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.ListItem;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.SinkNative;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.widgets.MenuResourceHandlerWidget;
import org.kie.workbench.common.screens.library.client.widgets.NewProjectButtonWidget;
import org.kie.workbench.common.widgets.client.handlers.NewProjectHandler;
import org.uberfire.mvp.Command;

@Templated
public class NewProjectButtonView
implements NewProjectButtonWidget.View,
IsElement {
    private NewProjectButtonWidget presenter;
    @Inject
    private TranslationService ts;
    @Inject
    private ManagedInstance<MenuResourceHandlerWidget> menuProjectHandlerWidgets;
    @Inject
    @DataField(value="project-handler-menu-container")
    UnorderedList projectHandlerMenuContainer;
    @Inject
    @DataField(value="import-project-wizard-button")
    Button importWizardButton;

    public void init(NewProjectButtonWidget presenter) {
        this.presenter = presenter;
        this.projectHandlerMenuContainer.setTextContent("");
    }

    @Override
    public void addNewProjectHandler(String description, NewProjectHandler newProjectHandler) {
        this.addNewProjectHandler(description, newProjectHandler.getCommand(this.presenter.getNewResourcePresenter()));
    }

    @Override
    public void addNewProjectHandler(String description, Command command) {
        MenuResourceHandlerWidget menuProjectHandlerWidget = (MenuResourceHandlerWidget)this.menuProjectHandlerWidgets.get();
        menuProjectHandlerWidget.init(description, command);
        this.projectHandlerMenuContainer.appendChild((Node)menuProjectHandlerWidget.getElement());
    }

    @Override
    public void addHeader(String title) {
        ListItem header = (ListItem)DOM.createElement((String)"li");
        header.getClassList().add("dropdown-header");
        header.setTextContent(title);
        this.projectHandlerMenuContainer.appendChild((Node)header);
    }

    @SinkNative(value=1)
    @EventHandler(value={"import-project-wizard-button"})
    public void importWizardButton(Event e) {
        this.presenter.openImportWizard();
    }

    @Override
    public String getDefaultProjectHeaderTitle() {
        return this.ts.getTranslation("DefaultProject");
    }

    @Override
    public String getQuickSetupDescription() {
        return this.ts.getTranslation("QuickSetup");
    }

    @Override
    public String getAdvancedSetupDescription() {
        return this.ts.getTranslation("AdvancedSetup");
    }

    @Override
    public String getOtherProjectsHeaderTitle() {
        return this.ts.getTranslation("OtherProjects");
    }
}

