/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens;

import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.IsWidget;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Form;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.SinkNative;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.screens.ProjectScreen;
import org.kie.workbench.common.screens.library.client.screens.ProjectsDetailScreen;
import org.kie.workbench.common.screens.library.client.widgets.AssetItemWidget;
import org.kie.workbench.common.screens.library.client.widgets.AssetsActionsWidget;
import org.kie.workbench.common.screens.library.client.widgets.ProjectActionsWidget;
import org.uberfire.mvp.Command;

@Templated
public class ProjectView
implements ProjectScreen.View,
IsElement {
    private ProjectScreen presenter;
    @Inject
    private ProjectsDetailScreen projectsDetailScreen;
    @Inject
    private ManagedInstance<AssetItemWidget> itemWidgetsInstances;
    @Inject
    private TranslationService ts;
    @Inject
    private ProjectActionsWidget projectActionsWidget;
    @Inject
    private AssetsActionsWidget assetsActionsWidget;
    @Inject
    @DataField(value="project-toolbar")
    Div projectToolbar;
    @Inject
    @DataField(value="assets-toolbar")
    Form assetsToolbar;
    @Inject
    @DataField(value="details-container")
    Div detailsContainer;
    @Inject
    @DataField(value="asset-list")
    Div assetList;
    @Inject
    @DataField(value="filter-text")
    Input filterText;
    @Inject
    @DataField(value="project-name")
    Div projectNameContainer;

    public void init(ProjectScreen presenter) {
        this.presenter = presenter;
        this.assetsActionsWidget.init();
        this.projectActionsWidget.init(presenter::goToSettings);
        this.filterText.setAttribute("placeholder", this.ts.getTranslation("FilterByName"));
        this.detailsContainer.appendChild((Node)this.projectsDetailScreen.getView().getElement());
        this.assetsToolbar.appendChild((Node)this.assetsActionsWidget.getView().getElement());
        this.projectToolbar.appendChild((Node)this.projectActionsWidget.getView().getElement());
    }

    @Override
    public void setProjectName(String projectName) {
        this.projectNameContainer.setTextContent(projectName);
    }

    @Override
    public void clearAssets() {
        DOMUtil.removeAllChildren((Node)this.assetList);
    }

    @Override
    public void addAsset(String assetName, String assetPath, String assetType, IsWidget assetIcon, String lastModifiedDate, String createdDate, Command details, Command select) {
        AssetItemWidget assetItemWidget = (AssetItemWidget)this.itemWidgetsInstances.get();
        assetItemWidget.init(assetName, assetPath, assetType, assetIcon, lastModifiedDate, createdDate, details, select);
        this.assetList.appendChild((Node)assetItemWidget.getElement());
    }

    @SinkNative(value=512)
    @EventHandler(value={"filter-text"})
    public void filterTextChange(Event e) {
        this.presenter.updateAssetsBy(this.filterText.getValue());
    }
}

