/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.organizationalunit;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.OrganizationalUnitsScreen;
import org.kie.workbench.common.screens.library.client.util.TranslationUtils;
import org.kie.workbench.common.screens.library.client.widgets.organizationalunit.OrganizationalUnitTileWidget;

@Templated
public class OrganizationalUnitsView
implements OrganizationalUnitsScreen.View,
IsElement {
    private OrganizationalUnitsScreen presenter;
    @Inject
    private TranslationService ts;
    @Inject
    private TranslationUtils translationUtils;
    @Inject
    @DataField(value="title")
    Div title;
    @Inject
    @DataField(value="filter-name")
    Input filterName;
    @Inject
    @DataField(value="create-organizational-unit")
    Button createOrganizationalUnit;
    @Inject
    @DataField(value="cards-container")
    Div cardsContainer;

    public void init(OrganizationalUnitsScreen presenter) {
        this.presenter = presenter;
        this.createOrganizationalUnit.setTextContent(this.ts.format("CreateOrganizationalUnit", new Object[]{this.translationUtils.getOrganizationalUnitAliasInSingular()}));
        this.title.setTextContent(this.translationUtils.getOrganizationalUnitAliasInPlural());
        this.filterName.setAttribute("placeholder", this.ts.getTranslation("FilterByName"));
    }

    @Override
    public void clearOrganizationalUnits() {
        this.cardsContainer.setTextContent("");
    }

    @Override
    public String getFilterName() {
        return this.filterName.getValue();
    }

    @Override
    public void hideCreateOrganizationalUnitAction() {
        this.createOrganizationalUnit.setHidden(true);
    }

    @Override
    public void addOrganizationalUnit(OrganizationalUnitTileWidget organizationalUnitTileWidget) {
        this.cardsContainer.appendChild((Node)organizationalUnitTileWidget.getView().getElement());
    }

    @EventHandler(value={"create-organizational-unit"})
    public void createOrganizationalUnit(ClickEvent event) {
        this.presenter.createOrganizationalUnit();
    }

    @EventHandler(value={"filter-name"})
    public void filterTextChange(KeyUpEvent event) {
        this.presenter.refresh();
    }
}

