/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.util;

import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.model.Project;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.examples.model.ExampleProject;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.api.ProjectInfo;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.NotificationEvent;

@ApplicationScoped
public class ExamplesUtils {
    private SessionInfo sessionInfo;
    private TranslationService ts;
    private LibraryPlaces libraryPlaces;
    private Caller<LibraryService> libraryService;
    private BusyIndicatorView busyIndicatorView;
    private Event<NotificationEvent> notificationEvent;
    private Event<NewProjectEvent> newProjectEvent;
    private Set<ExampleProject> exampleProjects;

    @Inject
    public ExamplesUtils(SessionInfo sessionInfo, TranslationService ts, LibraryPlaces libraryPlaces, Caller<LibraryService> libraryService, BusyIndicatorView busyIndicatorView, Event<NotificationEvent> notificationEvent, Event<NewProjectEvent> newProjectEvent) {
        this.sessionInfo = sessionInfo;
        this.ts = ts;
        this.libraryPlaces = libraryPlaces;
        this.libraryService = libraryService;
        this.busyIndicatorView = busyIndicatorView;
        this.notificationEvent = notificationEvent;
        this.newProjectEvent = newProjectEvent;
    }

    public void refresh() {
        this.exampleProjects = null;
    }

    public void getExampleProjects(final ParameterizedCommand<Set<ExampleProject>> callback) {
        if (this.exampleProjects == null) {
            ((LibraryService)this.libraryService.call((RemoteCallback)new RemoteCallback<Set<ExampleProject>>(){

                public void callback(Set<ExampleProject> exampleProjects) {
                    ExamplesUtils.this.exampleProjects = exampleProjects;
                    callback.execute(exampleProjects);
                }
            })).getExampleProjects();
        } else {
            callback.execute(this.exampleProjects);
        }
    }

    public void importProject(ExampleProject exampleProject) {
        this.busyIndicatorView.showBusyIndicator(this.ts.getTranslation("Importing"));
        ((LibraryService)this.libraryService.call(project -> {
            this.busyIndicatorView.hideBusyIndicator();
            this.notificationEvent.fire((Object)new NotificationEvent(this.ts.getTranslation("ProjectImportedSuccessfully"), NotificationEvent.NotificationType.SUCCESS));
            this.newProjectEvent.fire((Object)new NewProjectEvent(project, this.sessionInfo.getId(), this.sessionInfo.getIdentity().getIdentifier()));
            this.goToProject((Project)project);
        }, (o, throwable) -> {
            this.busyIndicatorView.hideBusyIndicator();
            this.notificationEvent.fire((Object)new NotificationEvent(this.ts.getTranslation("ProjectImportError"), NotificationEvent.NotificationType.ERROR));
            return false;
        })).importProject(this.libraryPlaces.getSelectedOrganizationalUnit(), this.libraryPlaces.getSelectedRepository(), this.libraryPlaces.getSelectedBranch(), exampleProject);
    }

    private void goToProject(Project project) {
        ProjectInfo projectInfo = new ProjectInfo(this.libraryPlaces.getSelectedOrganizationalUnit(), this.libraryPlaces.getSelectedRepository(), this.libraryPlaces.getSelectedBranch(), project);
        this.libraryPlaces.goToProject(projectInfo);
    }
}

