/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.widgets;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.context.ProjectContextChangeEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.common.client.api.Caller;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.api.OrganizationalUnitRepositoryInfo;
import org.kie.workbench.common.screens.library.api.preferences.LibraryInternalPreferences;
import org.kie.workbench.common.screens.library.api.preferences.LibraryPreferences;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.mvp.Command;

@ApplicationScoped
public class LibraryToolbarPresenter {
    private View view;
    private Caller<LibraryService> libraryService;
    private LibraryPreferences libraryPreferences;
    private LibraryInternalPreferences libraryInternalPreferences;
    private PlaceManager placeManager;
    private LibraryPlaces libraryPlaces;
    private Event<ProjectContextChangeEvent> projectContextChangeEvent;
    private OrganizationalUnitRepositoryInfo info;
    private Repository selectedRepository;
    private String selectedBranch;

    @Inject
    public LibraryToolbarPresenter(View view, Caller<LibraryService> libraryService, LibraryPreferences libraryPreferences, LibraryInternalPreferences libraryInternalPreferences, PlaceManager placeManager, LibraryPlaces libraryPlaces, Event<ProjectContextChangeEvent> projectContextChangeEvent) {
        this.view = view;
        this.libraryService = libraryService;
        this.libraryPreferences = libraryPreferences;
        this.libraryInternalPreferences = libraryInternalPreferences;
        this.placeManager = placeManager;
        this.libraryPlaces = libraryPlaces;
        this.projectContextChangeEvent = projectContextChangeEvent;
    }

    public void init(Command callback) {
        ((LibraryService)this.libraryService.call(info -> {
            this.info = info;
            this.view.init(this);
            this.setupRepositories((OrganizationalUnitRepositoryInfo)info);
            this.selectedRepository = info.getSelectedRepository();
            this.selectedBranch = info.getSelectedRepository().getDefaultBranch();
            this.setBranchSelectorVisibility();
            this.setRepositorySelectorVisibility();
            ProjectContextChangeEvent event = new ProjectContextChangeEvent(info.getSelectedOrganizationalUnit());
            this.projectContextChangeEvent.fire((Object)event);
            callback.execute();
        })).getDefaultOrganizationalUnitRepositoryInfo();
    }

    public void setSelectedInfo(OrganizationalUnit organizationalUnit, Repository repository, Command callback) {
        ((LibraryService)this.libraryService.call(newInfo -> {
            newInfo.setSelectedRepository(repository);
            this.refreshLibrary((OrganizationalUnitRepositoryInfo)newInfo, callback);
        })).getOrganizationalUnitRepositoryInfo(organizationalUnit);
    }

    private void setupRepositories(OrganizationalUnitRepositoryInfo info) {
        this.view.clearRepositories();
        info.getRepositories().forEach(repo -> this.view.addRepository(repo.getAlias()));
        this.view.setSelectedRepository(info.getSelectedRepository().getAlias());
        this.setUpBranches(info.getSelectedRepository().getDefaultBranch(), info.getSelectedRepository());
    }

    private void setUpBranches(String selectedBranch, Repository repository) {
        this.view.clearBranches();
        for (String branchName : repository.getBranches()) {
            this.view.addBranch(branchName);
        }
        this.view.setSelectedBranch(selectedBranch);
    }

    void onUpdateSelectedRepository() {
        this.refreshLibrary(null);
        this.setUpBranches(this.selectedBranch, this.selectedRepository);
        this.libraryInternalPreferences.load(loadedLibraryInternalPreferences -> {
            loadedLibraryInternalPreferences.setLastOpenedRepository(this.selectedRepository.getAlias());
            loadedLibraryInternalPreferences.save();
        }, error -> {});
    }

    void onUpdateSelectedBranch() {
        this.refreshLibrary(null);
    }

    private void refreshLibrary(OrganizationalUnitRepositoryInfo newInfo) {
        this.refreshLibrary(newInfo, null);
    }

    private void refreshLibrary(OrganizationalUnitRepositoryInfo newInfo, Command callback) {
        if (this.placeManager.closeAllPlacesOrNothing()) {
            if (newInfo != null) {
                this.info = newInfo;
                this.setupRepositories(this.info);
            }
            this.selectedRepository = this.getViewSelectedRepository();
            this.selectedBranch = this.getViewSelectedBranch();
            this.setBranchSelectorVisibility();
            this.setRepositorySelectorVisibility();
            this.libraryPlaces.goToLibrary(callback);
        } else {
            this.view.setSelectedRepository(this.selectedRepository.getAlias());
            this.setUpBranches(this.selectedBranch, this.selectedRepository);
        }
    }

    private void setRepositorySelectorVisibility() {
        this.view.setRepositorySelectorVisibility(this.info.getRepositories().size() > 1);
    }

    private void setBranchSelectorVisibility() {
        this.view.setBranchSelectorVisibility(this.selectedRepository.getBranches().size() > 1);
    }

    private String getViewSelectedBranch() {
        if (!this.selectedRepository.getBranches().contains(this.view.getSelectedBranch())) {
            return this.selectedRepository.getDefaultBranch();
        }
        return this.view.getSelectedBranch();
    }

    public Repository getSelectedRepository() {
        return this.selectedRepository;
    }

    private Repository getViewSelectedRepository() {
        return this.info.getRepositories().stream().filter(repo -> repo.getAlias().equals(this.view.getSelectedRepository())).findFirst().get();
    }

    public UberElement<LibraryToolbarPresenter> getView() {
        return this.view;
    }

    public String getSelectedBranch() {
        return this.selectedBranch;
    }

    public static interface View
    extends UberElement<LibraryToolbarPresenter> {
        public void clearRepositories();

        public void addRepository(String var1);

        public String getSelectedRepository();

        public void setSelectedRepository(String var1);

        public void setRepositorySelectorVisibility(boolean var1);

        public void clearBranches();

        public void addBranch(String var1);

        public String getSelectedBranch();

        public void setSelectedBranch(String var1);

        public void setBranchSelectorVisibility(boolean var1);
    }
}

