/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.widgets;

import com.google.gwt.event.dom.client.ClickEvent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.widgets.ProjectActionsWidget;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;

@Templated
public class ProjectActionsView
implements ProjectActionsWidget.View,
IsElement {
    private ProjectActionsWidget presenter;
    private TranslationService translationService;
    @Inject
    @DataField(value="settings")
    Button settings;
    @Inject
    @DataField(value="compile")
    Button compile;
    @Inject
    @DataField(value="build-and-deploy")
    Button buildAndDeploy;
    @Inject
    @DataField(value="messages")
    Button messages;

    @Inject
    public ProjectActionsView(TranslationService translationService) {
        this.translationService = translationService;
    }

    public void init(ProjectActionsWidget presenter) {
        this.presenter = presenter;
        if (!presenter.userCanBuildProject()) {
            this.compile.setHidden(true);
            this.buildAndDeploy.setHidden(true);
        }
    }

    @EventHandler(value={"settings"})
    public void projectSettings(ClickEvent clickEvent) {
        this.presenter.goToProjectSettings();
    }

    @EventHandler(value={"compile"})
    public void compileProject(ClickEvent clickEvent) {
        this.presenter.compileProject();
    }

    @EventHandler(value={"build-and-deploy"})
    public void buildAndDeployProject(ClickEvent clickEvent) {
        this.presenter.buildAndDeployProject();
    }

    @EventHandler(value={"messages"})
    public void messages(ClickEvent clickEvent) {
        this.presenter.goToMessages();
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }

    public void showABuildIsAlreadyRunning() {
        ErrorPopup.showMessage((String)this.translationService.getTranslation("ABuildIsAlreadyRunning"));
    }
}

