/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.widgets.organizationalunit;

import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Heading;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.util.TranslationUtils;
import org.kie.workbench.common.screens.library.client.widgets.organizationalunit.OrganizationalUnitTileWidget;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.mvp.Command;

@Templated
public class OrganizationalUnitTileView
implements OrganizationalUnitTileWidget.View,
IsElement {
    private OrganizationalUnitTileWidget presenter;
    @Inject
    private TranslationService ts;
    @Inject
    private TranslationUtils translationUtils;
    @Inject
    @DataField(value="card")
    private Div card;
    @Inject
    @DataField(value="edit")
    private Span edit;
    @Inject
    @DataField(value="remove")
    private Span remove;
    @Inject
    @DataField(value="icon")
    private Span icon;
    @Inject
    @DataField(value="iconOnHover")
    private Span iconOnHover;
    @Inject
    @Named(value="h2")
    @DataField(value="label")
    private Heading label;
    @Inject
    @DataField(value="count")
    private Span count;
    @Inject
    @DataField(value="owner")
    private Span owner;

    public void init(OrganizationalUnitTileWidget presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setup(String iconClass, String iconOnHoverClass, OrganizationalUnit organizationalUnit, Command selectCommand, Command editCommand, Command removeCommand) {
        this.icon.getClassList().add(iconClass);
        this.iconOnHover.getClassList().add(iconOnHoverClass);
        this.label.setTextContent(organizationalUnit.getName());
        this.count.setTextContent(String.valueOf(organizationalUnit.getRepositories().size()));
        this.count.setTitle(organizationalUnit.getRepositories().size() + " " + this.ts.format("Repositories", new Object[0]));
        this.owner.setTextContent(organizationalUnit.getOwner());
        this.card.setOnclick(event -> selectCommand.execute());
        this.edit.setOnclick(event -> editCommand.execute());
        this.remove.setOnclick(event -> removeCommand.execute());
    }

    @Override
    public String getRemovingBusyIndicatorMessage() {
        return this.ts.format("Removing", new Object[0]);
    }

    @Override
    public String getRemoveWarningMessage(String ouName) {
        return this.ts.format("RemoveOrganizationalUnitWarningMessage", new Object[]{ouName, this.translationUtils.getOrganizationalUnitAliasInSingular().toLowerCase()});
    }

    @Override
    public String getRemoveSuccessMessage() {
        return this.ts.format("RemoveOrganizationalUnitSuccess", new Object[]{this.translationUtils.getOrganizationalUnitAliasInSingular()});
    }

    @Override
    public void hideEditAction() {
        this.edit.setHidden(true);
    }

    @Override
    public void hideRemoveAction() {
        this.remove.setHidden(true);
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }
}

