/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.widgets.organizationalunit;

import com.google.gwt.user.client.Window;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.context.ProjectContextChangeEvent;
import org.guvnor.structure.client.security.OrganizationalUnitController;
import org.guvnor.structure.events.AfterDeleteOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.api.OrganizationalUnitRepositoryInfo;
import org.kie.workbench.common.screens.library.api.preferences.LibraryInternalPreferences;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.popup.OrganizationalUnitPopUpPresenter;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

public class OrganizationalUnitTileWidget {
    private View view;
    private LibraryPlaces libraryPlaces;
    private Caller<LibraryService> libraryService;
    private Event<ProjectContextChangeEvent> projectContextChangeEvent;
    private OrganizationalUnitPopUpPresenter organizationalUnitPopUpPresenter;
    private Caller<OrganizationalUnitService> organizationalUnitService;
    private Event<AfterDeleteOrganizationalUnitEvent> afterDeleteOrganizationalUnitEvent;
    private Event<NotificationEvent> notificationEvent;
    private OrganizationalUnitController organizationalUnitController;
    private LibraryInternalPreferences libraryInternalPreferences;

    @Inject
    public OrganizationalUnitTileWidget(View view, LibraryPlaces libraryPlaces, Caller<LibraryService> libraryService, Event<ProjectContextChangeEvent> projectContextChangeEvent, OrganizationalUnitPopUpPresenter organizationalUnitPopUpPresenter, Caller<OrganizationalUnitService> organizationalUnitService, Event<AfterDeleteOrganizationalUnitEvent> afterDeleteOrganizationalUnitEvent, Event<NotificationEvent> notificationEvent, OrganizationalUnitController organizationalUnitController, LibraryInternalPreferences libraryInternalPreferences) {
        this.view = view;
        this.libraryPlaces = libraryPlaces;
        this.libraryService = libraryService;
        this.projectContextChangeEvent = projectContextChangeEvent;
        this.organizationalUnitPopUpPresenter = organizationalUnitPopUpPresenter;
        this.organizationalUnitService = organizationalUnitService;
        this.afterDeleteOrganizationalUnitEvent = afterDeleteOrganizationalUnitEvent;
        this.notificationEvent = notificationEvent;
        this.organizationalUnitController = organizationalUnitController;
        this.libraryInternalPreferences = libraryInternalPreferences;
    }

    public void init(OrganizationalUnit organizationalUnit) {
        this.view.init(this);
        this.view.setup("fa-folder", "fa-folder-open", organizationalUnit, () -> this.open(organizationalUnit), () -> this.edit(organizationalUnit), () -> this.remove(organizationalUnit));
        if (!this.canUpdateOrganizationalUnit(organizationalUnit)) {
            this.view.hideEditAction();
        }
        if (!this.canRemoveOrganizationalUnit(organizationalUnit)) {
            this.view.hideRemoveAction();
        }
    }

    public OrganizationalUnitRepositoryInfo open(OrganizationalUnit organizationalUnit) {
        return ((LibraryService)this.libraryService.call((RemoteCallback)new RemoteCallback<OrganizationalUnitRepositoryInfo>(){

            public void callback(OrganizationalUnitRepositoryInfo info) {
                OrganizationalUnitTileWidget.this.libraryInternalPreferences.load(loadedLibraryInternalPreferences -> {
                    loadedLibraryInternalPreferences.setLastOpenedOrganizationalUnit(info.getSelectedOrganizationalUnit().getIdentifier());
                    loadedLibraryInternalPreferences.setLastOpenedRepository(info.getSelectedRepository().getAlias());
                    loadedLibraryInternalPreferences.save();
                }, error -> {});
                ProjectContextChangeEvent event = new ProjectContextChangeEvent(info.getSelectedOrganizationalUnit(), info.getSelectedRepository(), info.getSelectedRepository().getDefaultBranch());
                OrganizationalUnitTileWidget.this.projectContextChangeEvent.fire((Object)event);
                OrganizationalUnitTileWidget.this.libraryPlaces.goToLibrary(() -> {});
            }
        })).getOrganizationalUnitRepositoryInfo(organizationalUnit);
    }

    public void edit(OrganizationalUnit organizationalUnit) {
        if (this.canUpdateOrganizationalUnit(organizationalUnit)) {
            this.organizationalUnitPopUpPresenter.showEditPopUp(organizationalUnit);
        }
    }

    public void remove(OrganizationalUnit organizationalUnit) {
        if (this.canRemoveOrganizationalUnit(organizationalUnit) && this.confirmRemove(organizationalUnit)) {
            this.view.showBusyIndicator(this.view.getRemovingBusyIndicatorMessage());
            ((OrganizationalUnitService)this.organizationalUnitService.call(v -> {
                this.afterDeleteOrganizationalUnitEvent.fire((Object)new AfterDeleteOrganizationalUnitEvent(organizationalUnit));
                this.view.hideBusyIndicator();
                this.notificationEvent.fire((Object)new NotificationEvent(this.view.getRemoveSuccessMessage(), NotificationEvent.NotificationType.SUCCESS));
            }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).removeOrganizationalUnit(organizationalUnit.getName());
        }
    }

    boolean confirmRemove(OrganizationalUnit organizationalUnit) {
        return Window.confirm((String)this.view.getRemoveWarningMessage(organizationalUnit.getName()));
    }

    boolean canUpdateOrganizationalUnit(OrganizationalUnit organizationalUnit) {
        return this.organizationalUnitController.canUpdateOrgUnit(organizationalUnit);
    }

    boolean canRemoveOrganizationalUnit(OrganizationalUnit organizationalUnit) {
        return this.organizationalUnitController.canDeleteOrgUnit(organizationalUnit);
    }

    public View getView() {
        return this.view;
    }

    public static interface View
    extends UberElement<OrganizationalUnitTileWidget>,
    HasBusyIndicator {
        public void setup(String var1, String var2, OrganizationalUnit var3, Command var4, Command var5, Command var6);

        public String getRemovingBusyIndicatorMessage();

        public String getRemoveWarningMessage(String var1);

        public String getRemoveSuccessMessage();

        public void hideEditAction();

        public void hideRemoveAction();
    }
}

