/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.perspective;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.screens.library.api.search.FilterUpdateEvent;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.kie.workbench.common.widgets.client.search.ContextualSearch;
import org.kie.workbench.common.widgets.client.search.SearchBehavior;
import org.uberfire.client.annotations.Perspective;
import org.uberfire.client.annotations.WorkbenchPerspective;
import org.uberfire.client.workbench.panels.impl.MultiListWorkbenchPanelPresenter;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PerspectiveDefinition;
import org.uberfire.workbench.model.impl.PerspectiveDefinitionImpl;

@ApplicationScoped
@WorkbenchPerspective(identifier="LibraryPerspective")
public class LibraryPerspective {
    private LibraryPlaces libraryPlaces;
    private ContextualSearch contextualSearch;
    private Event<FilterUpdateEvent> filterUpdateEvent;
    private PerspectiveDefinition perspectiveDefinition;
    private boolean refresh = true;

    public LibraryPerspective() {
    }

    @Inject
    public LibraryPerspective(LibraryPlaces libraryPlaces, ContextualSearch contextualSearch, Event<FilterUpdateEvent> filterUpdateEvent) {
        this.libraryPlaces = libraryPlaces;
        this.contextualSearch = contextualSearch;
        this.filterUpdateEvent = filterUpdateEvent;
    }

    @Perspective
    public PerspectiveDefinition buildPerspective() {
        this.perspectiveDefinition = new PerspectiveDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
        this.perspectiveDefinition.setName("Library Perspective");
        return this.perspectiveDefinition;
    }

    @PostConstruct
    public void registerSearchHandler() {
        SearchBehavior searchBehavior = searchFilter -> this.filterUpdateEvent.fire((Object)new FilterUpdateEvent(searchFilter));
        this.contextualSearch.setPerspectiveSearchBehavior("LibraryPerspective", searchBehavior);
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
        boolean refresh;
        this.refresh = refresh = Boolean.parseBoolean(placeRequest.getParameter("refresh", "true"));
    }

    @OnOpen
    public void onOpen() {
        Command callback = null;
        if (this.refresh) {
            callback = () -> this.libraryPlaces.goToLibrary();
        }
        this.libraryPlaces.refresh(callback);
    }

    public PanelDefinition getRootPanel() {
        return this.perspectiveDefinition.getRoot();
    }
}

