/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens;

import com.google.gwt.user.client.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.common.client.dom.ListItem;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Select;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.SinkNative;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.screens.AssetList;
import org.kie.workbench.common.screens.library.client.screens.EmptyState;
import org.kie.workbench.common.screens.library.client.widgets.AssetItemWidget;

@Templated
public class AssetListView
implements AssetList.View,
IsElement {
    @Inject
    @DataField
    Anchor previousPageLink;
    @Inject
    @DataField
    Anchor nextPageLink;
    @Inject
    @DataField
    Anchor toFirstPage;
    @Inject
    @DataField
    Select howManyOnOnePage;
    @Inject
    @DataField
    Span fromToRange;
    @Inject
    @DataField
    ListItem toFirstPageListItem;
    @Inject
    @DataField
    ListItem previousPageLinkListItem;
    @Inject
    @DataField
    ListItem nextPageLinkListItem;
    @Inject
    @DataField(value="indexing-info")
    Div indexingInfo;
    @Inject
    @DataField(value="asset-list")
    Div assetList;
    @Inject
    @DataField
    Input pageNumber;
    @Inject
    private TranslationService ts;
    private EmptyState emptyState;
    @Inject
    private ManagedInstance<AssetItemWidget> itemWidgetsInstances;
    private AssetList presenter;

    public AssetListView() {
    }

    @Inject
    public AssetListView(EmptyState emptyState) {
        this.emptyState = emptyState;
    }

    public void init(AssetList presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setStep(int step) {
        this.howManyOnOnePage.setValue(Integer.toString(step));
    }

    @Override
    public void setForwardDisabled(boolean disabled) {
        this.nextPageLinkListItem.setClassName(this.getDisabledClassName(disabled));
    }

    @Override
    public void setBackwardDisabled(boolean disabled) {
        this.toFirstPageListItem.setClassName(this.getDisabledClassName(disabled));
        this.previousPageLinkListItem.setClassName(this.getDisabledClassName(disabled));
    }

    @Override
    public void range(int from, int to) {
        this.fromToRange.setInnerHTML(from + " - " + to);
    }

    private String getDisabledClassName(boolean disabled) {
        if (disabled) {
            return "disabled";
        }
        return "";
    }

    @Override
    public void clearAssets() {
        DOMUtil.removeAllChildren((Node)this.assetList);
    }

    @Override
    public void add(HTMLElement element) {
        this.assetList.appendChild((Node)element);
    }

    @Override
    public void showEmptyStateMessage(String topic, String message) {
        this.emptyState.setMessage(topic, message);
        this.showEmptyState();
    }

    private void showEmptyState() {
        this.indexingInfo.setClassName("blank-slate-pf");
        this.indexingInfo.getStyle().setProperty("height", "100%");
        this.indexingInfo.getStyle().setProperty("width", "100%");
        this.indexingInfo.getStyle().setProperty("visibility", "visible");
        this.indexingInfo.setInnerHTML(this.emptyState.getElement().getOuterHTML());
    }

    @Override
    public void hideEmptyState() {
        this.emptyState.clear();
        this.indexingInfo.setClassName("");
        this.indexingInfo.getStyle().setProperty("visibility", "hidden");
        this.indexingInfo.getStyle().setProperty("height", "0px");
        this.indexingInfo.getStyle().setProperty("width", "0px");
        this.indexingInfo.setInnerHTML("");
    }

    @Override
    public void setPageNumber(int pageNumber) {
        this.pageNumber.setValue(Integer.toString(pageNumber));
    }

    @SinkNative(value=4224)
    @EventHandler(value={"pageNumber"})
    public void onPageChange(Event e) {
        if (e.getKeyCode() < 0 || e.getKeyCode() == 13) {
            this.presenter.onPageNumberChange(Integer.valueOf(this.pageNumber.getValue()));
        }
    }

    @SinkNative(value=1024)
    @EventHandler(value={"howManyOnOnePage"})
    public void onStepChange(Event e) {
        this.presenter.onChangeAmountOfItemsShown(Integer.valueOf(this.howManyOnOnePage.getValue()));
    }

    @SinkNative(value=1)
    @EventHandler(value={"toFirstPage"})
    public void toFirstPage(Event e) {
        this.presenter.onToFirstPage();
    }

    @SinkNative(value=1)
    @EventHandler(value={"nextPageLink"})
    public void onNextPage(Event e) {
        this.presenter.onToNextPage();
    }

    @SinkNative(value=1)
    @EventHandler(value={"previousPageLink"})
    public void onPreviousNextPage(Event e) {
        this.presenter.onToPrevious();
    }
}

