/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens;

import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.workbench.common.screens.examples.model.ExampleProject;
import org.kie.workbench.common.screens.library.client.util.ExamplesUtils;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.mvp.ParameterizedCommand;

@WorkbenchScreen(identifier="EmptyLibraryScreen")
public class EmptyLibraryScreen {
    private View view;
    private User user;
    private LibraryPlaces libraryPlaces;
    private ExamplesUtils examplesUtils;
    private ProjectController projectController;

    @Inject
    public EmptyLibraryScreen(View view, User user, LibraryPlaces libraryPlaces, ExamplesUtils examplesUtils, ProjectController projectController) {
        this.view = view;
        this.user = user;
        this.libraryPlaces = libraryPlaces;
        this.examplesUtils = examplesUtils;
        this.projectController = projectController;
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
        this.view.setup(this.user.getIdentifier());
        this.examplesUtils.getExampleProjects((ParameterizedCommand<Set<ExampleProject>>)((ParameterizedCommand)exampleProjects -> {
            this.view.clearImportProjectsContainer();
            for (ExampleProject exampleProject : exampleProjects) {
                this.view.addProjectToImport(exampleProject);
            }
        }));
    }

    public void newProject() {
        if (this.userCanCreateProjects()) {
            this.libraryPlaces.goToNewProject();
        }
    }

    public void importProject(ExampleProject exampleProject) {
        if (this.userCanCreateProjects()) {
            this.examplesUtils.importProject(exampleProject);
        }
    }

    public boolean userCanCreateProjects() {
        return this.projectController.canCreateProjects();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return "Empty Library Screen";
    }

    @WorkbenchPartView
    public UberElement<EmptyLibraryScreen> getView() {
        return this.view;
    }

    public static interface View
    extends UberElement<EmptyLibraryScreen> {
        public void setup(String var1);

        public void addProjectToImport(ExampleProject var1);

        public void clearImportProjectsContainer();
    }
}

