/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens;

import com.google.gwt.user.client.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Heading;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.SinkNative;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.examples.model.ExampleProject;
import org.kie.workbench.common.screens.library.client.screens.EmptyLibraryScreen;
import org.kie.workbench.common.screens.library.client.widgets.ImportExampleButtonWidget;
import org.kie.workbench.common.screens.library.client.widgets.NewProjectButtonWidget;

@Templated
public class EmptyLibraryView
implements EmptyLibraryScreen.View,
IsElement {
    private EmptyLibraryScreen presenter;
    @Inject
    private TranslationService ts;
    @Inject
    private ManagedInstance<ImportExampleButtonWidget> importExampleButtonWidgets;
    @Inject
    private NewProjectButtonWidget newProjectButtonWidget;
    @Inject
    @Named(value="h1")
    @DataField
    private Heading welcome;
    @Inject
    @DataField(value="import-container")
    private Div importContainer;
    @Inject
    @DataField(value="new-project-link")
    Anchor newProjectLink;
    @Inject
    @DataField(value="new-project-button-container")
    Div newProjectButtonContainer;
    @Inject
    @DataField(value="projects-container")
    private Div projectsContainer;

    public void init(EmptyLibraryScreen presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setup(String username) {
        this.welcome.setInnerHTML(this.ts.getTranslation("EmptyLibraryView.Welcome") + " " + username + ".");
        this.newProjectButtonContainer.appendChild((Node)this.newProjectButtonWidget.getView().getElement());
        if (!this.presenter.userCanCreateProjects()) {
            this.projectsContainer.setHidden(true);
        }
    }

    @Override
    public void addProjectToImport(ExampleProject exampleProject) {
        ImportExampleButtonWidget importExampleButton = (ImportExampleButtonWidget)this.importExampleButtonWidgets.get();
        importExampleButton.init(exampleProject.getName(), exampleProject.getDescription(), () -> this.presenter.importProject(exampleProject));
        this.importContainer.appendChild((Node)importExampleButton.getElement());
    }

    @Override
    public void clearImportProjectsContainer() {
        this.importContainer.setInnerHTML("");
    }

    @SinkNative(value=1)
    @EventHandler(value={"new-project-link"})
    public void newProjectLink(Event e) {
        this.presenter.newProject();
    }
}

