/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens;

import com.google.gwt.event.dom.client.ClickEvent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.screens.EmptyProjectScreen;
import org.kie.workbench.common.screens.library.client.screens.ProjectsDetailScreen;
import org.kie.workbench.common.screens.library.client.widgets.AssetsActionsWidget;
import org.kie.workbench.common.screens.library.client.widgets.ProjectActionsWidget;
import org.kie.workbench.common.screens.library.client.widgets.ResourceHandlerWidget;
import org.kie.workbench.common.widgets.client.handlers.NewResourceHandler;

@Templated
public class EmptyProjectView
implements EmptyProjectScreen.View,
IsElement {
    private EmptyProjectScreen presenter;
    @Inject
    private ManagedInstance<ResourceHandlerWidget> resourceHandlerWidgets;
    @Inject
    private ProjectsDetailScreen projectsDetailScreen;
    @Inject
    private ProjectActionsWidget projectActionsWidget;
    @Inject
    private AssetsActionsWidget assetsActionsWidget;
    @Inject
    @DataField(value="project-toolbar")
    Div projectToolbar;
    @Inject
    @DataField(value="assets-toolbar")
    Div assetsToolbar;
    @Inject
    @DataField(value="details-container")
    Div detailsContainer;
    @Inject
    @DataField(value="resource-handler-container")
    Div resourceHandlerContainer;
    @Inject
    @DataField(value="browse-more-types")
    Anchor browseMoreTypes;
    @Inject
    @DataField(value="project-name")
    Div projectNameContainer;
    @Inject
    @DataField(value="uploader")
    Anchor uploader;

    public void init(EmptyProjectScreen presenter) {
        this.presenter = presenter;
        this.resourceHandlerContainer.setTextContent("");
        this.detailsContainer.appendChild((Node)this.projectsDetailScreen.getView().getElement());
        this.assetsActionsWidget.init();
        this.projectActionsWidget.init(presenter::goToSettings);
        this.assetsToolbar.appendChild((Node)this.assetsActionsWidget.getView().getElement());
        this.projectToolbar.appendChild((Node)this.projectActionsWidget.getView().getElement());
    }

    @Override
    public void setProjectName(String projectName) {
        this.projectNameContainer.setTextContent(projectName);
    }

    @Override
    public void addResourceHandler(NewResourceHandler newResourceHandler) {
        ResourceHandlerWidget resourceHandlerWidget = (ResourceHandlerWidget)this.resourceHandlerWidgets.get();
        resourceHandlerWidget.init(newResourceHandler.getDescription(), newResourceHandler.getIcon(), newResourceHandler.getCommand(this.presenter.getNewResourcePresenter()));
        this.resourceHandlerContainer.appendChild((Node)resourceHandlerWidget.getElement());
    }

    @EventHandler(value={"browse-more-types"})
    public void browseMoreTypes(ClickEvent clickEvent) {
        this.resourceHandlerContainer.getClassList().remove("retracted");
        this.browseMoreTypes.setHidden(true);
    }

    @EventHandler(value={"uploader"})
    public void upload(ClickEvent clickEvent) {
        this.presenter.getUploadHandler().getCommand(this.presenter.getNewResourcePresenter()).execute();
    }
}

