/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.Date;
import java.util.List;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.ext.uberfire.social.activities.client.widgets.utils.SocialDateFormatter;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.explorer.client.utils.Classifier;
import org.kie.workbench.common.screens.explorer.client.utils.Utils;
import org.kie.workbench.common.screens.explorer.model.FolderItemType;
import org.kie.workbench.common.screens.library.api.AssetInfo;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.api.ProjectAssetsQuery;
import org.kie.workbench.common.screens.library.api.ProjectInfo;
import org.kie.workbench.common.screens.library.api.search.FilterUpdateEvent;
import org.kie.workbench.common.screens.library.client.events.AssetDetailEvent;
import org.kie.workbench.common.screens.library.client.events.ProjectDetailEvent;
import org.kie.workbench.common.screens.library.client.perspective.LibraryPerspective;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.client.workbench.events.PlaceGainFocusEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.util.URIUtil;

@WorkbenchScreen(identifier="ProjectScreen", owningPerspective=LibraryPerspective.class)
public class ProjectScreen {
    private View view;
    private LibraryPlaces libraryPlaces;
    private TranslationService ts;
    private Caller<LibraryService> libraryService;
    private Classifier assetClassifier;
    private Event<AssetDetailEvent> assetDetailEvent;
    private BusyIndicatorView busyIndicatorView;
    private ProjectInfo projectInfo;
    private List<AssetInfo> assets;
    private Reloader reloader = new Reloader();
    private Timer projectLoadTimer;
    private boolean isProjectLoadPending = false;
    private boolean isProjectLoadInProgress = false;

    @Inject
    public ProjectScreen(View view, LibraryPlaces libraryPlaces, TranslationService ts, Caller<LibraryService> libraryService, Classifier assetClassifier, Event<AssetDetailEvent> assetDetailEvent, BusyIndicatorView busyIndicatorView) {
        this.view = view;
        this.libraryPlaces = libraryPlaces;
        this.ts = ts;
        this.libraryService = libraryService;
        this.assetClassifier = assetClassifier;
        this.assetDetailEvent = assetDetailEvent;
        this.busyIndicatorView = busyIndicatorView;
    }

    public void onStartup(@Observes ProjectDetailEvent projectDetailEvent) {
        this.projectInfo = projectDetailEvent.getProjectInfo();
        this.loadProjectInfo();
        this.view.setProjectName(this.projectInfo.getProject().getProjectName());
    }

    public void refreshOnFocus(@Observes PlaceGainFocusEvent placeGainFocusEvent) {
        PlaceRequest place = placeGainFocusEvent.getPlace();
        if (this.projectInfo != null && place.getIdentifier().equals("ProjectScreen")) {
            this.loadProjectInfo();
        }
    }

    protected Timer createTimer() {
        return new Timer(){

            public void run() {
                ProjectScreen.this.onTimerAction();
            }
        };
    }

    protected void onTimerAction() {
        this.view.resetPageRangeIndicator();
        this.loadProjectInfo();
    }

    private void cancel() {
        if (this.projectLoadTimer != null) {
            this.projectLoadTimer.cancel();
            this.projectLoadTimer = null;
        }
    }

    public void goToSettings() {
        this.assetDetailEvent.fire((Object)new AssetDetailEvent(this.projectInfo, null));
    }

    public String getProjectName() {
        return this.projectInfo.getProject().getProjectName();
    }

    String getLastModifiedTime(AssetInfo asset) {
        return this.ts.format("LastModified", new Object[0]) + " " + SocialDateFormatter.format((Date)asset.getLastModifiedTime());
    }

    String getCreatedTime(AssetInfo asset) {
        return this.ts.format("Created", new Object[0]) + " " + SocialDateFormatter.format((Date)asset.getCreatedTime());
    }

    Command selectCommand(Path assetPath) {
        return () -> this.libraryPlaces.goToAsset(this.projectInfo, assetPath);
    }

    Command detailsCommand(Path assetPath) {
        return this.selectCommand(assetPath);
    }

    void loadProjectInfo() {
        if (this.isProjectLoadInProgress) {
            this.isProjectLoadPending = true;
            return;
        }
        this.busyIndicatorView.showBusyIndicator(this.ts.getTranslation("LoadingAssets"));
        this.isProjectLoadInProgress = true;
        ((LibraryService)this.libraryService.call((RemoteCallback)new RemoteCallback<List<AssetInfo>>(){

            public void callback(List<AssetInfo> assetsList) {
                ProjectScreen.this.assets = assetsList;
                ProjectScreen.this.setupAssets(ProjectScreen.this.assets);
                ProjectScreen.this.busyIndicatorView.hideBusyIndicator();
                ProjectScreen.this.isProjectLoadInProgress = false;
                if (ProjectScreen.this.isProjectLoadPending) {
                    ProjectScreen.this.isProjectLoadPending = false;
                    ProjectScreen.this.loadProjectInfo();
                } else {
                    ProjectScreen.this.reloader.check(assetsList);
                }
            }
        })).getProjectAssets(new ProjectAssetsQuery(this.projectInfo.getProject(), this.view.getFilterValue(), this.view.getFirstIndex(), this.view.getStep().intValue()));
    }

    private void setupAssets(List<AssetInfo> assets) {
        this.view.clearAssets();
        if (assets.isEmpty()) {
            if (this.isFilterEmpty()) {
                if (this.view.getFirstIndex() == 0) {
                    this.view.showIndexingIncomplete();
                } else {
                    this.view.showNoMoreAssets();
                }
            } else if (this.view.getFirstIndex() == 0) {
                this.view.showSearchHitNothing();
            } else {
                this.view.showNoMoreAssets();
            }
        } else {
            assets.stream().forEach(asset -> {
                if (!asset.getFolderItem().getType().equals((Object)FolderItemType.FOLDER)) {
                    ClientResourceType assetResourceType = this.assetClassifier.findResourceType(asset.getFolderItem());
                    String assetName = Utils.getBaseFileName((String)asset.getFolderItem().getFileName(), (String)assetResourceType.getSuffix());
                    this.view.addAsset(assetName, this.getAssetPath((AssetInfo)asset), assetResourceType.getDescription(), assetResourceType.getIcon(), this.getLastModifiedTime((AssetInfo)asset), this.getCreatedTime((AssetInfo)asset), this.detailsCommand((Path)asset.getFolderItem().getItem()), this.selectCommand((Path)asset.getFolderItem().getItem()));
                }
            });
        }
    }

    public void filterUpdate(@Observes FilterUpdateEvent event) {
        this.view.setFilterName(event.getName());
        this.onFilterChange();
    }

    private boolean isFilterEmpty() {
        return this.view.getFilterValue().isEmpty();
    }

    private String getAssetPath(AssetInfo asset) {
        String fullPath = ((Path)asset.getFolderItem().getItem()).toURI();
        String projectRootPath = this.projectInfo.getProject().getRootPath().toURI();
        String relativeAssetPath = fullPath.substring(projectRootPath.length() + 1);
        String decodedRelativeAssetPath = URIUtil.decode((String)relativeAssetPath);
        return decodedRelativeAssetPath;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return "Project Screen";
    }

    @WorkbenchPartView
    public UberElement<ProjectScreen> getView() {
        return this.view;
    }

    public void onReload() {
        this.loadProjectInfo();
    }

    protected void reload() {
        Scheduler.get().scheduleFixedDelay(new Scheduler.RepeatingCommand(){

            public boolean execute() {
                ProjectScreen.this.loadProjectInfo();
                return false;
            }
        }, 2000);
    }

    public void onFilterChange() {
        this.cancel();
        this.projectLoadTimer = this.createTimer();
        this.projectLoadTimer.schedule(250);
    }

    private class Reloader {
        private boolean active = false;
        private int previousAmount = -1;

        private Reloader() {
        }

        public void check(List<AssetInfo> assetsList) {
            if (ProjectScreen.this.assets != null && assetsList.size() <= this.previousAmount && !ProjectScreen.this.assets.isEmpty()) {
                this.active = false;
            }
            if (assetsList.isEmpty() && ProjectScreen.this.view.getFirstIndex() == 0 && this.filterIsNotSet()) {
                this.active = true;
            }
            if (this.active && ProjectScreen.this.view.getFirstIndex() != 0) {
                this.active = false;
            }
            if (assetsList.size() == ProjectScreen.this.view.getStep().intValue()) {
                this.active = false;
            }
            this.previousAmount = assetsList.size();
            if (this.active) {
                ProjectScreen.this.reload();
            }
        }

        private boolean filterIsNotSet() {
            return ProjectScreen.this.view.getFilterValue() == null || ProjectScreen.this.view.getFilterValue().trim().isEmpty();
        }
    }

    public static interface View
    extends UberElement<ProjectScreen> {
        public void setProjectName(String var1);

        public void clearAssets();

        public void addAsset(String var1, String var2, String var3, IsWidget var4, String var5, String var6, Command var7, Command var8);

        public String getFilterValue();

        public void setFilterName(String var1);

        public Integer getStep();

        public void showIndexingIncomplete();

        public void showSearchHitNothing();

        public void showNoMoreAssets();

        public int getFirstIndex();

        public void resetPageRangeIndicator();
    }
}

