/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.organizationalunit;

import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.structure.client.security.OrganizationalUnitController;
import org.guvnor.structure.events.AfterCreateOrganizationalUnitEvent;
import org.guvnor.structure.events.AfterDeleteOrganizationalUnitEvent;
import org.guvnor.structure.events.AfterEditOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.api.AfterInitialization;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.api.search.FilterUpdateEvent;
import org.kie.workbench.common.screens.library.client.perspective.LibraryPerspective;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.popup.OrganizationalUnitPopUpPresenter;
import org.kie.workbench.common.screens.library.client.widgets.organizationalunit.OrganizationalUnitTileWidget;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElement;

@WorkbenchScreen(identifier="LibraryOrganizationalUnitsScreen", owningPerspective=LibraryPerspective.class)
public class OrganizationalUnitsScreen {
    private View view;
    private Caller<LibraryService> libraryService;
    private OrganizationalUnitPopUpPresenter organizationalUnitPopUpPresenter;
    private OrganizationalUnitController organizationalUnitController;
    private ManagedInstance<OrganizationalUnitTileWidget> organizationalUnitTileWidgets;
    List<OrganizationalUnit> organizationalUnits;

    @Inject
    public OrganizationalUnitsScreen(View view, Caller<LibraryService> libraryService, OrganizationalUnitPopUpPresenter organizationalUnitPopUpPresenter, OrganizationalUnitController organizationalUnitController, ManagedInstance<OrganizationalUnitTileWidget> organizationalUnitTileWidgets) {
        this.view = view;
        this.libraryService = libraryService;
        this.organizationalUnitPopUpPresenter = organizationalUnitPopUpPresenter;
        this.organizationalUnitController = organizationalUnitController;
        this.organizationalUnitTileWidgets = organizationalUnitTileWidgets;
    }

    @AfterInitialization
    public void init() {
        this.setupView();
        this.setupOrganizationalUnits();
    }

    private void setupView() {
        if (!this.canCreateOrganizationalUnit()) {
            this.view.hideCreateOrganizationalUnitAction();
        }
    }

    private void setupOrganizationalUnits() {
        if (this.organizationalUnitController.canReadOrgUnits()) {
            ((LibraryService)this.libraryService.call(allOrganizationalUnits -> {
                this.organizationalUnits = allOrganizationalUnits;
                this.refreshOrganizationalUnits(this.organizationalUnits);
            })).getOrganizationalUnits();
        }
    }

    private void refreshOrganizationalUnits(List<OrganizationalUnit> organizationalUnits) {
        this.view.clearOrganizationalUnits();
        organizationalUnits.forEach(organizationalUnit -> {
            OrganizationalUnitTileWidget organizationalUnitTileWidget = (OrganizationalUnitTileWidget)this.organizationalUnitTileWidgets.get();
            organizationalUnitTileWidget.init((OrganizationalUnit)organizationalUnit);
            this.view.addOrganizationalUnit(organizationalUnitTileWidget);
        });
    }

    public void createOrganizationalUnit() {
        this.organizationalUnitPopUpPresenter.showAddPopUp();
    }

    public void organizationalUnitCreated(@Observes AfterCreateOrganizationalUnitEvent afterCreateOrganizationalUnitEvent) {
        this.organizationalUnits.add(afterCreateOrganizationalUnitEvent.getOrganizationalUnit());
        this.refresh();
    }

    public void organizationalUnitEdited(@Observes AfterEditOrganizationalUnitEvent afterEditOrganizationalUnitEvent) {
        this.organizationalUnits.remove(afterEditOrganizationalUnitEvent.getPreviousOrganizationalUnit());
        this.organizationalUnits.add(afterEditOrganizationalUnitEvent.getEditedOrganizationalUnit());
        this.refresh();
    }

    public void organizationalUnitDeleted(@Observes AfterDeleteOrganizationalUnitEvent afterDeleteOrganizationalUnitEvent) {
        this.organizationalUnits.remove(afterDeleteOrganizationalUnitEvent.getOrganizationalUnit());
        this.refresh();
    }

    public void refresh() {
        String filterName = this.view.getFilterName().toUpperCase();
        List<OrganizationalUnit> filteredOrganizationalUnits = this.organizationalUnits.stream().filter(ou -> ou.getName().toUpperCase().startsWith(filterName)).collect(Collectors.toList());
        filteredOrganizationalUnits.sort((o1, o2) -> o1.getName().compareTo(o2.getName()));
        this.refreshOrganizationalUnits(filteredOrganizationalUnits);
    }

    public void filterUpdate(@Observes FilterUpdateEvent event) {
        this.view.setFilterName(event.getName());
        this.refresh();
    }

    public boolean canCreateOrganizationalUnit() {
        return this.organizationalUnitController.canCreateOrgUnits();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return "Organizational Units Screen";
    }

    @WorkbenchPartView
    public UberElement<OrganizationalUnitsScreen> getView() {
        return this.view;
    }

    public static interface View
    extends UberElement<OrganizationalUnitsScreen> {
        public void clearOrganizationalUnits();

        public String getFilterName();

        public void setFilterName(String var1);

        public void hideCreateOrganizationalUnitAction();

        public void addOrganizationalUnit(OrganizationalUnitTileWidget var1);
    }
}

