/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.organizationalunit.popup;

import java.util.ArrayList;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.structure.client.security.OrganizationalUnitController;
import org.guvnor.structure.events.AfterCreateOrganizationalUnitEvent;
import org.guvnor.structure.events.AfterEditOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.ioc.client.api.AfterInitialization;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

public class OrganizationalUnitPopUpPresenter {
    private View view;
    private Caller<OrganizationalUnitService> organizationalUnitService;
    private Event<AfterCreateOrganizationalUnitEvent> afterCreateOrganizationalUnitEvent;
    private Event<AfterEditOrganizationalUnitEvent> afterEditOrganizationalUnitEvent;
    private Event<NotificationEvent> notificationEvent;
    private OrganizationalUnitController organizationalUnitController;
    private OrganizationalUnit organizationalUnit;

    @Inject
    public OrganizationalUnitPopUpPresenter(View view, Caller<OrganizationalUnitService> organizationalUnitService, Event<AfterCreateOrganizationalUnitEvent> afterCreateOrganizationalUnitEvent, Event<AfterEditOrganizationalUnitEvent> afterEditOrganizationalUnitEvent, Event<NotificationEvent> notificationEvent, OrganizationalUnitController organizationalUnitController) {
        this.view = view;
        this.organizationalUnitService = organizationalUnitService;
        this.afterCreateOrganizationalUnitEvent = afterCreateOrganizationalUnitEvent;
        this.afterEditOrganizationalUnitEvent = afterEditOrganizationalUnitEvent;
        this.notificationEvent = notificationEvent;
        this.organizationalUnitController = organizationalUnitController;
    }

    @AfterInitialization
    public void setup() {
        this.view.init(this);
    }

    public void showAddPopUp() {
        if (this.organizationalUnitController.canCreateOrgUnits()) {
            this.view.clear();
            this.view.showAddPopUp();
        }
    }

    public void showEditPopUp(OrganizationalUnit organizationalUnit) {
        if (this.organizationalUnitController.canUpdateOrgUnit(organizationalUnit)) {
            this.view.showEditPopUp(organizationalUnit);
            this.organizationalUnit = organizationalUnit;
        }
    }

    public void save() {
        String name = this.view.getName();
        String defaultGroupId = this.view.getDefaultGroupId();
        String owner = this.view.getOwner();
        this.view.showBusyIndicator(this.view.getSavingMessage());
        this.validateFields(() -> {
            if (this.organizationalUnit == null) {
                this.saveCreation(name, defaultGroupId, owner);
            } else {
                this.saveEdition(name, defaultGroupId, owner);
            }
        });
    }

    void saveEdition(String name, String defaultGroupId, String owner) {
        ((OrganizationalUnitService)this.organizationalUnitService.call(newOrganizationalUnit -> {
            this.afterEditOrganizationalUnitEvent.fire((Object)new AfterEditOrganizationalUnitEvent(this.organizationalUnit, newOrganizationalUnit));
            this.view.hideBusyIndicator();
            this.notificationEvent.fire((Object)new NotificationEvent(this.view.getSaveSuccessMessage(), NotificationEvent.NotificationType.SUCCESS));
            this.view.hide();
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).updateOrganizationalUnit(name, owner, defaultGroupId);
    }

    void saveCreation(String name, String defaultGroupId, String owner) {
        Command saveCommand = () -> {
            ArrayList repositories = new ArrayList();
            ((OrganizationalUnitService)this.organizationalUnitService.call(newOrganizationalUnit -> {
                this.afterCreateOrganizationalUnitEvent.fire((Object)new AfterCreateOrganizationalUnitEvent(newOrganizationalUnit));
                this.view.hideBusyIndicator();
                this.notificationEvent.fire((Object)new NotificationEvent(this.view.getSaveSuccessMessage(), NotificationEvent.NotificationType.SUCCESS));
                this.view.hide();
            }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).createOrganizationalUnit(name, owner, defaultGroupId, repositories);
        };
        this.validateDuplicatedOrganizationalUnit(name, saveCommand);
    }

    private void validateFields(Command successCallback) {
        String name = this.view.getName();
        if (this.isEmpty(name)) {
            this.view.hideBusyIndicator();
            this.view.showError(this.view.getEmptyNameValidationMessage());
            return;
        }
        String defaultGroupId = this.view.getDefaultGroupId();
        if (this.isEmpty(defaultGroupId)) {
            this.view.hideBusyIndicator();
            this.view.showError(this.view.getEmptyDefaultGroupIdValidationMessage());
            return;
        }
        ((OrganizationalUnitService)this.organizationalUnitService.call(valid -> {
            if (!valid.booleanValue()) {
                this.view.hideBusyIndicator();
                this.view.showError(this.view.getInvalidDefaultGroupIdValidationMessage());
                return;
            }
            if (successCallback != null) {
                successCallback.execute();
            }
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).isValidGroupId(defaultGroupId);
    }

    private void validateDuplicatedOrganizationalUnit(String name, Command successCallback) {
        ((OrganizationalUnitService)this.organizationalUnitService.call(existingOrganizationalUnit -> {
            if (existingOrganizationalUnit != null) {
                this.view.hideBusyIndicator();
                this.view.showError(this.view.getDuplicatedOrganizationalUnitValidationMessage());
                return;
            }
            if (successCallback != null) {
                successCallback.execute();
            }
        })).getOrganizationalUnit(name);
    }

    public void cancel() {
        this.view.hide();
    }

    private boolean isEmpty(String text) {
        return text == null || text.trim().isEmpty();
    }

    public static interface View
    extends UberElement<OrganizationalUnitPopUpPresenter>,
    HasBusyIndicator {
        public void showAddPopUp();

        public void showEditPopUp(OrganizationalUnit var1);

        public void hide();

        public void clear();

        public void showError(String var1);

        public String getName();

        public String getDefaultGroupId();

        public String getOwner();

        public String getEmptyNameValidationMessage();

        public String getEmptyDefaultGroupIdValidationMessage();

        public String getInvalidDefaultGroupIdValidationMessage();

        public String getDuplicatedOrganizationalUnitValidationMessage();

        public String getSavingMessage();

        public String getSaveSuccessMessage();
    }
}

