/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.organizationalunit.popup;

import com.google.gwt.user.client.ui.Widget;
import javax.inject.Inject;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.popup.OrganizationalUnitPopUpPresenter;
import org.kie.workbench.common.screens.library.client.util.TranslationUtils;
import org.uberfire.ext.editor.commons.client.file.popups.CommonModalBuilder;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.mvp.Command;

@Templated
public class OrganizationalUnitPopUpView
implements OrganizationalUnitPopUpPresenter.View,
IsElement {
    @Inject
    private TranslationService ts;
    @Inject
    private TranslationUtils translationUtils;
    private OrganizationalUnitPopUpPresenter presenter;
    private BaseModal modal;
    @Inject
    @DataField(value="body")
    Div body;
    @Inject
    @DataField(value="error")
    Div error;
    @Inject
    @DataField(value="error-message")
    Span errorMessage;
    @Inject
    @DataField(value="name")
    Input name;
    @Inject
    @DataField(value="default-group-id")
    Input defaultGroupId;
    @Inject
    @DataField(value="owner")
    Input owner;

    public void init(OrganizationalUnitPopUpPresenter presenter) {
        this.presenter = presenter;
        this.modalSetup();
    }

    @Override
    public void showAddPopUp() {
        this.errorSetup();
        this.modal.show();
    }

    @Override
    public void showEditPopUp(OrganizationalUnit organizationalUnit) {
        this.name.setValue(organizationalUnit.getName());
        this.name.setDisabled(true);
        this.defaultGroupId.setValue(organizationalUnit.getDefaultGroupId());
        this.owner.setValue(organizationalUnit.getOwner());
        this.showAddPopUp();
    }

    @Override
    public void hide() {
        this.modal.hide();
    }

    @Override
    public void clear() {
        this.name.setValue("");
        this.defaultGroupId.setValue("");
        this.owner.setValue("");
    }

    @Override
    public void showError(String errorMessage) {
        this.errorMessage.setTextContent(errorMessage);
        this.error.setHidden(false);
    }

    @Override
    public String getName() {
        return this.name.getValue();
    }

    @Override
    public String getDefaultGroupId() {
        return this.defaultGroupId.getValue();
    }

    @Override
    public String getOwner() {
        return this.owner.getValue();
    }

    @Override
    public String getEmptyNameValidationMessage() {
        String name = this.ts.format("Name", new Object[0]);
        return this.ts.format("EmptyFieldValidation", new Object[]{name});
    }

    @Override
    public String getEmptyDefaultGroupIdValidationMessage() {
        String name = this.ts.format("DefaultGroupId", new Object[0]);
        return this.ts.format("EmptyFieldValidation", new Object[]{name});
    }

    @Override
    public String getInvalidDefaultGroupIdValidationMessage() {
        String name = this.ts.format("DefaultGroupId", new Object[0]);
        return this.ts.format("InvalidFieldValidation", new Object[]{name});
    }

    @Override
    public String getDuplicatedOrganizationalUnitValidationMessage() {
        return this.ts.format("DuplicatedOrganizationalUnitValidation", new Object[]{this.translationUtils.getOrganizationalUnitAliasInSingular().toLowerCase()});
    }

    @Override
    public String getSavingMessage() {
        return this.ts.format("Saving", new Object[0]);
    }

    @Override
    public String getSaveSuccessMessage() {
        return this.ts.format("OrganizationalUnitSaveSuccess", new Object[]{this.translationUtils.getOrganizationalUnitAliasInSingular().toLowerCase()});
    }

    private void modalSetup() {
        this.modal = new CommonModalBuilder().addHeader(this.translationUtils.getOrganizationalUnitAliasInSingular()).addBody((HTMLElement)this.body).addFooter(this.footer()).build();
    }

    private ModalFooter footer() {
        GenericModalFooter footer = new GenericModalFooter();
        footer.add((Widget)this.saveButton());
        footer.add((Widget)this.cancelButton());
        return footer;
    }

    private Button saveButton() {
        return this.button(this.ts.format("Save", new Object[0]), () -> this.presenter.save(), ButtonType.PRIMARY);
    }

    private Button cancelButton() {
        return this.button(this.ts.format("Cancel", new Object[0]), () -> this.presenter.cancel(), ButtonType.DEFAULT);
    }

    private void errorSetup() {
        this.error.setHidden(true);
    }

    private Button button(String text, Command command, ButtonType type) {
        Button button = new Button(text, event -> command.execute());
        button.setType(type);
        return button;
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }
}

