/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.ext.uberfire.social.activities.model.ExtendedTypes;
import org.ext.uberfire.social.activities.model.SocialFileSelectedEvent;
import org.guvnor.asset.management.social.AssetManagementEventTypes;
import org.guvnor.common.services.project.client.preferences.ProjectScopedResolutionStrategySupplier;
import org.guvnor.common.services.project.context.ProjectContext;
import org.guvnor.common.services.project.context.ProjectContextChangeEvent;
import org.guvnor.common.services.project.events.DeleteProjectEvent;
import org.guvnor.common.services.project.events.RenameProjectEvent;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.social.ProjectEventType;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.common.client.dom.Element;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.examples.client.wizard.ExamplesWizard;
import org.kie.workbench.common.screens.explorer.model.URIStructureExplorerModel;
import org.kie.workbench.common.screens.explorer.service.ExplorerService;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.api.ProjectInfo;
import org.kie.workbench.common.screens.library.client.events.AssetDetailEvent;
import org.kie.workbench.common.screens.library.client.events.ProjectDetailEvent;
import org.kie.workbench.common.screens.library.client.perspective.LibraryPerspective;
import org.kie.workbench.common.screens.library.client.util.ExamplesUtils;
import org.kie.workbench.common.screens.library.client.util.ResourceUtils;
import org.kie.workbench.common.screens.library.client.util.TranslationUtils;
import org.kie.workbench.common.screens.library.client.widgets.LibraryToolbarPresenter;
import org.kie.workbench.common.widgets.client.handlers.NewResourceSuccessEvent;
import org.kie.workbench.common.workbench.client.docks.AuthoringWorkbenchDocks;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.workbench.events.PlaceGainFocusEvent;
import org.uberfire.ext.editor.commons.client.event.ConcurrentRenameAcceptedEvent;
import org.uberfire.ext.preferences.client.event.PreferencesCentralInitializationEvent;
import org.uberfire.ext.preferences.client.event.PreferencesCentralSaveEvent;
import org.uberfire.ext.preferences.client.event.PreferencesCentralUndoChangesEvent;
import org.uberfire.ext.widgets.common.client.breadcrumbs.UberfireBreadcrumbs;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.ConditionalPlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.preferences.shared.impl.PreferenceScopeResolutionStrategyInfo;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;

@ApplicationScoped
public class LibraryPlaces {
    public static final String LIBRARY_PERSPECTIVE = "LibraryPerspective";
    public static final String NEW_PROJECT_SCREEN = "NewProjectScreen";
    public static final String EMPTY_LIBRARY_SCREEN = "EmptyLibraryScreen";
    public static final String LIBRARY_SCREEN = "LibraryScreen";
    public static final String EMPTY_PROJECT_SCREEN = "EmptyProjectScreen";
    public static final String PROJECT_SCREEN = "ProjectScreen";
    public static final String PROJECT_DETAIL_SCREEN = "ProjectsDetailScreen";
    public static final String ORGANIZATIONAL_UNITS_SCREEN = "LibraryOrganizationalUnitsScreen";
    public static final String PROJECT_SETTINGS = "projectScreen";
    public static final String PROJECT_EXPLORER = "org.kie.guvnor.explorer";
    public static final String MESSAGES = "org.kie.workbench.common.screens.messageconsole.MessageConsole";
    public static final String REPOSITORY_STRUCTURE_SCREEN = "repositoryStructureScreen";
    public static final List<String> LIBRARY_PLACES = Collections.unmodifiableList(new ArrayList<String>(7){
        {
            this.add(LibraryPlaces.NEW_PROJECT_SCREEN);
            this.add(LibraryPlaces.EMPTY_LIBRARY_SCREEN);
            this.add(LibraryPlaces.LIBRARY_SCREEN);
            this.add(LibraryPlaces.EMPTY_PROJECT_SCREEN);
            this.add(LibraryPlaces.PROJECT_SCREEN);
            this.add(LibraryPlaces.PROJECT_DETAIL_SCREEN);
            this.add(LibraryPlaces.ORGANIZATIONAL_UNITS_SCREEN);
            this.add(LibraryPlaces.PROJECT_SETTINGS);
            this.add(LibraryPlaces.MESSAGES);
            this.add("PreferencesRootScreen");
        }
    });
    private UberfireBreadcrumbs breadcrumbs;
    private TranslationService ts;
    private Event<ProjectDetailEvent> projectDetailEvent;
    private Event<AssetDetailEvent> assetDetailEvent;
    private ResourceUtils resourceUtils;
    private Caller<LibraryService> libraryService;
    private PlaceManager placeManager;
    private LibraryPerspective libraryPerspective;
    private ProjectContext projectContext;
    private LibraryToolbarPresenter libraryToolbar;
    private AuthoringWorkbenchDocks docks;
    private Event<ProjectContextChangeEvent> projectContextChangeEvent;
    private ExamplesUtils examplesUtils;
    private Event<NotificationEvent> notificationEvent;
    private ManagedInstance<ExamplesWizard> examplesWizards;
    private TranslationUtils translationUtils;
    private Caller<VFSService> vfsService;
    private Caller<ExplorerService> explorerService;
    private ProjectScopedResolutionStrategySupplier projectScopedResolutionStrategySupplier;
    private Event<PreferencesCentralInitializationEvent> preferencesCentralInitializationEvent;
    private boolean docksReady = false;
    private boolean docksHidden = true;
    private Project lastViewedProject = null;
    private boolean closingLibraryPlaces = false;

    @Inject
    public LibraryPlaces(UberfireBreadcrumbs breadcrumbs, TranslationService ts, Event<ProjectDetailEvent> projectDetailEvent, Event<AssetDetailEvent> assetDetailEvent, ResourceUtils resourceUtils, Caller<LibraryService> libraryService, PlaceManager placeManager, LibraryPerspective libraryPerspective, ProjectContext projectContext, LibraryToolbarPresenter libraryToolbar, AuthoringWorkbenchDocks docks, Event<ProjectContextChangeEvent> projectContextChangeEvent, ExamplesUtils examplesUtils, Event<NotificationEvent> notificationEvent, ManagedInstance<ExamplesWizard> examplesWizards, TranslationUtils translationUtils, Caller<VFSService> vfsService, Caller<ExplorerService> explorerService, ProjectScopedResolutionStrategySupplier projectScopedResolutionStrategySupplier, Event<PreferencesCentralInitializationEvent> preferencesCentralInitializationEvent) {
        this.breadcrumbs = breadcrumbs;
        this.ts = ts;
        this.projectDetailEvent = projectDetailEvent;
        this.assetDetailEvent = assetDetailEvent;
        this.resourceUtils = resourceUtils;
        this.libraryService = libraryService;
        this.placeManager = placeManager;
        this.libraryPerspective = libraryPerspective;
        this.projectContext = projectContext;
        this.libraryToolbar = libraryToolbar;
        this.docks = docks;
        this.projectContextChangeEvent = projectContextChangeEvent;
        this.examplesUtils = examplesUtils;
        this.notificationEvent = notificationEvent;
        this.examplesWizards = examplesWizards;
        this.translationUtils = translationUtils;
        this.vfsService = vfsService;
        this.explorerService = explorerService;
        this.projectScopedResolutionStrategySupplier = projectScopedResolutionStrategySupplier;
        this.preferencesCentralInitializationEvent = preferencesCentralInitializationEvent;
    }

    public ProjectInfo getProjectInfo() {
        return new ProjectInfo(this.projectContext.getActiveOrganizationalUnit(), this.projectContext.getActiveRepository(), this.projectContext.getActiveBranch(), this.projectContext.getActiveProject());
    }

    public void onSelectPlaceEvent(@Observes PlaceGainFocusEvent placeGainFocusEvent) {
        if (this.isLibraryPerspectiveOpen() && !this.closingLibraryPlaces) {
            ProjectInfo projectInfo = this.getProjectInfo();
            PlaceRequest place = placeGainFocusEvent.getPlace();
            if (place instanceof PathPlaceRequest) {
                PathPlaceRequest pathPlaceRequest = (PathPlaceRequest)place;
                this.setupLibraryBreadCrumbsForAsset(projectInfo, (Path)pathPlaceRequest.getPath());
                this.showDocks();
            } else if (!place.getIdentifier().equals(MESSAGES) && this.isLibraryPlace(place)) {
                this.hideDocks();
                if (place.getIdentifier().equals(PROJECT_SETTINGS)) {
                    this.setupLibraryBreadCrumbsForAsset(projectInfo, null);
                } else if (projectInfo.getProject() != null && (place.getIdentifier().equals(PROJECT_SCREEN) || place.getIdentifier().equals(EMPTY_PROJECT_SCREEN))) {
                    this.setupLibraryBreadCrumbsForProject(projectInfo);
                } else if (place.getIdentifier().equals(LIBRARY_SCREEN) || place.getIdentifier().equals(EMPTY_LIBRARY_SCREEN)) {
                    this.setupLibraryBreadCrumbs();
                }
            }
        }
    }

    public void hideDocks() {
        if (!this.docksHidden) {
            this.docks.hide();
            this.docksHidden = true;
        }
    }

    public void showDocks() {
        if (this.docksHidden) {
            if (!this.docksReady) {
                this.docks.setup(LIBRARY_PERSPECTIVE, (PlaceRequest)new DefaultPlaceRequest(PROJECT_EXPLORER));
                this.docksReady = true;
            }
            this.docks.show();
            this.docksHidden = false;
        }
    }

    private boolean isLibraryPlace(PlaceRequest place) {
        return LIBRARY_PLACES.contains(place.getIdentifier());
    }

    public void newResourceCreated(@Observes NewResourceSuccessEvent newResourceSuccessEvent) {
        if (this.isLibraryPerspectiveOpen()) {
            this.assetDetailEvent.fire((Object)new AssetDetailEvent(this.getProjectInfo(), newResourceSuccessEvent.getPath()));
        }
    }

    public void assetRenamedAccepted(@Observes ConcurrentRenameAcceptedEvent concurrentRenameAcceptedEvent) {
        if (this.isLibraryPerspectiveOpen()) {
            ProjectInfo projectInfo = this.getProjectInfo();
            ObservablePath path = concurrentRenameAcceptedEvent.getPath();
            this.goToAsset(projectInfo, (Path)path);
            this.setupLibraryBreadCrumbsForAsset(projectInfo, (Path)path);
        }
    }

    public void projectDeleted(@Observes DeleteProjectEvent deleteProjectEvent) {
        if (this.isLibraryPerspectiveOpen() && deleteProjectEvent.getProject().equals((Object)this.lastViewedProject)) {
            this.closeAllPlaces();
            this.goToLibrary();
            this.notificationEvent.fire((Object)new NotificationEvent(this.ts.getTranslation("ProjectDeleted"), NotificationEvent.NotificationType.DEFAULT));
        }
    }

    public void projectRenamed(@Observes RenameProjectEvent renameProjectEvent) {
        if (this.isLibraryPerspectiveOpen()) {
            Project activeProject = this.projectContext.getActiveProject();
            if (renameProjectEvent.getOldProject().equals((Object)activeProject)) {
                this.setupLibraryBreadCrumbsForAsset(new ProjectInfo(this.projectContext.getActiveOrganizationalUnit(), this.projectContext.getActiveRepository(), this.projectContext.getActiveBranch(), renameProjectEvent.getNewProject()), null);
                this.lastViewedProject = renameProjectEvent.getNewProject();
            }
        }
    }

    public void assetSelected(@Observes AssetDetailEvent assetDetails) {
        this.goToAsset(assetDetails.getProjectInfo(), assetDetails.getPath());
    }

    public void projectContextChange() {
        ProjectInfo projectInfo = new ProjectInfo(this.projectContext.getActiveOrganizationalUnit(), this.projectContext.getActiveRepository(), this.projectContext.getActiveBranch(), this.projectContext.getActiveProject());
        if (this.isLibraryPerspectiveOpen() && this.projectContext.getActiveRepository() != null) {
            if (this.libraryToolbar.getSelectedRepository() != null && !this.libraryToolbar.getSelectedRepository().equals(this.projectContext.getActiveRepository()) || this.libraryToolbar.getSelectedBranch() != null && !this.libraryToolbar.getSelectedBranch().equals(this.projectContext.getActiveBranch())) {
                this.libraryToolbar.setSelectedInfo(this.projectContext.getActiveOrganizationalUnit(), this.projectContext.getActiveRepository(), () -> {
                    if (this.projectContext.getActiveProject() != null) {
                        this.goToProject(projectInfo, false);
                    }
                });
            } else if (this.projectContext.getActiveProject() != null && !this.projectContext.getActiveProject().equals((Object)this.lastViewedProject)) {
                this.goToProject(projectInfo, false);
            }
        }
    }

    private boolean isLibraryPerspectiveOpen() {
        return this.placeManager.getStatus(LIBRARY_PERSPECTIVE).equals((Object)PlaceStatus.OPEN) || this.placeManager.getStatus(this.getLibraryPlaceRequestWithoutRefresh()).equals((Object)PlaceStatus.OPEN);
    }

    public void onPreferencesSave(@Observes PreferencesCentralSaveEvent event) {
        if (this.isLibraryPerspectiveOpen()) {
            this.goToProject(this.getProjectInfo());
        }
    }

    public void onPreferencesCancel(@Observes PreferencesCentralUndoChangesEvent event) {
        if (this.isLibraryPerspectiveOpen()) {
            this.goToProject(this.getProjectInfo());
        }
    }

    public void onSocialFileSelected(final @Observes SocialFileSelectedEvent event) {
        ((VFSService)this.vfsService.call((RemoteCallback)new RemoteCallback<Path>(){

            public void callback(final Path path) {
                ((ExplorerService)LibraryPlaces.this.explorerService.call((RemoteCallback)new RemoteCallback<URIStructureExplorerModel>(){

                    public void callback(URIStructureExplorerModel model) {
                        LibraryPlaces.this.openBestSuitedScreen(event.getEventType(), path, new ProjectInfo(model.getOrganizationalUnit(), model.getRepository(), model.getRepository().getDefaultBranch(), model.getProject()));
                    }
                })).getURIStructureExplorerModel(path);
            }
        })).get(event.getUri());
    }

    private void openBestSuitedScreen(String eventType, Path path, ProjectInfo projectInfo) {
        PlaceRequest libraryPerspective = this.getLibraryPlaceRequestWithoutRefresh();
        if (this.isRepositoryEvent(eventType)) {
            this.placeManager.goTo(REPOSITORY_STRUCTURE_SCREEN);
        } else if (this.isProjectEvent(eventType)) {
            this.placeManager.goTo(libraryPerspective);
            this.goToProject(projectInfo);
        } else if (path != null) {
            this.placeManager.goTo(libraryPerspective);
            this.goToProject(projectInfo, true, () -> this.goToAsset(projectInfo, path));
        }
    }

    PlaceRequest getLibraryPlaceRequestWithoutRefresh() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("refresh", "false");
        return new DefaultPlaceRequest(LIBRARY_PERSPECTIVE, params);
    }

    private boolean isRepositoryEvent(String eventType) {
        if (eventType == null || eventType.isEmpty()) {
            return false;
        }
        return ExtendedTypes.NEW_REPOSITORY_EVENT.name().equals(eventType) || AssetManagementEventTypes.BRANCH_CREATED.name().equals(eventType) || AssetManagementEventTypes.REPOSITORY_CHANGE.name().equals(eventType);
    }

    private boolean isProjectEvent(String eventType) {
        return ProjectEventType.NEW_PROJECT.name().equals(eventType);
    }

    public void setupToolBar() {
        this.breadcrumbs.clearBreadcrumbsAndToolBars(LIBRARY_PERSPECTIVE);
        this.breadcrumbs.addToolbar(LIBRARY_PERSPECTIVE, (Element)this.libraryToolbar.getView().getElement());
    }

    public void setupLibraryBreadCrumbsForOrganizationUnits() {
        this.breadcrumbs.clearBreadcrumbsAndToolBars(LIBRARY_PERSPECTIVE);
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.translationUtils.getOrganizationalUnitAliasInPlural(), () -> this.goToOrganizationalUnits());
    }

    public void setupLibraryBreadCrumbs() {
        this.setupToolBar();
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.translationUtils.getOrganizationalUnitAliasInPlural(), () -> this.goToOrganizationalUnits());
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.getSelectedOrganizationalUnit().getName(), () -> this.goToLibrary());
    }

    public void setupLibraryBreadCrumbsForNewProject() {
        this.breadcrumbs.clearBreadcrumbs(LIBRARY_PERSPECTIVE);
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.translationUtils.getOrganizationalUnitAliasInPlural(), () -> this.goToOrganizationalUnits());
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.getSelectedOrganizationalUnit().getName(), () -> this.goToLibrary());
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.ts.getTranslation("NewProject"), () -> this.goToNewProject());
    }

    public void setupLibraryBreadCrumbsForProject(ProjectInfo projectInfo) {
        this.breadcrumbs.clearBreadcrumbs(LIBRARY_PERSPECTIVE);
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.translationUtils.getOrganizationalUnitAliasInPlural(), () -> this.goToOrganizationalUnits());
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.getSelectedOrganizationalUnit().getName(), () -> this.goToLibrary());
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, projectInfo.getProject().getProjectName(), () -> this.goToProject(projectInfo));
    }

    public void setupLibraryBreadCrumbsForAsset(ProjectInfo projectInfo, Path path) {
        String assetName = path != null ? this.resourceUtils.getBaseFileName(path) : this.ts.format("Settings", new Object[0]);
        this.breadcrumbs.clearBreadcrumbs(LIBRARY_PERSPECTIVE);
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.translationUtils.getOrganizationalUnitAliasInPlural(), () -> this.goToOrganizationalUnits());
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.getSelectedOrganizationalUnit().getName(), () -> this.goToLibrary());
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, projectInfo.getProject().getProjectName(), () -> this.goToProject(projectInfo));
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, assetName, () -> this.goToAsset(projectInfo, path));
    }

    public void setupLibraryBreadCrumbsForPreferences(ProjectInfo projectInfo) {
        this.breadcrumbs.clearBreadcrumbs(LIBRARY_PERSPECTIVE);
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.translationUtils.getOrganizationalUnitAliasInPlural(), () -> this.goToOrganizationalUnits());
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.getSelectedOrganizationalUnit().getName(), () -> this.goToLibrary());
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, projectInfo.getProject().getProjectName(), () -> this.goToProject(projectInfo));
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.ts.getTranslation("Preferences"), () -> this.goToPreferences());
    }

    public void refresh(Command callback) {
        this.translationUtils.refresh(() -> this.libraryToolbar.init(() -> {
            this.setupToolBar();
            if (callback != null) {
                callback.execute();
            }
        }));
    }

    public void goToOrganizationalUnits() {
        if (this.closeAllPlacesOrNothing()) {
            DefaultPlaceRequest placeRequest = new DefaultPlaceRequest(ORGANIZATIONAL_UNITS_SCREEN);
            PartDefinitionImpl part = new PartDefinitionImpl((PlaceRequest)placeRequest);
            part.setSelectable(false);
            this.placeManager.goTo((PartDefinition)part, this.libraryPerspective.getRootPanel());
            this.setupLibraryBreadCrumbsForOrganizationUnits();
            this.projectContextChangeEvent.fire((Object)new ProjectContextChangeEvent(this.getSelectedOrganizationalUnit()));
        }
    }

    public void goToLibrary() {
        this.goToLibrary(null);
    }

    public void goToLibrary(final Command callback) {
        ((LibraryService)this.libraryService.call((RemoteCallback)new RemoteCallback<Boolean>(){

            public void callback(Boolean hasProjects) {
                ((LibraryService)LibraryPlaces.this.libraryService.call(libraryInfo -> {
                    PlaceRequest placeRequest = new ConditionalPlaceRequest(LibraryPlaces.LIBRARY_SCREEN).when(p -> hasProjects).orElse((PlaceRequest)new DefaultPlaceRequest(LibraryPlaces.EMPTY_LIBRARY_SCREEN));
                    PartDefinitionImpl part = new PartDefinitionImpl(placeRequest);
                    part.setSelectable(false);
                    LibraryPlaces.this.closeLibraryPlaces();
                    LibraryPlaces.this.placeManager.goTo((PartDefinition)part, LibraryPlaces.this.libraryPerspective.getRootPanel());
                    LibraryPlaces.this.setupLibraryBreadCrumbs();
                    LibraryPlaces.this.hideDocks();
                    if (callback != null) {
                        callback.execute();
                    } else {
                        LibraryPlaces.this.projectContextChangeEvent.fire((Object)new ProjectContextChangeEvent(LibraryPlaces.this.getSelectedOrganizationalUnit(), LibraryPlaces.this.getSelectedRepository(), LibraryPlaces.this.getSelectedBranch()));
                    }
                })).getLibraryInfo(LibraryPlaces.this.getSelectedRepository(), LibraryPlaces.this.getSelectedBranch());
            }
        })).hasProjects(this.getSelectedRepository(), this.getSelectedBranch());
    }

    public void goToProject(ProjectInfo projectInfo) {
        this.goToProject(projectInfo, true);
    }

    public void goToProject(ProjectInfo projectInfo, boolean fireProjectContextChangeEvent) {
        this.goToProject(projectInfo, fireProjectContextChangeEvent, null);
    }

    public void goToProject(ProjectInfo projectInfo, boolean fireProjectContextChangeEvent, Command callback) {
        ((LibraryService)this.libraryService.call(hasAssets -> {
            PlaceRequest projectScreen = new ConditionalPlaceRequest(PROJECT_SCREEN).when(p -> (Boolean)hasAssets).orElse((PlaceRequest)new DefaultPlaceRequest(EMPTY_PROJECT_SCREEN));
            PartDefinitionImpl part = new PartDefinitionImpl(projectScreen);
            part.setSelectable(false);
            boolean goToProject = true;
            if (!projectInfo.getProject().equals((Object)this.lastViewedProject)) {
                goToProject = this.closeAllPlacesOrNothing();
            }
            if (goToProject) {
                this.hideDocks();
                this.lastViewedProject = projectInfo.getProject();
                if (fireProjectContextChangeEvent) {
                    this.projectContextChangeEvent.fire((Object)new ProjectContextChangeEvent(projectInfo.getOrganizationalUnit(), projectInfo.getRepository(), projectInfo.getBranch(), projectInfo.getProject()));
                }
                this.placeManager.goTo((PartDefinition)part, this.libraryPerspective.getRootPanel());
                this.setupLibraryBreadCrumbsForProject(projectInfo);
                this.projectDetailEvent.fire((Object)new ProjectDetailEvent(projectInfo));
                if (callback != null) {
                    callback.execute();
                }
            }
        })).hasAssets(projectInfo.getProject());
    }

    public void goToAsset(ProjectInfo projectInfo, Path path) {
        PlaceRequest placeRequest = this.generatePlaceRequest(path);
        this.placeManager.goTo(placeRequest);
        if (path != null) {
            ObservablePath observablePath = ((PathPlaceRequest)placeRequest).getPath();
            observablePath.onRename(() -> this.setupLibraryBreadCrumbsForAsset(projectInfo, (Path)observablePath));
        }
    }

    public void goToNewProject() {
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest(NEW_PROJECT_SCREEN);
        PartDefinitionImpl part = new PartDefinitionImpl((PlaceRequest)placeRequest);
        part.setSelectable(false);
        this.closeLibraryPlaces();
        this.placeManager.goTo((PartDefinition)part, this.libraryPerspective.getRootPanel());
        this.setupLibraryBreadCrumbsForNewProject();
    }

    public void goToSettings(ProjectInfo projectInfo) {
        this.assetDetailEvent.fire((Object)new AssetDetailEvent(projectInfo, null));
    }

    public void goToImportProjectWizard() {
        String organizationalUnitName = this.projectContext.getActiveOrganizationalUnit().getName();
        String repositoryAlias = this.projectContext.getActiveRepository().getAlias();
        ExamplesWizard examplesWizard = (ExamplesWizard)this.examplesWizards.get();
        examplesWizard.start();
        examplesWizard.setDefaultTargetOrganizationalUnit(organizationalUnitName);
        examplesWizard.setDefaultTargetRepository(repositoryAlias);
    }

    public void goToMessages() {
        this.placeManager.goTo(MESSAGES);
    }

    public void goToPreferences() {
        PreferenceScopeResolutionStrategyInfo customScopeResolutionStrategy = this.projectScopedResolutionStrategySupplier.get();
        PreferencesCentralInitializationEvent initEvent = new PreferencesCentralInitializationEvent("ProjectPreferences", customScopeResolutionStrategy);
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest("PreferencesRootScreen");
        PartDefinitionImpl part = new PartDefinitionImpl((PlaceRequest)placeRequest);
        part.setSelectable(false);
        this.placeManager.goTo((PartDefinition)part, this.libraryPerspective.getRootPanel());
        this.preferencesCentralInitializationEvent.fire((Object)initEvent);
        this.setupLibraryBreadCrumbsForPreferences(this.getProjectInfo());
    }

    public OrganizationalUnit getSelectedOrganizationalUnit() {
        return this.projectContext.getActiveOrganizationalUnit();
    }

    public Repository getSelectedRepository() {
        return this.libraryToolbar.getSelectedRepository();
    }

    public String getSelectedBranch() {
        return this.libraryToolbar.getSelectedBranch();
    }

    PlaceRequest generatePlaceRequest(Path path) {
        if (path == null) {
            return new DefaultPlaceRequest(PROJECT_SETTINGS);
        }
        return this.createPathPlaceRequest(path);
    }

    PathPlaceRequest createPathPlaceRequest(Path path) {
        return new PathPlaceRequest(path);
    }

    void closeLibraryPlaces() {
        this.closingLibraryPlaces = true;
        LIBRARY_PLACES.forEach(place -> this.placeManager.closePlace(place));
        this.closingLibraryPlaces = false;
    }

    boolean closeAllPlacesOrNothing() {
        this.closingLibraryPlaces = true;
        boolean placesClosed = this.placeManager.closeAllPlacesOrNothing();
        this.closingLibraryPlaces = false;
        return placesClosed;
    }

    void closeAllPlaces() {
        this.closingLibraryPlaces = true;
        this.placeManager.closeAllPlaces();
        this.closingLibraryPlaces = false;
    }
}

