/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.screens.explorer.client.utils.Classifier;
import org.kie.workbench.common.screens.explorer.client.utils.Utils;
import org.kie.workbench.common.widgets.client.handlers.NewProjectHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourceHandler;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.workbench.type.ClientResourceType;

@Dependent
public class ResourceUtils {
    private Classifier classifier;
    private ManagedInstance<NewResourceHandler> newResourceHandlers;
    public static final Comparator<NewResourceHandler> NEW_RESOURCE_HANDLER_COMPARATOR_BY_ORDER = (o1, o2) -> {
        if (o1.order() < o2.order()) {
            return -1;
        }
        if (o1.order() > o2.order()) {
            return 1;
        }
        return o1.getDescription().compareToIgnoreCase(o2.getDescription());
    };
    public static final Comparator<NewResourceHandler> NEW_RESOURCE_HANDLER_COMPARATOR_BY_ALPHABETICAL_ORDER = (o1, o2) -> o1.getDescription().compareToIgnoreCase(o2.getDescription());

    @Inject
    public ResourceUtils(Classifier classifier, ManagedInstance<NewResourceHandler> newResourceHandlers) {
        this.classifier = classifier;
        this.newResourceHandlers = newResourceHandlers;
    }

    public String getBaseFileName(Path path) {
        ClientResourceType resourceType = this.classifier.findResourceType(path);
        String baseName = Utils.getBaseFileName((String)path.getFileName(), (String)resourceType.getSuffix());
        return baseName;
    }

    public static boolean isProjectHandler(NewResourceHandler handler) {
        return handler instanceof NewProjectHandler;
    }

    public static boolean isDefaultProjectHandler(NewResourceHandler handler) {
        return handler.getClass().getName().contains("org.kie.workbench.common.screens.projecteditor.client.handlers.NewProjectHandler");
    }

    public static boolean isPackageHandler(NewResourceHandler handler) {
        return handler.getClass().getName().contains("NewPackageHandler");
    }

    public static boolean isUploadHandler(NewResourceHandler handler) {
        return handler.getClass().getName().contains("NewFileUploader");
    }

    public List<NewResourceHandler> getOrderedNewResourceHandlers() {
        return this.getNewResourceHandlers(NEW_RESOURCE_HANDLER_COMPARATOR_BY_ORDER);
    }

    public List<NewResourceHandler> getAlphabeticallyOrderedNewResourceHandlers() {
        return this.getNewResourceHandlers(NEW_RESOURCE_HANDLER_COMPARATOR_BY_ALPHABETICAL_ORDER);
    }

    private List<NewResourceHandler> getNewResourceHandlers(Comparator<NewResourceHandler> sortComparator) {
        ArrayList<NewResourceHandler> sortedNewResourceHandlers = new ArrayList<NewResourceHandler>();
        this.getNewResourceHandlers().forEach(sortedNewResourceHandlers::add);
        Collections.sort(sortedNewResourceHandlers, sortComparator);
        return sortedNewResourceHandlers;
    }

    Iterable<NewResourceHandler> getNewResourceHandlers() {
        return this.newResourceHandlers;
    }
}

