/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.util;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.library.api.preferences.LibraryPreferences;
import org.uberfire.mvp.Command;

@ApplicationScoped
public class TranslationUtils {
    private LibraryPreferences libraryPreferences;
    private TranslationService ts;
    private String organizationalUnitAliasInSingular;
    private String organizationalUnitAliasInPlural;

    @Inject
    public TranslationUtils(LibraryPreferences libraryPreferences, TranslationService ts) {
        this.libraryPreferences = libraryPreferences;
        this.ts = ts;
    }

    public void refresh(Command callback) {
        this.libraryPreferences.load(loadedLibraryPreferences -> {
            this.organizationalUnitAliasInSingular = loadedLibraryPreferences.getOrganizationalUnitPreferences().getAliasInSingular();
            if (this.organizationalUnitAliasInSingular == null || this.organizationalUnitAliasInSingular.isEmpty()) {
                this.organizationalUnitAliasInSingular = this.getOrganizationalUnitDefaultAliasInSingular();
            }
            this.organizationalUnitAliasInPlural = loadedLibraryPreferences.getOrganizationalUnitPreferences().getAliasInPlural();
            if (this.organizationalUnitAliasInPlural == null || this.organizationalUnitAliasInPlural.isEmpty()) {
                this.organizationalUnitAliasInPlural = this.getOrganizationalUnitDefaultAliasInPlural();
            }
        }, error -> {
            this.organizationalUnitAliasInSingular = this.getOrganizationalUnitDefaultAliasInSingular();
            this.organizationalUnitAliasInPlural = this.getOrganizationalUnitDefaultAliasInPlural();
        });
        callback.execute();
    }

    private String getOrganizationalUnitDefaultAliasInPlural() {
        return this.ts.format("OrganizationalUnitDefaultAliasInPlural", new Object[0]);
    }

    private String getOrganizationalUnitDefaultAliasInSingular() {
        return this.ts.format("OrganizationalUnitDefaultAliasInSingular", new Object[0]);
    }

    public String getOrganizationalUnitAliasInSingular() {
        return this.organizationalUnitAliasInSingular;
    }

    public String getOrganizationalUnitAliasInPlural() {
        return this.organizationalUnitAliasInPlural;
    }
}

