/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.widgets;

import javax.inject.Inject;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Document;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Label;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Option;
import org.jboss.errai.common.client.dom.Select;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.widgets.LibraryToolbarPresenter;

@Templated
public class LibraryToolbarView
implements LibraryToolbarPresenter.View,
IsElement {
    @Inject
    Document document;
    @Inject
    @DataField(value="repositories-label")
    Label repositoriesLabel;
    @Inject
    @DataField
    Select repositories;
    @Inject
    @DataField(value="branches-label")
    Label branchesLabel;
    @Inject
    @DataField
    Select branches;
    private LibraryToolbarPresenter presenter;

    public void init(LibraryToolbarPresenter presenter) {
        this.presenter = presenter;
        this.repositories.setOnchange(event -> presenter.onUpdateSelectedRepository());
        this.branches.setOnchange(event -> presenter.onUpdateSelectedBranch());
    }

    @Override
    public void clearRepositories() {
        DOMUtil.removeAllChildren((Node)this.repositories);
    }

    @Override
    public void addRepository(String alias) {
        this.repositories.add((HTMLElement)this.createOption(alias));
    }

    @Override
    public String getSelectedRepository() {
        return this.repositories.getValue();
    }

    @Override
    public void setSelectedRepository(String alias) {
        this.repositories.setValue(alias);
    }

    @Override
    public void setRepositorySelectorVisibility(boolean visible) {
        this.repositories.setHidden(!visible);
        this.repositoriesLabel.setHidden(!visible);
    }

    @Override
    public void clearBranches() {
        DOMUtil.removeAllChildren((Node)this.branches);
    }

    @Override
    public void addBranch(String branchName) {
        this.branches.add((HTMLElement)this.createOption(branchName));
    }

    @Override
    public String getSelectedBranch() {
        return this.branches.getValue();
    }

    @Override
    public void setSelectedBranch(String branchName) {
        this.branches.setValue(branchName);
    }

    @Override
    public void setBranchSelectorVisibility(boolean visible) {
        this.branches.setHidden(!visible);
        this.branchesLabel.setHidden(!visible);
    }

    private Option createOption(String ou) {
        Option option = (Option)this.document.createElement("option");
        option.setText(ou);
        return option;
    }
}

