/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.widgets;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.screens.library.api.ProjectInfo;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.kie.workbench.common.screens.library.client.util.ResourceUtils;
import org.kie.workbench.common.widgets.client.handlers.NewProjectHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourceHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.mvp.Command;

public class NewProjectButtonWidget {
    private View view;
    private ManagedInstance<NewProjectHandler> newProjectHandlers;
    private org.kie.workbench.common.screens.projecteditor.client.handlers.NewProjectHandler newDefaultProjectHandler;
    private NewResourcePresenter newResourcePresenter;
    private LibraryPlaces libraryPlaces;

    @Inject
    public NewProjectButtonWidget(View view, ManagedInstance<NewProjectHandler> newProjectHandlers, org.kie.workbench.common.screens.projecteditor.client.handlers.NewProjectHandler newDefaultProjectHandler, NewResourcePresenter newResourcePresenter, LibraryPlaces libraryPlaces) {
        this.view = view;
        this.newProjectHandlers = newProjectHandlers;
        this.newDefaultProjectHandler = newDefaultProjectHandler;
        this.newResourcePresenter = newResourcePresenter;
        this.libraryPlaces = libraryPlaces;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.view.addHeader(this.view.getDefaultProjectHeaderTitle());
        if (this.newDefaultProjectHandler.canCreate()) {
            this.addNewProjectHandler(this.view.getQuickSetupDescription(), () -> this.libraryPlaces.goToNewProject());
            this.addNewProjectHandler(this.view.getAdvancedSetupDescription(), (NewProjectHandler)this.newDefaultProjectHandler);
        }
        this.view.addHeader(this.view.getOtherProjectsHeaderTitle());
        for (NewProjectHandler newProjectHandler : this.getNewProjectHandlers()) {
            if (ResourceUtils.isDefaultProjectHandler((NewResourceHandler)newProjectHandler) || !newProjectHandler.canCreate()) continue;
            this.addNewProjectHandler(newProjectHandler.getDescription(), newProjectHandler);
        }
    }

    private void addNewProjectHandler(String description, NewProjectHandler newProjectHandler) {
        newProjectHandler.setOpenEditorOnCreation(false);
        newProjectHandler.setCreationSuccessCallback(project -> {
            if (project != null) {
                ProjectInfo projectInfo = new ProjectInfo(this.libraryPlaces.getSelectedOrganizationalUnit(), this.libraryPlaces.getSelectedRepository(), this.libraryPlaces.getSelectedBranch(), project);
                this.libraryPlaces.goToProject(projectInfo);
            }
        });
        this.view.addNewProjectHandler(description, newProjectHandler);
    }

    private void addNewProjectHandler(String description, Command command) {
        this.view.addNewProjectHandler(description, command);
    }

    public void openImportWizard() {
        this.libraryPlaces.goToImportProjectWizard();
    }

    public NewResourcePresenter getNewResourcePresenter() {
        return this.newResourcePresenter;
    }

    public View getView() {
        return this.view;
    }

    Iterable<NewProjectHandler> getNewProjectHandlers() {
        return this.newProjectHandlers;
    }

    public static interface View
    extends UberElement<NewProjectButtonWidget> {
        public void addNewProjectHandler(String var1, NewProjectHandler var2);

        public void addNewProjectHandler(String var1, Command var2);

        public void addHeader(String var1);

        public String getDefaultProjectHeaderTitle();

        public String getQuickSetupDescription();

        public String getAdvancedSetupDescription();

        public String getOtherProjectsHeaderTitle();
    }
}

