/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.assets;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.ext.uberfire.social.activities.client.widgets.utils.SocialDateFormatter;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.context.WorkspaceProjectContextChangeEvent;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.defaulteditor.client.editor.NewFileUploader;
import org.kie.workbench.common.screens.explorer.client.utils.Classifier;
import org.kie.workbench.common.screens.explorer.client.utils.Utils;
import org.kie.workbench.common.screens.explorer.model.FolderItemType;
import org.kie.workbench.common.screens.library.api.AssetInfo;
import org.kie.workbench.common.screens.library.api.AssetQueryResult;
import org.kie.workbench.common.screens.library.api.ProjectAssetListUpdated;
import org.kie.workbench.common.screens.library.api.ProjectAssetsQuery;
import org.kie.workbench.common.screens.library.api.Routed;
import org.kie.workbench.common.screens.library.client.screens.EmptyState;
import org.kie.workbench.common.screens.library.client.screens.assets.AssetQueryService;
import org.kie.workbench.common.screens.library.client.screens.assets.events.UpdatedAssetsEvent;
import org.kie.workbench.common.screens.library.client.util.CategoryUtils;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.kie.workbench.common.screens.library.client.widgets.project.AssetItemWidget;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.CategoriesManagerCache;
import org.uberfire.client.mvp.ResourceTypeManagerCache;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.client.workbench.events.SelectPlaceEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.select.SelectOption;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.util.URIUtil;
import org.uberfire.workbench.category.Category;
import org.uberfire.workbench.type.ResourceTypeDefinition;

public class PopulatedAssetsScreen {
    private View view;
    private final CategoriesManagerCache categoriesManagerCache;
    private final ResourceTypeManagerCache resourceTypeManagerCache;
    private BusyIndicatorView busyIndicatorView;
    private LibraryPlaces libraryPlaces;
    private TranslationService ts;
    private Classifier assetClassifier;
    private ManagedInstance<AssetItemWidget> assetItemWidget;
    private NewFileUploader newFileUploader;
    private NewResourcePresenter newResourcePresenter;
    private ProjectController projectController;
    private Event<UpdatedAssetsEvent> updatedAssetsEventEvent;
    private EmptyState emptyState;
    private CategoryUtils categoryUtils;
    private WorkspaceProject workspaceProject;
    private int currentPage;
    private int pageSize;
    private String filter;
    private int totalPages;
    private String filterType;
    private final Event<WorkspaceProjectContextChangeEvent> contextChangeEvent;
    private AssetQueryService assetQueryService;

    @Inject
    public PopulatedAssetsScreen(View view, CategoriesManagerCache categoriesManagerCache, ResourceTypeManagerCache resourceTypeManagerCache, BusyIndicatorView busyIndicatorView, LibraryPlaces libraryPlaces, TranslationService ts, Classifier assetClassifier, ManagedInstance<AssetItemWidget> assetItemWidget, NewFileUploader newFileUploader, NewResourcePresenter newResourcePresenter, ProjectController projectController, Event<UpdatedAssetsEvent> updatedAssetsEventEvent, EmptyState emptyState, CategoryUtils categoryUtils, AssetQueryService assetQueryService, Event<WorkspaceProjectContextChangeEvent> contextChangeEvent) {
        this.view = view;
        this.categoriesManagerCache = categoriesManagerCache;
        this.resourceTypeManagerCache = resourceTypeManagerCache;
        this.busyIndicatorView = busyIndicatorView;
        this.libraryPlaces = libraryPlaces;
        this.ts = ts;
        this.assetClassifier = assetClassifier;
        this.assetItemWidget = assetItemWidget;
        this.newFileUploader = newFileUploader;
        this.newResourcePresenter = newResourcePresenter;
        this.projectController = projectController;
        this.updatedAssetsEventEvent = updatedAssetsEventEvent;
        this.emptyState = emptyState;
        this.categoryUtils = categoryUtils;
        this.assetQueryService = assetQueryService;
        this.contextChangeEvent = contextChangeEvent;
    }

    @PostConstruct
    public void init() {
        this.workspaceProject = this.libraryPlaces.getActiveWorkspace();
        this.view.init(this);
        this.filterType = "ALL";
        this.view.setCategories(this.categoryUtils.createCategories());
        this.filter = "";
        this.currentPage = 1;
        this.pageSize = 15;
    }

    public void onAssetListUpdated(@Observes @Routed ProjectAssetListUpdated event) {
        if (event.getProject().getRepository().getIdentifier().equals(this.workspaceProject.getRepository().getIdentifier())) {
            this.update();
        }
    }

    private void addAssetsToView(AssetQueryResult result) {
        switch (result.getResultType()) {
            case Normal: {
                List assetInfos = (List)result.getAssetInfos().get();
                if (assetInfos.isEmpty()) {
                    this.showSearchHitNothing();
                } else {
                    this.hideEmptyState();
                    assetInfos.forEach(asset -> {
                        if (!asset.getFolderItem().getType().equals((Object)FolderItemType.FOLDER)) {
                            AssetItemWidget item = (AssetItemWidget)this.assetItemWidget.get();
                            ClientResourceType assetResourceType = this.getResourceType((AssetInfo)asset);
                            String assetName = this.getAssetName((AssetInfo)asset, assetResourceType);
                            item.init(assetName, this.getAssetPath((AssetInfo)asset), assetResourceType.getDescription(), assetResourceType.getIcon(), this.getLastModifiedTime((AssetInfo)asset), this.getCreatedTime((AssetInfo)asset), this.detailsCommand((Path)asset.getFolderItem().getItem()), this.selectCommand((Path)asset.getFolderItem().getItem()));
                            this.view.addAssetItem(item);
                        }
                    });
                }
                this.updatedAssetsEventEvent.fire((Object)new UpdatedAssetsEvent(assetInfos));
                this.busyIndicatorView.hideBusyIndicator();
                break;
            }
            case Unindexed: {
                this.showIndexingNotFinished();
                break;
            }
            case DoesNotExist: {
                this.contextChangeEvent.fire((Object)new WorkspaceProjectContextChangeEvent(this.workspaceProject.getOrganizationalUnit()));
                break;
            }
            default: {
                throw new UnsupportedOperationException("No case for " + result.getResultType());
            }
        }
    }

    public void importAsset() {
        if (this.canUpdateProject()) {
            this.newFileUploader.getCommand(this.newResourcePresenter).execute();
        }
    }

    public void setFilterType(String filterType) {
        this.filterType = filterType;
        this.update();
    }

    protected boolean canUpdateProject() {
        return this.projectController.canUpdateProject(this.workspaceProject);
    }

    protected void showIndexingNotFinished() {
        this.showEmptyState(this.ts.getTranslation("IndexingHasNotFinished"), this.ts.getTranslation("PleaseWaitWhileTheProjectContentIsBeingIndexed"));
    }

    public void showSearchHitNothing() {
        this.showEmptyState(this.ts.getTranslation("EmptySearch"), this.ts.getTranslation("NoFilesWhereFoundWithTheGivenSearchCriteria"));
    }

    public void showEmptyState(String title, String message) {
        this.emptyState.clear();
        this.emptyState.setMessage(title, message);
        this.view.showEmptyState(this.emptyState);
    }

    public void hideEmptyState() {
        this.emptyState.clear();
        this.view.hideEmptyState(this.emptyState);
    }

    public void addAsset() {
        if (this.canUpdateProject()) {
            this.libraryPlaces.goToAddAsset();
        }
    }

    public void nextPage() {
        int totalPages = this.getTotalPages();
        if (this.currentPage + 1 <= totalPages) {
            ++this.currentPage;
            this.update();
        }
    }

    public void prevPage() {
        if (this.currentPage - 1 >= 1) {
            --this.currentPage;
            this.update();
        }
    }

    private int getTotalPages() {
        return this.totalPages;
    }

    protected void setTotalPages(int numberOfAssets, int pageSize) {
        this.totalPages = this.totalPages(numberOfAssets, pageSize);
    }

    protected int totalPages(int elements, int size) {
        return Integer.valueOf((int)Math.ceil(elements / size)) + 1;
    }

    protected void update() {
        this.view.clear();
        this.hideEmptyState();
        this.busyIndicatorView.showBusyIndicator(this.ts.getTranslation("LoadingAssets"));
        this.resolveAssetsCount();
        this.getAssets(this.filter, this.filterType, this.getOffset(), this.currentPage * this.pageSize, (RemoteCallback<AssetQueryResult>)((RemoteCallback)this::addAssetsToView));
        this.view.setCurrentPage(this.currentPage);
        this.checkPaginationButtons();
    }

    protected void checkPaginationButtons() {
        if (this.currentPage - 1 < 1) {
            this.view.disablePreviousButton();
        } else {
            this.view.enablePreviousButton();
        }
        if (this.currentPage + 1 > this.getTotalPages()) {
            this.view.disableNextButton();
        } else {
            this.view.enableNextButton();
        }
    }

    protected int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        if (currentPage <= this.getTotalPages() && currentPage > 0) {
            this.currentPage = currentPage;
            this.update();
        } else {
            this.view.setCurrentPage(this.currentPage);
        }
    }

    private int getOffset() {
        return this.buildOffset(this.currentPage, this.pageSize);
    }

    protected int buildOffset(int page, int size) {
        return (page - 1) * size;
    }

    private ClientResourceType getResourceType(AssetInfo asset) {
        return this.assetClassifier.findResourceType(asset.getFolderItem());
    }

    private String getAssetName(AssetInfo asset, ClientResourceType assetResourceType) {
        return Utils.getBaseFileName((String)asset.getFolderItem().getFileName(), (String)assetResourceType.getSuffix());
    }

    private String getAssetPath(AssetInfo asset) {
        String fullPath = ((Path)asset.getFolderItem().getItem()).toURI();
        String projectRootPath = this.workspaceProject.getRootPath().toURI();
        String relativeAssetPath = fullPath.substring(projectRootPath.length());
        String decodedRelativeAssetPath = URIUtil.decode((String)relativeAssetPath);
        return decodedRelativeAssetPath;
    }

    private void getAssets(String filter, String filterType, int startIndex, int amount, RemoteCallback<AssetQueryResult> callback) {
        if (!this.isProjectNull()) {
            ProjectAssetsQuery query = this.createProjectQuery(filter, filterType, startIndex, amount);
            this.assetQueryService.getAssets(query).call(callback, (ErrorCallback<Message>)new DefaultErrorCallback());
        } else {
            this.busyIndicatorView.hideBusyIndicator();
        }
    }

    protected ProjectAssetsQuery createProjectQuery(String filter, String filterType, int startIndex, int amount) {
        Category category = this.categoriesManagerCache.getCategory(filterType);
        List<String> suffixes = this.getSuffixes(category);
        return new ProjectAssetsQuery(this.libraryPlaces.getActiveWorkspace(), filter, startIndex, amount, suffixes);
    }

    protected List<String> getSuffixes(Category category) {
        return this.resourceTypeManagerCache.getResourceTypeDefinitionsByCategory(category).stream().map(ResourceTypeDefinition::getSuffix).collect(Collectors.toList());
    }

    protected void onAssetsUpdated(@Observes UpdatedAssetsEvent event) {
        this.resolveAssetsCount();
    }

    protected void refreshOnFocus(@Observes SelectPlaceEvent selectPlaceEvent) {
        PlaceRequest place = selectPlaceEvent.getPlace();
        if (this.workspaceProject != null && this.workspaceProject.getMainModule() != null && place.getIdentifier().equals("ProjectScreen")) {
            this.update();
        }
    }

    private String getLastModifiedTime(AssetInfo asset) {
        return this.ts.format("LastModified", new Object[0]) + " " + SocialDateFormatter.format((Date)asset.getLastModifiedTime());
    }

    public void search(String filterText) {
        this.filter = filterText;
        this.update();
    }

    private String getCreatedTime(AssetInfo asset) {
        return this.ts.format("Created", new Object[0]) + " " + SocialDateFormatter.format((Date)asset.getCreatedTime());
    }

    protected Command selectCommand(Path assetPath) {
        return () -> this.libraryPlaces.goToAsset(assetPath);
    }

    protected Command detailsCommand(Path assetPath) {
        return this.selectCommand(assetPath);
    }

    public View getView() {
        return this.view;
    }

    protected int getAssetsCount(int numberOfAssets, int otherCounter) {
        if (numberOfAssets < otherCounter || otherCounter == 0) {
            return numberOfAssets;
        }
        return otherCounter;
    }

    private void resolveAssetsCount() {
        if (!this.isProjectNull()) {
            ProjectAssetsQuery query = this.createProjectQuery(this.filter, this.filterType, 0, 0);
            this.assetQueryService.getNumberOfAssets(query).call((RemoteCallback<Integer>)((RemoteCallback)numberOfAssets -> {
                int offset = this.getOffset();
                this.view.setPageIndicator(offset + 1, this.getAssetsCount((int)numberOfAssets, offset + this.pageSize), this.getAssetsCount((int)numberOfAssets, 0));
                this.setTotalPages((int)numberOfAssets, this.pageSize);
                this.view.setTotalPages(this.getTotalPages());
                this.checkPaginationButtons();
            }), (ErrorCallback<Message>)new DefaultErrorCallback());
        }
    }

    private boolean isProjectNull() {
        return this.libraryPlaces.getActiveWorkspace() == null || this.libraryPlaces.getActiveWorkspace().getMainModule() == null;
    }

    public static interface View
    extends UberElemental<PopulatedAssetsScreen> {
        public void addAssetItem(AssetItemWidget var1);

        public void setCurrentPage(int var1);

        public void setPageIndicator(int var1, int var2, int var3);

        public void setTotalPages(int var1);

        public void clear();

        public void disablePreviousButton();

        public void enablePreviousButton();

        public void enableNextButton();

        public void disableNextButton();

        public void setCategories(List<SelectOption> var1);

        public void showEmptyState(EmptyState var1);

        public void hideEmptyState(EmptyState var1);
    }
}

