/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.project.branch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.repositories.Branch;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.kie.workbench.common.services.datamodel.util.SortHelper;
import org.kie.workbench.common.services.shared.validation.ValidationService;
import org.kie.workbench.common.widgets.client.callbacks.CommandWithThrowableDrivenErrorCallback;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.workbench.events.NotificationEvent;

public class AddBranchPopUpPresenter {
    private Caller<LibraryService> libraryService;
    private BusyIndicatorView busyIndicatorView;
    private Event<NotificationEvent> notificationEvent;
    private LibraryPlaces libraryPlaces;
    private View view;
    private Caller<ValidationService> validationService;
    WorkspaceProject project;

    @Inject
    public AddBranchPopUpPresenter(Caller<LibraryService> libraryService, BusyIndicatorView busyIndicatorView, Event<NotificationEvent> notificationEvent, LibraryPlaces libraryPlaces, View view, Caller<ValidationService> validationService) {
        this.libraryService = libraryService;
        this.busyIndicatorView = busyIndicatorView;
        this.notificationEvent = notificationEvent;
        this.libraryPlaces = libraryPlaces;
        this.view = view;
        this.validationService = validationService;
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
        this.project = this.libraryPlaces.getActiveWorkspace();
        this.view.setBranches(this.project.getRepository().getBranches().stream().map(Branch::getName).sorted(SortHelper.ALPHABETICAL_ORDER_COMPARATOR).collect(Collectors.toList()));
        this.view.setBranchFrom(this.project.getBranch().getName());
    }

    public void show() {
        this.view.show();
    }

    public void add() {
        String name = this.view.getName();
        String branchFrom = this.view.getBranchFrom();
        this.beginBranchCreation();
        this.validateFields(name, () -> ((LibraryService)this.libraryService.call(v -> {
            this.endBranchCreation();
            this.notifySuccess();
            this.view.hide();
        }, this.getErrorCallback())).addBranch(name, branchFrom, this.project));
    }

    private void validateFields(String name, Runnable successCallback) {
        if (name == null || name.trim().isEmpty()) {
            this.endBranchCreation();
            this.view.showError(this.view.getEmptyNameMessage());
            return;
        }
        ((ValidationService)this.validationService.call(isValid -> {
            if (Boolean.TRUE.equals(isValid)) {
                if (successCallback != null) {
                    successCallback.run();
                }
            } else {
                this.endBranchCreation();
                this.view.showError(this.view.getInvalidNameMessage());
            }
        })).isBranchNameValid(name);
    }

    private void beginBranchCreation() {
        this.view.setAddButtonEnabled(false);
        this.view.showBusyIndicator(this.view.getSavingMessage());
    }

    private void endBranchCreation() {
        this.view.setAddButtonEnabled(true);
        this.view.hideBusyIndicator();
    }

    private void notifySuccess() {
        this.notificationEvent.fire((Object)new NotificationEvent(this.view.getAddBranchSuccessMessage(), NotificationEvent.NotificationType.SUCCESS));
    }

    private ErrorCallback<?> getErrorCallback() {
        HashMap<Class<? extends Throwable>, CommandWithThrowableDrivenErrorCallback.CommandWithThrowable> errors = new HashMap<Class<? extends Throwable>, CommandWithThrowableDrivenErrorCallback.CommandWithThrowable>(){
            {
                this.put(FileAlreadyExistsException.class, parameter -> {
                    AddBranchPopUpPresenter.this.endBranchCreation();
                    AddBranchPopUpPresenter.this.view.showError(AddBranchPopUpPresenter.this.view.getDuplicatedBranchMessage());
                });
            }
        };
        return this.createErrorCallback((Map<Class<? extends Throwable>, CommandWithThrowableDrivenErrorCallback.CommandWithThrowable>)errors);
    }

    ErrorCallback<?> createErrorCallback(Map<Class<? extends Throwable>, CommandWithThrowableDrivenErrorCallback.CommandWithThrowable> errors) {
        return new CommandWithThrowableDrivenErrorCallback((HasBusyIndicator)this.busyIndicatorView, errors);
    }

    public void cancel() {
        this.view.hide();
    }

    public static interface View
    extends UberElemental<AddBranchPopUpPresenter>,
    HasBusyIndicator {
        public void setBranches(List<String> var1);

        public String getName();

        public String getBranchFrom();

        public void setBranchFrom(String var1);

        public void show();

        public void hide();

        public void showError(String var1);

        public String getSavingMessage();

        public String getAddBranchSuccessMessage();

        public String getDuplicatedBranchMessage();

        public String getEmptyNameMessage();

        public String getInvalidNameMessage();

        public void setAddButtonEnabled(boolean var1);
    }
}

