/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.project.delete;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;

public class DeleteProjectPopUpScreen {
    private WorkspaceProject project;
    private View view;
    private Caller<RepositoryService> repositoryService;

    @Inject
    public DeleteProjectPopUpScreen(View view, Caller<RepositoryService> repositoryService) {
        this.view = view;
        this.repositoryService = repositoryService;
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
    }

    public void show(WorkspaceProject project) {
        this.project = project;
        this.view.show(project.getName());
    }

    public void delete() {
        String confirmedName = this.view.getConfirmedName();
        if (!this.project.getName().equals(confirmedName)) {
            this.view.showError(this.view.getWrongConfirmedNameValidationMessage());
            return;
        }
        this.view.showBusyIndicator(this.view.getDeletingMessage());
        ((RepositoryService)this.repositoryService.call(v -> {
            this.view.hideBusyIndicator();
            this.view.hide();
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).removeRepository(this.project.getSpace(), this.project.getRepository().getAlias());
    }

    public void cancel() {
        this.view.hide();
    }

    public static interface View
    extends UberElemental<DeleteProjectPopUpScreen>,
    HasBusyIndicator {
        public String getConfirmedName();

        public void show(String var1);

        public void showError(String var1);

        public void hide();

        public String getWrongConfirmedNameValidationMessage();

        public String getDeletingMessage();
    }
}

