/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.util;

import com.google.gwt.user.client.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.ext.uberfire.social.activities.model.ExtendedTypes;
import org.ext.uberfire.social.activities.model.SocialFileSelectedEvent;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.context.WorkspaceProjectContextChangeEvent;
import org.guvnor.common.services.project.context.WorkspaceProjectContextChangeHandler;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.common.services.project.social.ModuleEventType;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.RemoveOrganizationalUnitEvent;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryRemovedEvent;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.exception.UnauthorizedException;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.screens.examples.model.ImportProject;
import org.kie.workbench.common.screens.explorer.client.utils.Utils;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.api.ProjectAssetListUpdated;
import org.kie.workbench.common.screens.library.api.Remote;
import org.kie.workbench.common.screens.library.api.Routed;
import org.kie.workbench.common.screens.library.api.preferences.LibraryInternalPreferences;
import org.kie.workbench.common.screens.library.client.events.AssetDetailEvent;
import org.kie.workbench.common.screens.library.client.perspective.LibraryPerspective;
import org.kie.workbench.common.screens.library.client.screens.importrepository.ImportProjectsSetupEvent;
import org.kie.workbench.common.screens.library.client.screens.importrepository.ImportRepositoryPopUpPresenter;
import org.kie.workbench.common.screens.library.client.screens.importrepository.Source;
import org.kie.workbench.common.screens.library.client.screens.project.close.CloseUnsavedProjectAssetsPopUpPresenter;
import org.kie.workbench.common.screens.library.client.util.TranslationUtils;
import org.kie.workbench.common.screens.library.client.util.breadcrumb.LibraryBreadcrumbs;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.kie.workbench.common.widgets.client.handlers.NewResourceSuccessEvent;
import org.kie.workbench.common.workbench.client.docks.AuthoringWorkbenchDocks;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.workbench.events.PlaceGainFocusEvent;
import org.uberfire.client.workbench.events.PlaceMaximizedEvent;
import org.uberfire.client.workbench.events.PlaceMinimizedEvent;
import org.uberfire.ext.editor.commons.client.event.ConcurrentDeleteAcceptedEvent;
import org.uberfire.ext.editor.commons.client.event.ConcurrentRenameAcceptedEvent;
import org.uberfire.ext.preferences.client.event.PreferencesCentralSaveEvent;
import org.uberfire.ext.preferences.client.event.PreferencesCentralUndoChangesEvent;
import org.uberfire.ext.widgets.common.client.breadcrumbs.UberfireBreadcrumbs;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.spaces.Space;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.events.ResourceDeletedEvent;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;

@ApplicationScoped
public class LibraryPlaces
implements WorkspaceProjectContextChangeHandler {
    public static final String LIBRARY_PERSPECTIVE = "LibraryPerspective";
    public static final String LIBRARY_SCREEN = "LibraryScreen";
    public static final String PROJECT_SCREEN = "ProjectScreen";
    public static final String IMPORT_PROJECTS_SCREEN = "ImportProjectsScreen";
    public static final String IMPORT_SAMPLE_PROJECTS_SCREEN = "TrySamplesScreen";
    public static final String PROJECT_DETAIL_SCREEN = "ProjectsDetailScreen";
    public static final String ORG_UNITS_METRICS_SCREEN = "OrgUnitsMetricsScreen";
    public static final String PROJECT_METRICS_SCREEN = "ProjectMetricsScreen";
    public static final String ORGANIZATIONAL_UNITS_SCREEN = "LibraryOrganizationalUnitsScreen";
    public static final String PROJECT_SETTINGS = "ProjectSettings";
    public static final String PROJECT_EXPLORER = "org.kie.guvnor.explorer";
    public static final String ALERTS = "org.kie.workbench.common.screens.messageconsole.MessageConsole";
    public static final String REPOSITORY_STRUCTURE_SCREEN = "repositoryStructureScreen";
    public static final String ADD_ASSET_SCREEN = "AddAssetsScreen";
    public static final List<String> LIBRARY_PLACES = Arrays.asList("LibraryScreen", "OrgUnitsMetricsScreen", "ProjectScreen", "ProjectMetricsScreen", "ProjectsDetailScreen", "LibraryOrganizationalUnitsScreen", "ProjectSettings", "AddAssetsScreen", "ImportProjectsScreen", "TrySamplesScreen", "PreferencesRootScreen");
    private UberfireBreadcrumbs breadcrumbs;
    private TranslationService ts;
    private Event<AssetDetailEvent> assetDetailEvent;
    private Caller<LibraryService> libraryService;
    private Caller<WorkspaceProjectService> projectService;
    private Caller<KieModuleService> moduleService;
    private PlaceManager placeManager;
    private LibraryPerspective libraryPerspective;
    private WorkspaceProjectContext projectContext;
    private AuthoringWorkbenchDocks docks;
    private Event<WorkspaceProjectContextChangeEvent> projectContextChangeEvent;
    private Event<NotificationEvent> notificationEvent;
    private TranslationUtils translationUtils;
    private Caller<VFSService> vfsService;
    private ManagedInstance<ImportRepositoryPopUpPresenter> importRepositoryPopUpPresenters;
    private Event<ProjectAssetListUpdated> assetListUpdatedEvent;
    private CloseUnsavedProjectAssetsPopUpPresenter closeUnsavedProjectAssetsPopUpPresenter;
    private Event<ImportProjectsSetupEvent> importProjectsSetupEvent;
    private LibraryBreadcrumbs libraryBreadcrumbs;
    private SessionInfo sessionInfo;
    private LibraryInternalPreferences libraryInternalPreferences;
    private boolean docksReady = false;
    private boolean docksHidden = true;
    private boolean editorMaximized = false;
    private boolean closingLibraryPlaces = false;

    public LibraryPlaces() {
    }

    @Inject
    public LibraryPlaces(UberfireBreadcrumbs breadcrumbs, TranslationService ts, Event<AssetDetailEvent> assetDetailEvent, Caller<LibraryService> libraryService, Caller<WorkspaceProjectService> projectService, Caller<KieModuleService> moduleService, PlaceManager placeManager, WorkspaceProjectContext projectContext, AuthoringWorkbenchDocks docks, Event<WorkspaceProjectContextChangeEvent> projectContextChangeEvent, Event<NotificationEvent> notificationEvent, TranslationUtils translationUtils, Caller<VFSService> vfsService, ManagedInstance<ImportRepositoryPopUpPresenter> importRepositoryPopUpPresenters, @Routed Event<ProjectAssetListUpdated> assetListUpdatedEvent, CloseUnsavedProjectAssetsPopUpPresenter closeUnsavedProjectAssetsPopUpPresenter, @Source(value=Source.Kind.EXTERNAL) Event<ImportProjectsSetupEvent> importProjectsSetupEvent, LibraryBreadcrumbs libraryBreadcrumbs, SessionInfo sessionInfo, LibraryInternalPreferences libraryInternalPreferences) {
        this.breadcrumbs = breadcrumbs;
        this.ts = ts;
        this.assetDetailEvent = assetDetailEvent;
        this.libraryService = libraryService;
        this.projectService = projectService;
        this.moduleService = moduleService;
        this.placeManager = placeManager;
        this.projectContext = projectContext;
        this.docks = docks;
        this.projectContextChangeEvent = projectContextChangeEvent;
        this.notificationEvent = notificationEvent;
        this.translationUtils = translationUtils;
        this.vfsService = vfsService;
        this.importRepositoryPopUpPresenters = importRepositoryPopUpPresenters;
        this.assetListUpdatedEvent = assetListUpdatedEvent;
        this.closeUnsavedProjectAssetsPopUpPresenter = closeUnsavedProjectAssetsPopUpPresenter;
        this.importProjectsSetupEvent = importProjectsSetupEvent;
        this.libraryBreadcrumbs = libraryBreadcrumbs;
        this.sessionInfo = sessionInfo;
        this.libraryInternalPreferences = libraryInternalPreferences;
    }

    @PostConstruct
    public void setup() {
        this.libraryBreadcrumbs.init(this);
        this.projectContext.addChangeHandler((WorkspaceProjectContextChangeHandler)this);
        this.placeManager.registerPerspectiveCloseChain(LIBRARY_PERSPECTIVE, (chain, place) -> {
            if (LIBRARY_PERSPECTIVE.equals(place.getIdentifier())) {
                this.closeAllPlacesOrNothing(() -> ((Command)chain).execute());
            } else {
                this.closePlace(() -> ((Command)chain).execute(), (PlaceRequest)place);
            }
        });
    }

    public void onSelectPlaceEvent(@Observes PlaceGainFocusEvent placeGainFocusEvent) {
        if (this.isLibraryPerspectiveOpen() && !this.closingLibraryPlaces) {
            PlaceRequest place = placeGainFocusEvent.getPlace();
            if (place instanceof PathPlaceRequest) {
                this.libraryBreadcrumbs.setupForAsset(this.getActiveWorkspace(), (Path)((PathPlaceRequest)place).getPath());
                this.showDocks();
            } else if (!place.getIdentifier().equals(ALERTS) && this.isLibraryPlace(place)) {
                this.hideDocks();
                if (this.projectContext.getActiveWorkspaceProject().isPresent() && place.getIdentifier().equals(PROJECT_SCREEN)) {
                    this.libraryBreadcrumbs.setupForProject(this.getActiveWorkspace());
                } else if (this.projectContext.getActiveOrganizationalUnit().isPresent() && place.getIdentifier().equals(LIBRARY_SCREEN)) {
                    this.libraryBreadcrumbs.setupForSpace(this.getActiveSpace());
                }
            }
        }
    }

    public void showDocksWhenMinimizingEditor(@Observes PlaceMinimizedEvent placeMinimizedEvent) {
        this.editorMaximized = false;
        this.showDocks();
    }

    public void hideDocksWhenMaximizingEditor(@Observes PlaceMaximizedEvent placeMaximizedEvent) {
        this.editorMaximized = true;
        this.hideDocks();
    }

    public void onAssetListUpdateEvent(@Observes @Remote ProjectAssetListUpdated event) {
        this.assetListUpdatedEvent.fire((Object)event);
    }

    public void hideDocks() {
        if (!this.docksHidden) {
            this.docks.hide();
            this.docksHidden = true;
        }
    }

    public void showDocks() {
        if (this.docksHidden && !this.editorMaximized) {
            if (!this.docksReady) {
                this.docks.setup(LIBRARY_PERSPECTIVE, (PlaceRequest)new DefaultPlaceRequest(PROJECT_EXPLORER));
                this.docksReady = true;
            }
            this.docks.show();
            this.docksHidden = false;
        }
    }

    private boolean isLibraryPlace(PlaceRequest place) {
        return LIBRARY_PLACES.contains(place.getIdentifier());
    }

    public void onNewResourceCreated(@Observes NewResourceSuccessEvent newResourceSuccessEvent) {
        if (this.isLibraryPerspectiveOpen()) {
            this.assetDetailEvent.fire((Object)new AssetDetailEvent((WorkspaceProject)this.projectContext.getActiveWorkspaceProject().orElseThrow(() -> new IllegalStateException("Cannot fire asset detail event without an active project.")), newResourceSuccessEvent.getPath()));
            this.placeManager.closePlace(ADD_ASSET_SCREEN);
        }
    }

    public void onAssetRenamedAccepted(@Observes ConcurrentRenameAcceptedEvent concurrentRenameAcceptedEvent) {
        if (this.isLibraryPerspectiveOpen()) {
            ObservablePath path = concurrentRenameAcceptedEvent.getPath();
            this.goToAsset((Path)path);
            this.libraryBreadcrumbs.setupForAsset(this.getActiveWorkspace(), (Path)path);
        }
    }

    public void onProjectDeleted(@Observes RepositoryRemovedEvent repositoryRemovedEvent) {
        if (this.isLibraryPerspectiveOpen() && this.isRepoForActiveProject(repositoryRemovedEvent)) {
            this.closeAllPlaces();
            WorkspaceProjectContextChangeEvent contextChangeEvent = this.projectContext.getActiveOrganizationalUnit().map(ou -> new WorkspaceProjectContextChangeEvent(ou)).orElseGet(() -> new WorkspaceProjectContextChangeEvent());
            this.projectContextChangeEvent.fire((Object)contextChangeEvent);
            this.goToLibrary();
            this.notificationEvent.fire((Object)new NotificationEvent(this.ts.getTranslation("ProjectDeleted"), NotificationEvent.NotificationType.DEFAULT));
        }
    }

    private boolean isRepoForActiveProject(RepositoryRemovedEvent repositoryRemovedEvent) {
        return this.projectContext.getActiveWorkspaceProject().filter(project -> {
            Repository activeRepo = project.getRepository();
            Repository eventRepo = repositoryRemovedEvent.getRepository();
            return activeRepo.getIdentifier().equals(eventRepo.getIdentifier());
        }).isPresent();
    }

    public void onOrganizationalUnitRemoved(@Observes RemoveOrganizationalUnitEvent removedOrganizationalUnitEvent) {
        if (this.isLibraryPerspectiveOpen()) {
            this.projectContext.getActiveOrganizationalUnit().filter(active -> active.equals(removedOrganizationalUnitEvent.getOrganizationalUnit())).ifPresent(active -> this.projectContextChangeEvent.fire((Object)new WorkspaceProjectContextChangeEvent()));
        }
    }

    public void onAssetSelected(@Observes AssetDetailEvent assetDetails) {
        this.goToAsset(assetDetails.getPath());
    }

    private boolean isLibraryPerspectiveOpen() {
        PlaceStatus statusPerspective = this.placeManager.getStatus(LIBRARY_PERSPECTIVE);
        PlaceStatus statusPerspectiveWithoutRefresh = this.placeManager.getStatus(this.getLibraryPlaceRequestWithoutRefresh());
        return statusPerspective.equals((Object)PlaceStatus.OPEN) || statusPerspectiveWithoutRefresh.equals((Object)PlaceStatus.OPEN);
    }

    public void onPreferencesSave(@Observes PreferencesCentralSaveEvent event) {
        if (this.isLibraryPerspectiveOpen()) {
            this.goToProject();
        }
    }

    public void onPreferencesCancel(@Observes PreferencesCentralUndoChangesEvent event) {
        if (this.isLibraryPerspectiveOpen()) {
            this.goToProject();
        }
    }

    public void onSocialFileSelected(final @Observes SocialFileSelectedEvent event) {
        ((VFSService)this.vfsService.call((RemoteCallback)new RemoteCallback<Path>(){

            public void callback(final Path path) {
                ((WorkspaceProjectService)LibraryPlaces.this.projectService.call((RemoteCallback)new RemoteCallback<WorkspaceProject>(){

                    public void callback(WorkspaceProject project) {
                        LibraryPlaces.this.openBestSuitedScreen(event.getEventType(), path, project);
                    }
                })).resolveProject(path);
            }
        })).get(event.getUri());
    }

    private void openBestSuitedScreen(String eventType, Path path, WorkspaceProject project) {
        if (!this.projectContext.getActiveWorkspaceProject().map(active -> active.equals((Object)project)).orElse(false).booleanValue()) {
            this.projectContextChangeEvent.fire((Object)new WorkspaceProjectContextChangeEvent(project, project.getMainModule()));
        }
        PlaceRequest libraryPerspectivePlace = this.getLibraryPlaceRequestWithoutRefresh();
        if (this.isRepositoryEvent(eventType)) {
            this.placeManager.goTo(REPOSITORY_STRUCTURE_SCREEN);
        } else if (this.isModuleEvent(eventType)) {
            this.placeManager.goTo(libraryPerspectivePlace);
            this.goToProject();
        } else if (path != null) {
            this.placeManager.goTo(libraryPerspectivePlace);
            this.goToProject(() -> this.goToAsset(path));
        }
    }

    PlaceRequest getLibraryPlaceRequestWithoutRefresh() {
        return this.getPlaceRequestWithoutRefresh(LIBRARY_PERSPECTIVE);
    }

    private PlaceRequest getPlaceRequestWithoutRefresh(String placeId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("refresh", "false");
        return new DefaultPlaceRequest(placeId, params);
    }

    private boolean isRepositoryEvent(String eventType) {
        if (eventType == null || eventType.isEmpty()) {
            return false;
        }
        return ExtendedTypes.NEW_REPOSITORY_EVENT.name().equals(eventType);
    }

    private boolean isModuleEvent(String eventType) {
        return ModuleEventType.NEW_MODULE.name().equals(eventType);
    }

    public void refresh(Command callback) {
        this.editorMaximized = false;
        this.breadcrumbs.clearBreadcrumbs(LIBRARY_PERSPECTIVE);
        this.translationUtils.refresh(() -> ((Command)callback).execute());
    }

    public void goToOrganizationalUnits() {
        this.closeAllPlacesOrNothing(() -> {
            PortablePreconditions.checkNotNull((String)"libraryPerspective.closeAllPlacesOrNothing", (Object)this.libraryPerspective);
            this.projectContextChangeEvent.fire((Object)new WorkspaceProjectContextChangeEvent());
            DefaultPlaceRequest placeRequest = new DefaultPlaceRequest(ORGANIZATIONAL_UNITS_SCREEN);
            PartDefinitionImpl part = new PartDefinitionImpl((PlaceRequest)placeRequest);
            part.setSelectable(false);
            this.placeManager.goTo((PartDefinition)part, this.libraryPerspective.getRootPanel());
            this.libraryBreadcrumbs.setupForSpacesScreen();
        });
    }

    public void goToLibrary() {
        if (!this.projectContext.getActiveOrganizationalUnit().isPresent()) {
            ((LibraryService)this.libraryService.call(organizationalUnit -> {
                this.projectContextChangeEvent.fire((Object)new WorkspaceProjectContextChangeEvent(organizationalUnit));
                this.setupLibraryPerspective();
            }, (message, throwable) -> {
                try {
                    throw throwable;
                }
                catch (UnauthorizedException ue) {
                    this.goToOrganizationalUnits();
                    return false;
                }
                catch (Throwable t) {
                    return true;
                }
            })).getDefaultOrganizationalUnit();
        } else {
            this.setupLibraryPerspective();
        }
    }

    private void setupLibraryPerspective() {
        OrganizationalUnit activeOu = (OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot setup library perspective without active space."));
        PortablePreconditions.checkNotNull((String)"libraryPerspective", (Object)this.libraryPerspective);
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest(LIBRARY_SCREEN);
        PartDefinitionImpl part = new PartDefinitionImpl((PlaceRequest)placeRequest);
        part.setSelectable(false);
        if (!this.projectContext.getActiveWorkspaceProject().isPresent()) {
            this.projectContextChangeEvent.fire((Object)new WorkspaceProjectContextChangeEvent(activeOu));
        }
        this.closeLibraryPlaces();
        this.placeManager.goTo((PartDefinition)part, this.libraryPerspective.getRootPanel());
        this.libraryBreadcrumbs.setupForSpace(activeOu);
        this.hideDocks();
    }

    public void goToProject(WorkspaceProject project) {
        if (this.projectContext.getActiveWorkspaceProject().map(activeProject -> !activeProject.equals((Object)project)).orElse(true).booleanValue()) {
            this.libraryInternalPreferences.load(loadedLibraryInternalPreferences -> this.closeAllPlacesOrNothing(() -> {
                this.projectContextChangeEvent.fire((Object)new WorkspaceProjectContextChangeEvent(project, project.getMainModule()));
                this.goToProject(project, loadedLibraryInternalPreferences.getLastBranchOpened(project).orElse(project.getBranch()));
            }), error -> {});
        } else {
            this.goToProject();
        }
    }

    public void goToProject(WorkspaceProject project, Branch branch) {
        this.libraryInternalPreferences.load(loadedLibraryInternalPreferences -> {
            Optional lastBranchOpened = loadedLibraryInternalPreferences.getLastBranchOpened(project);
            Command goToProjectCommand = () -> ((WorkspaceProjectService)this.projectService.call(this::goToProject)).resolveProject(project.getSpace(), branch);
            if (!lastBranchOpened.isPresent() || !((Branch)lastBranchOpened.get()).equals((Object)branch)) {
                loadedLibraryInternalPreferences.setLastBranchOpened(project, branch);
                loadedLibraryInternalPreferences.save(goToProjectCommand, error -> {});
            } else {
                goToProjectCommand.execute();
            }
        }, error -> {});
    }

    void goToProject() {
        this.goToProject(() -> {});
    }

    private void goToProject(Command callback) {
        this.libraryBreadcrumbs.setupForProject((WorkspaceProject)this.projectContext.getActiveWorkspaceProject().orElseThrow(() -> new IllegalStateException("Cannot go to project when no project is active.")));
        PartDefinitionImpl part = new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest(PROJECT_SCREEN));
        part.setSelectable(false);
        this.placeManager.goTo((PartDefinition)part, this.libraryPerspective.getRootPanel());
        if (callback != null) {
            callback.execute();
        }
    }

    public void goToAsset(Path path) {
        ((KieModuleService)this.moduleService.call(response -> {
            this.projectContextChangeEvent.fire((Object)new WorkspaceProjectContextChangeEvent((WorkspaceProject)this.projectContext.getActiveWorkspaceProject().orElse(null), (Module)this.projectContext.getActiveModule().orElse(null), response));
            PlaceRequest placeRequest = this.generatePlaceRequest(path);
            this.placeManager.goTo(placeRequest);
            if (path != null) {
                ObservablePath observablePath = ((PathPlaceRequest)placeRequest).getPath();
                observablePath.onRename(() -> this.libraryBreadcrumbs.setupForAsset(this.getActiveWorkspace(), (Path)observablePath));
            }
        })).resolvePackage(path);
    }

    public void goToAddAsset() {
        DefaultPlaceRequest addAssetScreen = new DefaultPlaceRequest(ADD_ASSET_SCREEN);
        PartDefinitionImpl part = new PartDefinitionImpl((PlaceRequest)addAssetScreen);
        part.setSelectable(false);
        this.placeManager.goTo((PartDefinition)part, this.libraryPerspective.getRootPanel());
    }

    public void goToTrySamples() {
        this.closeAllPlacesOrNothing(() -> {
            DefaultPlaceRequest placeRequest = new DefaultPlaceRequest(IMPORT_SAMPLE_PROJECTS_SCREEN);
            PartDefinitionImpl part = new PartDefinitionImpl((PlaceRequest)placeRequest);
            part.setSelectable(false);
            this.placeManager.goTo((PartDefinition)part, this.libraryPerspective.getRootPanel());
            this.libraryBreadcrumbs.setupForTrySamples(this.getActiveSpace());
        });
    }

    public void goToImportRepositoryPopUp() {
        ImportRepositoryPopUpPresenter importRepositoryPopUpPresenter = (ImportRepositoryPopUpPresenter)this.importRepositoryPopUpPresenters.get();
        importRepositoryPopUpPresenter.show();
    }

    public void goToExternalImportPresenter(Set<ImportProject> projects) {
        this.closeAllPlacesOrNothing(() -> {
            DefaultPlaceRequest placeRequest = new DefaultPlaceRequest(IMPORT_PROJECTS_SCREEN);
            PartDefinitionImpl part = new PartDefinitionImpl((PlaceRequest)placeRequest);
            part.setSelectable(false);
            this.placeManager.goTo((PartDefinition)part, this.libraryPerspective.getRootPanel());
            this.setupExternalImportBreadCrumbs();
            this.importProjectsSetupEvent.fire((Object)new ImportProjectsSetupEvent(projects));
        });
    }

    public void setupExternalImportBreadCrumbs() {
        this.breadcrumbs.clearBreadcrumbs(LIBRARY_PERSPECTIVE);
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.translationUtils.getOrganizationalUnitAliasInPlural(), () -> this.goToOrganizationalUnits());
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, ((OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot create library breadcrumb without active space."))).getName(), () -> this.goToLibrary());
        this.breadcrumbs.addBreadCrumb(LIBRARY_PERSPECTIVE, this.ts.getTranslation("ImportProjects"), () -> this.goToImportRepositoryPopUp());
    }

    PlaceRequest generatePlaceRequest(Path path) {
        if (path == null) {
            return new DefaultPlaceRequest(PROJECT_SETTINGS);
        }
        return this.createPathPlaceRequest(path);
    }

    PathPlaceRequest createPathPlaceRequest(Path path) {
        return new PathPlaceRequest(path);
    }

    void closeLibraryPlaces() {
        this.closingLibraryPlaces = true;
        LIBRARY_PLACES.forEach(place -> this.placeManager.closePlace(place));
        this.closingLibraryPlaces = false;
    }

    public void closeAllPlacesOrNothing(Command successCallback) {
        this.closingLibraryPlaces = true;
        List uncloseablePlaces = this.placeManager.getUncloseablePlaces();
        if (uncloseablePlaces != null && uncloseablePlaces.isEmpty()) {
            this.placeManager.closeAllPlaces();
            this.closingLibraryPlaces = false;
            if (successCallback != null) {
                successCallback.execute();
            }
        } else {
            Command newSuccessCallback = () -> {
                this.placeManager.forceCloseAllPlaces();
                this.closingLibraryPlaces = false;
                if (successCallback != null) {
                    successCallback.execute();
                }
            };
            this.closeUnsavedProjectAssetsPopUpPresenter.show(this.getActiveWorkspace(), uncloseablePlaces, newSuccessCallback, () -> this.placeManager.goTo((PlaceRequest)uncloseablePlaces.get(0)));
        }
    }

    public void closePlace(Command successCallback, PlaceRequest place) {
        boolean canClosePlace = this.placeManager.canClosePlace(place);
        if (canClosePlace) {
            if (successCallback != null) {
                successCallback.execute();
            }
        } else {
            Command newSuccessCallback = () -> {
                this.placeManager.forceClosePlace(place);
                if (successCallback != null) {
                    successCallback.execute();
                }
            };
            ArrayList<PlaceRequest> uncloseablePlaces = new ArrayList<PlaceRequest>();
            uncloseablePlaces.add(place);
            this.closeUnsavedProjectAssetsPopUpPresenter.show(this.getActiveWorkspace(), uncloseablePlaces, newSuccessCallback, () -> {});
        }
    }

    void closeAllPlaces() {
        this.closingLibraryPlaces = true;
        this.placeManager.closeAllPlaces();
        this.closingLibraryPlaces = false;
    }

    public WorkspaceProjectContext getWorkbenchContext() {
        return this.projectContext;
    }

    public WorkspaceProject getActiveWorkspace() {
        return (WorkspaceProject)this.projectContext.getActiveWorkspaceProject().orElseThrow(() -> new IllegalStateException("No active workspace project found"));
    }

    public OrganizationalUnit getActiveSpace() {
        return (OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("No active space found"));
    }

    public boolean isThisUserAccessingThisRepository(User user, Repository repository) {
        Space space = repository.getSpace();
        String repositoryAlias = repository.getAlias();
        Space activeSpace = this.getActiveSpace().getSpace();
        Repository activeRepository = this.getActiveWorkspace().getRepository();
        String activeRepositoryAlias = activeRepository.getAlias();
        return space.equals((Object)activeSpace) && repositoryAlias.equals(activeRepositoryAlias) && this.sessionInfo.getIdentity().equals(user);
    }

    public void init(LibraryPerspective libraryPerspective) {
        this.libraryPerspective = libraryPerspective;
    }

    public void onChange(WorkspaceProjectContextChangeEvent previous, WorkspaceProjectContextChangeEvent current) {
        if (current.getWorkspaceProject() != null && !this.isStandalone()) {
            if (Utils.hasRepositoryChanged((WorkspaceProject)previous.getWorkspaceProject(), (WorkspaceProject)current.getWorkspaceProject())) {
                this.closeAllPlacesOrNothing(this::goToProject);
            }
            if (Utils.hasModuleChanged((Module)previous.getModule(), (Module)current.getModule())) {
                this.libraryBreadcrumbs.setupForProject((WorkspaceProject)this.projectContext.getActiveWorkspaceProject().get());
            }
        }
    }

    public void onDeletedResource(@Observes ResourceDeletedEvent deleteFileEvent) {
        this.closePathPlace(deleteFileEvent.getPath());
    }

    public void onConcurrentDelete(@Observes ConcurrentDeleteAcceptedEvent concurrentDeleteAcceptedEvent) {
        this.closePathPlace((Path)concurrentDeleteAcceptedEvent.getPath());
    }

    private void closePathPlace(Path path) {
        this.placeManager.closePlace((PlaceRequest)new PathPlaceRequest(path));
    }

    private boolean isStandalone() {
        Map<String, List<String>> parameterMap = this.getParameterMap();
        if (parameterMap == null) {
            return false;
        }
        return parameterMap.containsKey("standalone");
    }

    protected Map<String, List<String>> getParameterMap() {
        return Window.Location.getParameterMap();
    }
}

