/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.util.breadcrumb;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.NewBranchEvent;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.kie.workbench.common.services.datamodel.util.SortHelper;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.ext.widgets.common.client.breadcrumbs.widget.BreadcrumbPresenter;

@Dependent
public class ProjectBranchBreadcrumb
implements BreadcrumbPresenter {
    private final View view;
    private List<Branch> branches;
    private LibraryPlaces libraryPlaces;
    public static final Comparator<Branch> BRANCH_ALPHABETICAL_ORDER_COMPARATOR = (branch1, branch2) -> SortHelper.ALPHABETICAL_ORDER_COMPARATOR.compare(branch1.getName(), branch2.getName());

    @Inject
    public ProjectBranchBreadcrumb(View view, LibraryPlaces libraryPlaces) {
        this.view = view;
        this.libraryPlaces = libraryPlaces;
    }

    public ProjectBranchBreadcrumb setup(Collection<Branch> branches) {
        this.branches = branches.stream().sorted(BRANCH_ALPHABETICAL_ORDER_COMPARATOR).collect(Collectors.toList());
        this.view.init(this);
        return this;
    }

    public void activate() {
    }

    public void deactivate() {
    }

    public Branch getCurrentBranch() {
        return this.libraryPlaces.getActiveWorkspace().getBranch();
    }

    public List<Branch> getBranches() {
        return this.branches;
    }

    public UberElemental<? extends BreadcrumbPresenter> getView() {
        return this.view;
    }

    public void onBranchChanged(Branch branch) {
        this.libraryPlaces.goToProject(this.libraryPlaces.getActiveWorkspace(), branch);
    }

    public void newBranchEvent(@Observes NewBranchEvent newBranchEvent) {
        Repository repository;
        User user = newBranchEvent.getUser();
        if (this.libraryPlaces.isThisUserAccessingThisRepository(user, repository = newBranchEvent.getRepository())) {
            this.setup(repository.getBranches());
            this.libraryPlaces.goToProject(this.libraryPlaces.getActiveWorkspace(), (Branch)repository.getBranch(newBranchEvent.getNewBranchName()).get());
        }
    }

    public static interface View
    extends UberElemental<ProjectBranchBreadcrumb> {
    }
}

