/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.client.security.OrganizationalUnitController;
import org.guvnor.structure.events.AfterEditOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.repositories.RepositoryRemovedEvent;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.client.perspective.LibraryPerspective;
import org.kie.workbench.common.screens.library.client.screens.EmptyLibraryScreen;
import org.kie.workbench.common.screens.library.client.screens.OrgUnitsMetricsScreen;
import org.kie.workbench.common.screens.library.client.screens.PopulatedLibraryScreen;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.edit.EditContributorsPopUpPresenter;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.tab.ContributorsListPresenter;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.delete.DeleteOrganizationalUnitPopUpPresenter;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.spaces.Space;

@WorkbenchScreen(identifier="LibraryScreen", owningPerspective=LibraryPerspective.class)
public class LibraryScreen {
    protected List<WorkspaceProject> projects;
    private View view;
    private ManagedInstance<EditContributorsPopUpPresenter> editContributorsPopUpPresenters;
    private ManagedInstance<DeleteOrganizationalUnitPopUpPresenter> deleteOrganizationalUnitPopUpPresenters;
    private OrganizationalUnitController organizationalUnitController;
    private WorkspaceProjectContext projectContext;
    private ProjectController projectController;
    private EmptyLibraryScreen emptyLibraryScreen;
    private PopulatedLibraryScreen populatedLibraryScreen;
    private OrgUnitsMetricsScreen orgUnitsMetricsScreen;
    private ContributorsListPresenter contributorsListPresenter;
    private Caller<LibraryService> libraryService;
    private LibraryPlaces libraryPlaces;

    @Inject
    public LibraryScreen(View view, ManagedInstance<DeleteOrganizationalUnitPopUpPresenter> deleteOrganizationalUnitPopUpPresenters, ManagedInstance<EditContributorsPopUpPresenter> editContributorsPopUpPresenters, WorkspaceProjectContext projectContext, OrganizationalUnitController organizationalUnitController, ProjectController projectController, EmptyLibraryScreen emptyLibraryScreen, PopulatedLibraryScreen populatedLibraryScreen, OrgUnitsMetricsScreen orgUnitsMetricsScreen, ContributorsListPresenter contributorsListPresenter, Caller<LibraryService> libraryService, LibraryPlaces libraryPlaces) {
        this.view = view;
        this.deleteOrganizationalUnitPopUpPresenters = deleteOrganizationalUnitPopUpPresenters;
        this.editContributorsPopUpPresenters = editContributorsPopUpPresenters;
        this.projectContext = projectContext;
        this.organizationalUnitController = organizationalUnitController;
        this.projectController = projectController;
        this.emptyLibraryScreen = emptyLibraryScreen;
        this.populatedLibraryScreen = populatedLibraryScreen;
        this.orgUnitsMetricsScreen = orgUnitsMetricsScreen;
        this.contributorsListPresenter = contributorsListPresenter;
        this.libraryService = libraryService;
        this.libraryPlaces = libraryPlaces;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.view.setTitle(((OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot initialize library screen without an active organizational unit."))).getName());
        this.showProjects();
        this.view.setContributorsCount(this.contributorsListPresenter.getContributorsCount());
    }

    public void trySamples() {
        if (this.userCanCreateProjects()) {
            this.libraryPlaces.closeAllPlacesOrNothing(() -> {
                this.libraryPlaces.goToLibrary();
                this.libraryPlaces.goToTrySamples();
            });
        }
    }

    public void importProject() {
        if (this.userCanCreateProjects()) {
            this.libraryPlaces.closeAllPlacesOrNothing(() -> {
                this.libraryPlaces.goToLibrary();
                this.libraryPlaces.goToImportRepositoryPopUp();
            });
        }
    }

    public void editContributors() {
        if (this.userCanUpdateOrganizationalUnit()) {
            EditContributorsPopUpPresenter editContributorsPopUpPresenter = (EditContributorsPopUpPresenter)this.editContributorsPopUpPresenters.get();
            editContributorsPopUpPresenter.show((OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().get());
        }
    }

    public void delete() {
        if (this.userCanDeleteOrganizationalUnit()) {
            DeleteOrganizationalUnitPopUpPresenter deleteOrganizationalUnitPopUpPresenter = (DeleteOrganizationalUnitPopUpPresenter)this.deleteOrganizationalUnitPopUpPresenters.get();
            deleteOrganizationalUnitPopUpPresenter.show((OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot delete organizational unit if none is active.")));
        }
    }

    public void showProjects() {
        boolean cachedHasProjects;
        OrganizationalUnit activeOU = (OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot try to query library projects without an active organizational unit."));
        boolean bl = cachedHasProjects = !activeOU.getRepositories().isEmpty();
        if (cachedHasProjects) {
            this.showPopulatedLibraryScreen();
        } else {
            this.showEmptyLibraryScreen();
        }
        ((LibraryService)this.libraryService.call(hasProjects -> {
            if (hasProjects.booleanValue() && !cachedHasProjects) {
                this.showPopulatedLibraryScreen();
            } else if (!hasProjects.booleanValue() && cachedHasProjects) {
                this.showEmptyLibraryScreen();
            }
        })).hasProjects(activeOU);
    }

    private void showEmptyLibraryScreen() {
        this.view.updateContent(this.emptyLibraryScreen.getView().getElement());
        this.view.setProjectsCount(0);
    }

    private void showPopulatedLibraryScreen() {
        this.view.updateContent(this.populatedLibraryScreen.getView().getElement());
        this.view.setProjectsCount(this.populatedLibraryScreen.getProjectsCount());
    }

    public void showContributors() {
        this.view.updateContent(this.contributorsListPresenter.getView().getElement());
    }

    public void showMetrics() {
        this.orgUnitsMetricsScreen.refresh();
        this.view.updateContent(this.orgUnitsMetricsScreen.getView().getElement());
    }

    public boolean userCanCreateProjects() {
        return this.projectController.canCreateProjects();
    }

    public boolean userCanUpdateOrganizationalUnit() {
        return this.organizationalUnitController.canUpdateOrgUnit((OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot try to update an organizational unit when none is active.")));
    }

    public boolean userCanDeleteOrganizationalUnit() {
        return this.organizationalUnitController.canDeleteOrgUnit((OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot try to delete an organizational unit when none is active.")));
    }

    public void organizationalUnitEdited(@Observes AfterEditOrganizationalUnitEvent afterEditOrganizationalUnitEvent) {
        this.view.setContributorsCount(afterEditOrganizationalUnitEvent.getEditedOrganizationalUnit().getContributors().size());
    }

    public void onNewProject(@Observes NewProjectEvent e) {
        this.projectContext.getActiveOrganizationalUnit().ifPresent(p -> {
            if (this.eventOnCurrentSpace((OrganizationalUnit)p, e.getWorkspaceProject().getSpace())) {
                this.showProjects();
            }
        });
    }

    public void onRepositoryRemovedEvent(@Observes RepositoryRemovedEvent e) {
        this.projectContext.getActiveOrganizationalUnit().ifPresent(p -> {
            if (this.eventOnCurrentSpace((OrganizationalUnit)p, e.getRepository().getSpace())) {
                this.showProjects();
            }
        });
    }

    boolean eventOnCurrentSpace(OrganizationalUnit p, Space space) {
        return p.getSpace().getName().equalsIgnoreCase(space.getName());
    }

    @OnClose
    public void onClose() {
        this.orgUnitsMetricsScreen.onClose();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return "Library Screen";
    }

    @WorkbenchPartView
    public View getView() {
        return this.view;
    }

    public static interface View
    extends UberElement<LibraryScreen> {
        public void setTitle(String var1);

        public void setProjectsCount(int var1);

        public void setContributorsCount(int var1);

        public void updateContent(HTMLElement var1);
    }
}

