/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerCoordinator;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.kie.workbench.common.screens.library.client.util.OrgUnitsMetricsFactory;
import org.uberfire.client.mvp.UberElement;

public class OrgUnitsMetricsScreen {
    View view;
    TranslationService translationService;
    OrgUnitsMetricsFactory metricsFactory;
    DisplayerCoordinator displayerCoordinator;
    private WorkspaceProjectContext projectContext;
    LibraryPlaces libraryPlaces;
    OrganizationalUnit organizationalUnit;
    Displayer commitsOverTimeDisplayer;
    Displayer commitsPerAuthorDisplayer;
    Displayer commitsPerProjectDisplayer;
    Displayer commitsByYearDisplayer;
    Displayer commitsByQuarterDisplayer;
    Displayer commitsByDayOfWeekDisplayer;
    Displayer topAuthorSelectorDisplayer;
    Displayer projectSelectorDisplayer;
    Displayer dateSelectorDisplayer;
    Displayer allCommitsDisplayer;

    @Inject
    public OrgUnitsMetricsScreen(View view, TranslationService translationService, OrgUnitsMetricsFactory metricsFactory, DisplayerCoordinator displayerCoordinator, WorkspaceProjectContext projectContext, LibraryPlaces libraryPlaces) {
        this.view = view;
        this.translationService = translationService;
        this.metricsFactory = metricsFactory;
        this.displayerCoordinator = displayerCoordinator;
        this.projectContext = projectContext;
        this.libraryPlaces = libraryPlaces;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.organizationalUnit = (OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot initialize OrgUnitsMetricsScreen without an active organizational unit."));
        this.commitsOverTimeDisplayer = this.metricsFactory.lookupCommitsOverTimeDisplayer(this.organizationalUnit);
        this.commitsPerAuthorDisplayer = this.metricsFactory.lookupCommitsPerAuthorDisplayer(this.organizationalUnit);
        this.commitsPerProjectDisplayer = this.metricsFactory.lookupCommitsPerProjectDisplayer(this.organizationalUnit);
        this.commitsByYearDisplayer = this.metricsFactory.lookupCommitsByYearDisplayer(this.organizationalUnit);
        this.commitsByQuarterDisplayer = this.metricsFactory.lookupCommitsByQuarterDisplayer(this.organizationalUnit);
        this.commitsByDayOfWeekDisplayer = this.metricsFactory.lookupCommitsByDayOfWeekDisplayer(this.organizationalUnit);
        this.allCommitsDisplayer = this.metricsFactory.lookupAllCommitsDisplayer(this.organizationalUnit);
        this.projectSelectorDisplayer = this.metricsFactory.lookupProjectSelectorDisplayer(this.organizationalUnit);
        this.topAuthorSelectorDisplayer = this.metricsFactory.lookupTopContributorSelectorDisplayer(this.organizationalUnit);
        this.dateSelectorDisplayer = this.metricsFactory.lookupDateSelectorDisplayer(this.organizationalUnit);
        this.view.clear();
        this.view.setCommitsPerAuthorDisplayer(this.commitsPerAuthorDisplayer);
        this.view.setCommitsPerProjectDisplayer(this.commitsPerProjectDisplayer);
        this.view.setCommitsOverTimeDisplayer(this.commitsOverTimeDisplayer);
        this.view.setCommitsByYearDisplayer(this.commitsByYearDisplayer);
        this.view.setCommitsByQuarterDisplayer(this.commitsByQuarterDisplayer);
        this.view.setCommitsByDayOfWeekDisplayer(this.commitsByDayOfWeekDisplayer);
        this.view.setAllCommitsDisplayer(this.allCommitsDisplayer);
        this.view.setProjectSelectorDisplayer(this.projectSelectorDisplayer);
        this.view.setTopContribSelectorDisplayer(this.topAuthorSelectorDisplayer);
        this.view.setDateSelectorDisplayer(this.dateSelectorDisplayer);
        this.displayerCoordinator.addDisplayer(this.commitsPerAuthorDisplayer);
        this.displayerCoordinator.addDisplayer(this.commitsPerProjectDisplayer);
        this.displayerCoordinator.addDisplayer(this.commitsOverTimeDisplayer);
        this.displayerCoordinator.addDisplayer(this.commitsByYearDisplayer);
        this.displayerCoordinator.addDisplayer(this.commitsByQuarterDisplayer);
        this.displayerCoordinator.addDisplayer(this.commitsByDayOfWeekDisplayer);
        this.displayerCoordinator.addDisplayer(this.allCommitsDisplayer);
        this.displayerCoordinator.addDisplayer(this.topAuthorSelectorDisplayer);
        this.displayerCoordinator.addDisplayer(this.projectSelectorDisplayer);
        this.displayerCoordinator.addDisplayer(this.dateSelectorDisplayer);
        this.displayerCoordinator.drawAll();
    }

    public void refresh() {
        this.displayerCoordinator.redrawAll();
    }

    public void onClose() {
        this.displayerCoordinator.closeAll();
        this.view.clear();
    }

    public Displayer getCommitsOverTimeDisplayer() {
        return this.commitsOverTimeDisplayer;
    }

    public Displayer getCommitsPerProjectDisplayer() {
        return this.commitsPerProjectDisplayer;
    }

    public Displayer getCommitsPerAuthorDisplayer() {
        return this.commitsPerAuthorDisplayer;
    }

    public Displayer getCommitsByYearDisplayer() {
        return this.commitsByYearDisplayer;
    }

    public Displayer getCommitsByQuarterDisplayer() {
        return this.commitsByQuarterDisplayer;
    }

    public Displayer getCommitsByDayOfWeekDisplayer() {
        return this.commitsByDayOfWeekDisplayer;
    }

    public Displayer getProjectSelectorDisplayer() {
        return this.projectSelectorDisplayer;
    }

    public Displayer getTopAuthorSelectorDisplayer() {
        return this.topAuthorSelectorDisplayer;
    }

    public Displayer getDateSelectorDisplayer() {
        return this.dateSelectorDisplayer;
    }

    public Displayer getAllCommitsDisplayer() {
        return this.allCommitsDisplayer;
    }

    public View getView() {
        return this.view;
    }

    public static interface View
    extends UberElement<OrgUnitsMetricsScreen> {
        public void setCommitsOverTimeDisplayer(Displayer var1);

        public void setCommitsPerAuthorDisplayer(Displayer var1);

        public void setCommitsPerProjectDisplayer(Displayer var1);

        public void setCommitsByYearDisplayer(Displayer var1);

        public void setCommitsByQuarterDisplayer(Displayer var1);

        public void setCommitsByDayOfWeekDisplayer(Displayer var1);

        public void setTopContribSelectorDisplayer(Displayer var1);

        public void setProjectSelectorDisplayer(Displayer var1);

        public void setDateSelectorDisplayer(Displayer var1);

        public void setAllCommitsDisplayer(Displayer var1);

        public void clear();
    }
}

