/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.importrepository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.event.Event;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.context.WorkspaceProjectContextChangeEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.screens.examples.model.ImportProject;
import org.kie.workbench.common.screens.library.client.screens.importrepository.ImportProjectsSetupEvent;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.kie.workbench.common.screens.library.client.widgets.example.ExampleProjectWidget;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;

public abstract class ImportPresenter {
    protected final View view;
    protected final LibraryPlaces libraryPlaces;
    protected final ManagedInstance<ExampleProjectWidget> tileWidgets;
    protected final WorkspaceProjectContext projectContext;
    protected final Event<NotificationEvent> notificationEvent;
    protected final Event<WorkspaceProjectContextChangeEvent> projectContextChangeEvent;
    protected final Elemental2DomUtil elemental2DomUtil;
    private String title;
    protected Map<ImportProject, ExampleProjectWidget> projectWidgetsByName;

    public ImportPresenter(View view, LibraryPlaces libraryPlaces, ManagedInstance<ExampleProjectWidget> tileWidgets, WorkspaceProjectContext projectContext, Event<NotificationEvent> notificationEvent, Event<WorkspaceProjectContextChangeEvent> projectContextChangeEvent, Elemental2DomUtil elemental2DomUtil, String title) {
        this.view = view;
        this.libraryPlaces = libraryPlaces;
        this.tileWidgets = tileWidgets;
        this.projectContext = projectContext;
        this.notificationEvent = notificationEvent;
        this.projectContextChangeEvent = projectContextChangeEvent;
        this.elemental2DomUtil = elemental2DomUtil;
        this.title = title;
    }

    public void onStartup(PlaceRequest placeRequest) {
        this.view.init(this);
        String title = placeRequest.getParameter("title", this.title);
        this.view.setTitle(title);
        this.loadProjects(placeRequest, (RemoteCallback<Set<ImportProject>>)((RemoteCallback)projects -> {
            this.view.hideBusyIndicator();
            this.setupProjects((Set<ImportProject>)projects);
        }));
    }

    protected abstract void loadProjects(PlaceRequest var1, RemoteCallback<Set<ImportProject>> var2);

    protected abstract void importProjects(List<ImportProject> var1, RemoteCallback<WorkspaceProjectContextChangeEvent> var2, ErrorCallback<Message> var3);

    protected DefaultErrorCallback loadingErrorCallback() {
        return new DefaultErrorCallback(){

            public boolean error(Message message, Throwable throwable) {
                ImportPresenter.this.view.hideBusyIndicator();
                ImportPresenter.this.showNoProjects();
                return super.error(message, throwable);
            }
        };
    }

    public void setupEvent(ImportProjectsSetupEvent event) {
        this.setupProjects(event.getProjects());
    }

    private void setupProjects(Set<ImportProject> projects) {
        if (projects == null || projects.isEmpty()) {
            this.showNoProjects();
            return;
        }
        this.projectWidgetsByName = new HashMap<ImportProject, ExampleProjectWidget>();
        projects.forEach(project -> {
            ExampleProjectWidget projectWidget = this.createProjectWidget((ImportProject)project);
            this.projectWidgetsByName.put((ImportProject)project, projectWidget);
        });
        this.updateView(this.projectWidgetsByName.values());
    }

    private ExampleProjectWidget createProjectWidget(ImportProject project) {
        ExampleProjectWidget tileWidget = (ExampleProjectWidget)this.tileWidgets.get();
        tileWidget.init(project);
        return tileWidget;
    }

    private void showNoProjects() {
        this.notificationEvent.fire((Object)new NotificationEvent(this.view.getNoProjectsToImportMessage(), NotificationEvent.NotificationType.ERROR));
        this.libraryPlaces.goToLibrary();
    }

    private void updateView(Collection<ExampleProjectWidget> projectWidgets) {
        this.view.clearProjects();
        List<ExampleProjectWidget> sortedProjectWidgets = this.sortProjectWidgets(projectWidgets);
        sortedProjectWidgets.stream().forEach(projectWidget -> this.view.addProject(this.elemental2DomUtil.asHTMLElement(projectWidget.getView().getElement())));
    }

    private List<ExampleProjectWidget> sortProjectWidgets(Collection<ExampleProjectWidget> projectWidgets) {
        ArrayList<ExampleProjectWidget> sortedProjectWidgets = new ArrayList<ExampleProjectWidget>(projectWidgets);
        Collections.sort(sortedProjectWidgets, Comparator.comparing(o -> o.getName().toUpperCase()));
        return sortedProjectWidgets;
    }

    private Command selectCommand(ExampleProjectWidget tileWidget) {
        return () -> tileWidget.setSelected(!tileWidget.isSelected());
    }

    public List<ExampleProjectWidget> filterProjects(String filter) {
        List<ExampleProjectWidget> filteredProjectWidgets = this.projectWidgetsByName.entrySet().stream().filter(p -> ((ImportProject)p.getKey()).getName().toUpperCase().contains(filter.toUpperCase())).map(Map.Entry::getValue).collect(Collectors.toList());
        this.updateView(filteredProjectWidgets);
        return filteredProjectWidgets;
    }

    public void ok() {
        List<ImportProject> projects = this.projectWidgetsByName.entrySet().stream().filter(p -> ((ExampleProjectWidget)p.getValue()).isSelected()).map(Map.Entry::getKey).collect(Collectors.toList());
        if (projects.isEmpty()) {
            this.notificationEvent.fire((Object)new NotificationEvent(this.view.getNoProjectsSelectedMessage(), NotificationEvent.NotificationType.ERROR));
            return;
        }
        this.view.showBusyIndicator(this.view.getImportingMessage());
        this.importProjects(projects, (RemoteCallback<WorkspaceProjectContextChangeEvent>)((RemoteCallback)event -> {
            this.view.hideBusyIndicator();
            this.notificationEvent.fire((Object)new NotificationEvent(this.view.getImportProjectsSuccessMessage(), NotificationEvent.NotificationType.SUCCESS));
            this.projectContextChangeEvent.fire(event);
            if (event.getWorkspaceProject() == null) {
                this.libraryPlaces.goToLibrary();
            }
        }), (ErrorCallback<Message>)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view));
    }

    public void cancel() {
        this.libraryPlaces.goToLibrary();
    }

    public View getView() {
        return this.view;
    }

    protected OrganizationalUnit activeOrganizationalUnit() {
        return (OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot setup examples without an active organizational unit."));
    }

    public static interface View
    extends UberElement<ImportPresenter>,
    HasBusyIndicator {
        public void setTitle(String var1);

        public void clearProjects();

        public void addProject(HTMLElement var1);

        public String getNumberOfAssetsMessage(int var1);

        public String getNoProjectsToImportMessage();

        public String getImportingMessage();

        public String getLoadingMessage();

        public String getNoProjectsSelectedMessage();

        public String getImportProjectsSuccessMessage();

        public String getTitle();
    }
}

