/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.tab;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.structure.client.security.OrganizationalUnitController;
import org.guvnor.structure.events.AfterEditOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.edit.EditContributorsPopUpPresenter;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.tab.ContributorsListItemPresenter;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.client.mvp.UberElement;

public class ContributorsListPresenter {
    private View view;
    private LibraryPlaces libraryPlaces;
    private ManagedInstance<ContributorsListItemPresenter> contributorsListItemPresenters;
    private ManagedInstance<EditContributorsPopUpPresenter> editContributorsPopUpPresenters;
    private WorkspaceProjectContext projectContext;
    private OrganizationalUnitController organizationalUnitController;
    List<String> contributors;

    @Inject
    public ContributorsListPresenter(View view, LibraryPlaces libraryPlaces, ManagedInstance<ContributorsListItemPresenter> contributorsListItemPresenters, ManagedInstance<EditContributorsPopUpPresenter> editContributorsPopUpPresenters, WorkspaceProjectContext projectContext, OrganizationalUnitController organizationalUnitController) {
        this.view = view;
        this.libraryPlaces = libraryPlaces;
        this.contributorsListItemPresenters = contributorsListItemPresenters;
        this.editContributorsPopUpPresenters = editContributorsPopUpPresenters;
        this.projectContext = projectContext;
        this.organizationalUnitController = organizationalUnitController;
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
        this.updateContributors((OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot setup contributors list without an active organizational unit.")));
    }

    public void updateContributors(OrganizationalUnit organizationalUnit) {
        this.contributors = new ArrayList<String>(organizationalUnit.getContributors());
        this.contributors.sort((c1, c2) -> c1.toUpperCase().compareTo(c2.toUpperCase()));
        this.updateView(this.contributors);
    }

    public void filterContributors(String filter) {
        List<String> filteredContributors = this.contributors.stream().filter(c -> c.toUpperCase().contains(filter.toUpperCase())).collect(Collectors.toList());
        this.updateView(filteredContributors);
    }

    private void updateView(List<String> contributors) {
        OrganizationalUnit organizationalUnit = (OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot update contributors list without an active organizational unit."));
        this.view.clearContributors();
        contributors.stream().forEach(contributor -> {
            String role = contributor.equals(organizationalUnit.getOwner()) ? this.view.getOwnerRoleLabel() : this.view.getContributorRoleLabel();
            ContributorsListItemPresenter contributorsListItemPresenter = (ContributorsListItemPresenter)this.contributorsListItemPresenters.get();
            contributorsListItemPresenter.setup((String)contributor, role);
            this.view.addContributor(contributorsListItemPresenter.getView().getElement());
        });
    }

    public void edit() {
        if (this.userCanUpdateOrganizationalUnit()) {
            EditContributorsPopUpPresenter editContributorsPopUpPresenter = (EditContributorsPopUpPresenter)this.editContributorsPopUpPresenters.get();
            editContributorsPopUpPresenter.show((OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().get());
        }
    }

    public void organizationalUnitEdited(@Observes AfterEditOrganizationalUnitEvent afterEditOrganizationalUnitEvent) {
        this.view.clearFilterText();
        this.updateContributors(afterEditOrganizationalUnitEvent.getEditedOrganizationalUnit());
    }

    public boolean userCanUpdateOrganizationalUnit() {
        return this.organizationalUnitController.canUpdateOrgUnit((OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot update organizational unit when none is active.")));
    }

    public int getContributorsCount() {
        return ((OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot get contributors count when no organizational unit is active."))).getContributors().size();
    }

    public View getView() {
        return this.view;
    }

    public static interface View
    extends UberElement<ContributorsListPresenter> {
        public void clearContributors();

        public void addContributor(HTMLElement var1);

        public void clearFilterText();

        public String getOwnerRoleLabel();

        public String getContributorRoleLabel();
    }
}

