/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.tab;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.tab.ContributorsListPresenter;

@Templated
public class ContributorsListView
implements ContributorsListPresenter.View,
IsElement {
    private ContributorsListPresenter presenter;
    @Inject
    private TranslationService ts;
    @Inject
    @DataField(value="contributors-list")
    Div contributorsList;
    @Inject
    @DataField(value="filter-text")
    Input filterText;
    @Inject
    @DataField(value="edit")
    Button edit;

    public void init(ContributorsListPresenter presenter) {
        this.presenter = presenter;
        this.filterText.setAttribute("placeholder", this.ts.getTranslation("Search"));
        this.edit.setHidden(!presenter.userCanUpdateOrganizationalUnit());
    }

    @Override
    public void clearContributors() {
        this.contributorsList.setTextContent("");
    }

    @Override
    public void addContributor(HTMLElement contributor) {
        this.contributorsList.appendChild((Node)contributor);
    }

    @Override
    public void clearFilterText() {
        this.filterText.setValue("");
    }

    @Override
    public String getOwnerRoleLabel() {
        return this.ts.format("Owner", new Object[0]);
    }

    @Override
    public String getContributorRoleLabel() {
        return this.ts.format("Contributor", new Object[0]);
    }

    @EventHandler(value={"filter-text"})
    public void filterTextChange(KeyUpEvent event) {
        this.presenter.filterContributors(this.filterText.getValue());
    }

    @EventHandler(value={"edit"})
    public void edit(ClickEvent event) {
        this.presenter.edit();
    }
}

