/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.organizationalunit.delete;

import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.structure.client.security.OrganizationalUnitController;
import org.guvnor.structure.events.AfterDeleteOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.workbench.events.NotificationEvent;

public class DeleteOrganizationalUnitPopUpPresenter {
    private View view;
    private Caller<OrganizationalUnitService> organizationalUnitService;
    private OrganizationalUnitController organizationalUnitController;
    private Event<AfterDeleteOrganizationalUnitEvent> afterDeleteOrganizationalUnitEvent;
    private Event<NotificationEvent> notificationEvent;
    private LibraryPlaces libraryPlaces;
    OrganizationalUnit organizationalUnit;

    @Inject
    public DeleteOrganizationalUnitPopUpPresenter(View view, Caller<OrganizationalUnitService> organizationalUnitService, OrganizationalUnitController organizationalUnitController, Event<AfterDeleteOrganizationalUnitEvent> afterDeleteOrganizationalUnitEvent, Event<NotificationEvent> notificationEvent, LibraryPlaces libraryPlaces) {
        this.view = view;
        this.organizationalUnitService = organizationalUnitService;
        this.organizationalUnitController = organizationalUnitController;
        this.afterDeleteOrganizationalUnitEvent = afterDeleteOrganizationalUnitEvent;
        this.notificationEvent = notificationEvent;
        this.libraryPlaces = libraryPlaces;
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
    }

    public void show(OrganizationalUnit organizationalUnit) {
        if (this.organizationalUnitController.canDeleteOrgUnit(organizationalUnit)) {
            this.organizationalUnit = organizationalUnit;
            this.view.show(organizationalUnit.getName());
        }
    }

    public void delete() {
        String confirmedName = this.view.getConfirmedName();
        if (!this.organizationalUnit.getName().equals(confirmedName)) {
            this.view.showError(this.view.getWrongConfirmedNameValidationMessage());
            return;
        }
        this.view.showBusyIndicator(this.view.getDeletingMessage());
        ((OrganizationalUnitService)this.organizationalUnitService.call(v -> {
            this.afterDeleteOrganizationalUnitEvent.fire((Object)new AfterDeleteOrganizationalUnitEvent(this.organizationalUnit));
            this.view.hideBusyIndicator();
            this.notificationEvent.fire((Object)new NotificationEvent(this.view.getDeleteSuccessMessage(), NotificationEvent.NotificationType.SUCCESS));
            this.view.hide();
            this.libraryPlaces.goToOrganizationalUnits();
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).removeOrganizationalUnit(this.organizationalUnit.getName());
    }

    public void cancel() {
        this.view.hide();
    }

    public static interface View
    extends UberElement<DeleteOrganizationalUnitPopUpPresenter>,
    HasBusyIndicator {
        public String getConfirmedName();

        public void show(String var1);

        public void showError(String var1);

        public void hide();

        public String getWrongConfirmedNameValidationMessage();

        public String getDeletingMessage();

        public String getDeleteSuccessMessage();
    }
}

