/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.project;

import com.google.gwt.core.client.GWT;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.client.repositories.ConflictingRepositoriesPopup;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.project.service.GAVAlreadyExistsException;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.screens.library.api.LibraryInfo;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.api.preferences.LibraryPreferences;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.kie.workbench.common.screens.projecteditor.client.util.KiePOMDefaultOptions;
import org.kie.workbench.common.screens.projecteditor.client.wizard.POMBuilder;
import org.kie.workbench.common.services.shared.validation.ValidationService;
import org.kie.workbench.common.widgets.client.callbacks.CommandWithThrowableDrivenErrorCallback;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.NotificationEvent;

public class AddProjectPopUpPresenter {
    private Caller<LibraryService> libraryService;
    private BusyIndicatorView busyIndicatorView;
    private Event<NotificationEvent> notificationEvent;
    private LibraryPlaces libraryPlaces;
    private WorkspaceProjectContext projectContext;
    private View view;
    private SessionInfo sessionInfo;
    private Event<NewProjectEvent> newProjectEvent;
    private LibraryPreferences libraryPreferences;
    private ConflictingRepositoriesPopup conflictingRepositoriesPopup;
    private Caller<ValidationService> validationService;
    LibraryInfo libraryInfo;
    ParameterizedCommand<WorkspaceProject> successCallback;

    @Inject
    public AddProjectPopUpPresenter(Caller<LibraryService> libraryService, BusyIndicatorView busyIndicatorView, Event<NotificationEvent> notificationEvent, LibraryPlaces libraryPlaces, WorkspaceProjectContext projectContext, View view, SessionInfo sessionInfo, Event<NewProjectEvent> newProjectEvent, LibraryPreferences libraryPreferences, ConflictingRepositoriesPopup conflictingRepositoriesPopup, Caller<ValidationService> validationService) {
        this.libraryService = libraryService;
        this.busyIndicatorView = busyIndicatorView;
        this.notificationEvent = notificationEvent;
        this.libraryPlaces = libraryPlaces;
        this.projectContext = projectContext;
        this.view = view;
        this.sessionInfo = sessionInfo;
        this.newProjectEvent = newProjectEvent;
        this.libraryPreferences = libraryPreferences;
        this.conflictingRepositoriesPopup = conflictingRepositoriesPopup;
        this.validationService = validationService;
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
        ((LibraryService)this.libraryService.call((RemoteCallback)new RemoteCallback<LibraryInfo>(){

            public void callback(LibraryInfo libraryInfo) {
                AddProjectPopUpPresenter.this.libraryInfo = libraryInfo;
            }
        })).getLibraryInfo((OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot get library info without an active organizational unit.")));
    }

    public void setSuccessCallback(ParameterizedCommand<WorkspaceProject> successCallback) {
        this.successCallback = successCallback;
    }

    public void show() {
        this.libraryPreferences.load(loadedLibraryPreferences -> {
            this.view.setDescription(loadedLibraryPreferences.getProjectPreferences().getDescription());
            this.view.setVersion(loadedLibraryPreferences.getProjectPreferences().getVersion());
            this.view.setGroupId(this.projectContext.getActiveOrganizationalUnit().isPresent() ? ((OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().get()).getDefaultGroupId() : loadedLibraryPreferences.getOrganizationalUnitPreferences().getGroupId());
            this.view.show();
        }, error -> {});
    }

    public void add() {
        this.createProject(DeploymentMode.VALIDATED);
    }

    private void createProject(DeploymentMode mode) {
        this.beginProjectCreation();
        String name = this.view.getName();
        String description = this.view.getDescription();
        String groupId = this.view.getGroupId();
        String artifactId = this.view.getArtifactId();
        String version = this.view.getVersion();
        this.validateFields(name, groupId, artifactId, version, () -> {
            ParameterizedCommand successCallback = project -> {
                this.endProjectCreation();
                this.getSuccessCallback().execute(project);
            };
            ErrorCallback<?> errorCallback = this.getErrorCallback();
            POM pom = this.setDefaultPOM(groupId, artifactId, version, name, description);
            ((LibraryService)this.libraryService.call(project -> successCallback.execute(project), errorCallback)).createProject((OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot create new project without an active organizational unit.")), pom, mode);
        });
    }

    private void beginProjectCreation() {
        this.view.setAddButtonEnabled(false);
        this.view.showBusyIndicator(this.view.getSavingMessage());
    }

    private void endProjectCreation() {
        this.view.setAddButtonEnabled(true);
        this.view.hideBusyIndicator();
    }

    private void validateFields(String name, String groupId, String artifactId, String version, Command successCallback) {
        Command validateVersion = () -> this.validateVersion(version, successCallback);
        Command validateArtifactId = () -> this.validateArtifactId(artifactId, validateVersion);
        Command validateGroupId = () -> this.validateGroupId(groupId, validateArtifactId);
        this.validateName(name, this.view.isAdvancedOptionsSelected() ? validateGroupId : successCallback);
    }

    private void validateName(String name, Command successCallback) {
        if (name == null || name.trim().isEmpty()) {
            this.endProjectCreation();
            this.view.showError(this.view.getEmptyNameMessage());
            return;
        }
        ((ValidationService)this.validationService.call(isValid -> {
            if (Boolean.TRUE.equals(isValid)) {
                if (successCallback != null) {
                    successCallback.execute();
                }
            } else {
                this.endProjectCreation();
                this.view.showError(this.view.getInvalidNameMessage());
            }
        })).isProjectNameValid(name);
    }

    private void validateGroupId(String groupId, Command successCallback) {
        if (groupId == null || groupId.trim().isEmpty()) {
            this.endProjectCreation();
            this.view.showError(this.view.getEmptyGroupIdMessage());
            return;
        }
        ((ValidationService)this.validationService.call(isValid -> {
            if (Boolean.TRUE.equals(isValid)) {
                if (successCallback != null) {
                    successCallback.execute();
                }
            } else {
                this.endProjectCreation();
                this.view.showError(this.view.getInvalidGroupIdMessage());
            }
        })).validateGroupId(groupId);
    }

    private void validateArtifactId(String artifactId, Command successCallback) {
        if (artifactId == null || artifactId.trim().isEmpty()) {
            this.endProjectCreation();
            this.view.showError(this.view.getEmptyArtifactIdMessage());
            return;
        }
        ((ValidationService)this.validationService.call(isValid -> {
            if (Boolean.TRUE.equals(isValid)) {
                if (successCallback != null) {
                    successCallback.execute();
                }
            } else {
                this.endProjectCreation();
                this.view.showError(this.view.getInvalidArtifactIdMessage());
            }
        })).validateArtifactId(artifactId);
    }

    private void validateVersion(String version, Command successCallback) {
        if (version == null || version.trim().isEmpty()) {
            this.endProjectCreation();
            this.view.showError(this.view.getEmptyVersionMessage());
            return;
        }
        ((ValidationService)this.validationService.call(isValid -> {
            if (Boolean.TRUE.equals(isValid)) {
                if (successCallback != null) {
                    successCallback.execute();
                }
            } else {
                this.endProjectCreation();
                this.view.showError(this.view.getInvalidVersionMessage());
            }
        })).validateGAVVersion(version);
    }

    public ParameterizedCommand<WorkspaceProject> getSuccessCallback() {
        if (this.successCallback != null) {
            return this.successCallback;
        }
        return this.getProjectCreationSuccessCallback();
    }

    public ParameterizedCommand<WorkspaceProject> getProjectCreationSuccessCallback() {
        return project -> {
            this.newProjectEvent.fire((Object)new NewProjectEvent(project));
            this.view.hide();
            this.notifySuccess();
            this.libraryPlaces.goToProject((WorkspaceProject)project);
        };
    }

    private ErrorCallback<?> getErrorCallback() {
        HashMap<Class<? extends Throwable>, CommandWithThrowableDrivenErrorCallback.CommandWithThrowable> errors = new HashMap<Class<? extends Throwable>, CommandWithThrowableDrivenErrorCallback.CommandWithThrowable>(){
            {
                this.put(GAVAlreadyExistsException.class, parameter -> {
                    GAVAlreadyExistsException exception = (GAVAlreadyExistsException)parameter;
                    AddProjectPopUpPresenter.this.endProjectCreation();
                    AddProjectPopUpPresenter.this.conflictingRepositoriesPopup.setContent(exception.getGAV(), ((GAVAlreadyExistsException)parameter).getRepositories(), () -> {
                        AddProjectPopUpPresenter.this.conflictingRepositoriesPopup.hide();
                        AddProjectPopUpPresenter.this.createProject(DeploymentMode.FORCED);
                    });
                    AddProjectPopUpPresenter.this.conflictingRepositoriesPopup.show();
                });
                this.put(FileAlreadyExistsException.class, parameter -> {
                    AddProjectPopUpPresenter.this.endProjectCreation();
                    AddProjectPopUpPresenter.this.view.showError(AddProjectPopUpPresenter.this.view.getDuplicatedProjectMessage());
                });
            }
        };
        return this.createErrorCallback((Map<Class<? extends Throwable>, CommandWithThrowableDrivenErrorCallback.CommandWithThrowable>)errors);
    }

    ErrorCallback<?> createErrorCallback(Map<Class<? extends Throwable>, CommandWithThrowableDrivenErrorCallback.CommandWithThrowable> errors) {
        return new CommandWithThrowableDrivenErrorCallback((HasBusyIndicator)this.busyIndicatorView, errors);
    }

    boolean isDuplicatedProjectName(Throwable throwable) {
        return throwable instanceof FileAlreadyExistsException;
    }

    String getBaseURL() {
        String url = GWT.getModuleBaseURL();
        String baseUrl = url.replace(GWT.getModuleName() + "/", "");
        return baseUrl;
    }

    private void notifySuccess() {
        this.notificationEvent.fire((Object)new NotificationEvent(this.view.getAddProjectSuccessMessage(), NotificationEvent.NotificationType.SUCCESS));
    }

    public void cancel() {
        this.view.hide();
    }

    public void restoreDefaultAdvancedOptions() {
        this.libraryPreferences.load(loadedLibraryPreferences -> {
            this.view.setDescription(loadedLibraryPreferences.getProjectPreferences().getDescription());
            this.view.setVersion(loadedLibraryPreferences.getProjectPreferences().getVersion());
            this.view.setGroupId(this.projectContext.getActiveOrganizationalUnit().isPresent() ? ((OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().get()).getDefaultGroupId() : loadedLibraryPreferences.getOrganizationalUnitPreferences().getGroupId());
        }, error -> {});
    }

    private POM setDefaultPOM(String groupId, String artifactId, String version, String name, String description) {
        POM pom = new POM(new GAV(groupId, artifactId, version));
        pom.setName(name);
        pom.setDescription(description);
        POMBuilder pomBuilder = new POMBuilder(pom);
        KiePOMDefaultOptions pomDefaultOptions = new KiePOMDefaultOptions();
        pomBuilder.setBuildPlugins(pomDefaultOptions.getBuildPlugins());
        return pomBuilder.build();
    }

    public static interface View
    extends UberElement<AddProjectPopUpPresenter>,
    HasBusyIndicator {
        public String getName();

        public String getDescription();

        public String getGroupId();

        public String getArtifactId();

        public String getVersion();

        public void setDescription(String var1);

        public void setGroupId(String var1);

        public void setArtifactId(String var1);

        public void setVersion(String var1);

        public boolean isAdvancedOptionsSelected();

        public void show();

        public void hide();

        public void showError(String var1);

        public String getSavingMessage();

        public String getAddProjectSuccessMessage();

        public String getDuplicatedProjectMessage();

        public String getEmptyNameMessage();

        public String getInvalidNameMessage();

        public String getEmptyGroupIdMessage();

        public String getInvalidGroupIdMessage();

        public String getEmptyArtifactIdMessage();

        public String getInvalidArtifactIdMessage();

        public String getEmptyVersionMessage();

        public String getInvalidVersionMessage();

        public void setAddButtonEnabled(boolean var1);
    }
}

