/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.project.rename;

import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.workbench.events.NotificationEvent;

public class RenameProjectPopUpScreen {
    private final Caller<KieModuleService> projectService;
    private View view;
    private ProjectController projectController;
    private TranslationService ts;
    private Event<NotificationEvent> notificationEvent;
    private WorkspaceProject workspaceProject;

    @Inject
    public RenameProjectPopUpScreen(View view, Caller<KieModuleService> projectService, ProjectController projectController, TranslationService ts, Event<NotificationEvent> notificationEvent) {
        this.view = view;
        this.projectService = projectService;
        this.projectController = projectController;
        this.ts = ts;
        this.notificationEvent = notificationEvent;
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
    }

    public void show(WorkspaceProject projectInfo) {
        if (this.projectController.canUpdateProject(projectInfo)) {
            this.workspaceProject = projectInfo;
            this.view.show();
        }
    }

    public void cancel() {
        this.view.hide();
    }

    public void rename(String newName) {
        if (this.projectController.canUpdateProject(this.workspaceProject)) {
            this.view.showBusyIndicator(this.ts.getTranslation("Renaming"));
            ((KieModuleService)this.projectService.call(path -> {
                this.view.hideBusyIndicator();
                this.notificationEvent.fire((Object)new NotificationEvent(this.ts.format("RenameSuccess", new Object[]{newName}), NotificationEvent.NotificationType.SUCCESS));
                this.view.hide();
            })).rename(this.workspaceProject.getMainModule().getPomXMLPath(), newName, "Project renamed to: " + newName);
        }
    }

    public View getView() {
        return this.view;
    }

    public static interface View
    extends UberElemental<RenameProjectPopUpScreen>,
    HasBusyIndicator {
        public void show();

        public void hide();
    }
}

