/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.settings;

import elemental2.dom.HTMLElement;
import elemental2.promise.Promise;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.client.repositories.ConflictingRepositoriesPopup;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.project.service.GAVAlreadyExistsException;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.workbench.common.screens.library.client.settings.SettingsSectionChange;
import org.kie.workbench.common.screens.library.client.settings.sections.SettingsSections;
import org.kie.workbench.common.screens.library.client.settings.util.sections.Section;
import org.kie.workbench.common.screens.library.client.settings.util.sections.SectionManager;
import org.kie.workbench.common.screens.projecteditor.model.ProjectScreenModel;
import org.kie.workbench.common.screens.projecteditor.service.ProjectScreenService;
import org.uberfire.annotations.Customizable;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.client.promise.Promises;
import org.uberfire.ext.editor.commons.client.file.popups.SavePopUpPresenter;
import org.uberfire.ext.widgets.common.client.common.ConcurrentChangePopup;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class SettingsPresenter {
    private final View view;
    private final Promises promises;
    private final Event<NotificationEvent> notificationEvent;
    private final SettingsSections settingsSections;
    private final SavePopUpPresenter savePopUpPresenter;
    private final Caller<ProjectScreenService> projectScreenService;
    private final WorkspaceProjectContext projectContext;
    private final ManagedInstance<ObservablePath> observablePaths;
    private final ConflictingRepositoriesPopup conflictingRepositoriesPopup;
    private final SectionManager<ProjectScreenModel> sectionManager;
    private final ProjectController projectController;
    private ObservablePath pathToPom;
    ObservablePath.OnConcurrentUpdateEvent concurrentPomUpdateInfo = null;
    ProjectScreenModel model;

    @Inject
    public SettingsPresenter(View view, Promises promises, Event<NotificationEvent> notificationEvent, @Customizable SettingsSections settingsSections, SavePopUpPresenter savePopUpPresenter, Caller<ProjectScreenService> projectScreenService, WorkspaceProjectContext projectContext, ManagedInstance<ObservablePath> observablePaths, ConflictingRepositoriesPopup conflictingRepositoriesPopup, SectionManager<ProjectScreenModel> sectionManager, ProjectController projectController) {
        this.view = view;
        this.promises = promises;
        this.notificationEvent = notificationEvent;
        this.settingsSections = settingsSections;
        this.savePopUpPresenter = savePopUpPresenter;
        this.projectScreenService = projectScreenService;
        this.projectContext = projectContext;
        this.observablePaths = observablePaths;
        this.conflictingRepositoriesPopup = conflictingRepositoriesPopup;
        this.sectionManager = sectionManager;
        this.projectController = projectController;
    }

    @PostConstruct
    public void setup() {
        this.sectionManager.init(this.settingsSections.getList(), this.view.getMenuItemsContainer(), this.view.getContentContainer());
        this.setupUsingCurrentSection();
    }

    public Promise<Void> setupUsingCurrentSection() {
        this.view.init(this);
        if (!this.projectContext.getActiveModule().isPresent()) {
            return this.promises.resolve();
        }
        this.view.showBusyIndicator();
        if (!this.userCanUpdateProject()) {
            this.view.disableActions();
        }
        if (this.pathToPom != null) {
            this.pathToPom.dispose();
        }
        this.concurrentPomUpdateInfo = null;
        this.pathToPom = ((ObservablePath)this.observablePaths.get()).wrap(((Module)this.projectContext.getActiveModule().orElseThrow(() -> new RuntimeException("Can't get active module"))).getPomXMLPath());
        this.pathToPom.onConcurrentUpdate(info -> {
            this.concurrentPomUpdateInfo = info;
        });
        return this.promises.promisify(this.projectScreenService, s -> s.load((Path)this.pathToPom)).then(model -> {
            this.model = model;
            return this.setupSections((ProjectScreenModel)model);
        }).then(i -> {
            this.view.hideBusyIndicator();
            if (this.sectionManager.manages(this.sectionManager.getCurrentSection())) {
                return this.sectionManager.goToCurrentSection();
            }
            return this.sectionManager.goToFirstAvailable();
        }).catch_(o -> this.promises.catchOrExecute(o, e -> {
            this.view.hideBusyIndicator();
            return this.promises.reject(e);
        }, i -> {
            this.notificationEvent.fire((Object)new NotificationEvent(this.view.getLoadErrorMessage(), NotificationEvent.NotificationType.ERROR));
            this.view.hideBusyIndicator();
            return this.promises.resolve();
        }));
    }

    Promise<Object> setupSections(ProjectScreenModel model) {
        ArrayList<Section<ProjectScreenModel>> sections = new ArrayList<Section<ProjectScreenModel>>(this.sectionManager.getSections());
        return this.promises.all(sections, section -> this.setupSection(model, (Section<ProjectScreenModel>)section)).then(i -> {
            if (this.sectionManager.isEmpty()) {
                return this.promises.reject((Object)"No sections available");
            }
            return this.promises.resolve();
        });
    }

    Promise<Object> setupSection(ProjectScreenModel model, Section<ProjectScreenModel> section) {
        return section.setup(model).then(i -> {
            this.sectionManager.resetDirtyIndicator(section);
            return this.promises.resolve();
        }).catch_(e -> {
            this.sectionManager.remove(section);
            this.notificationEvent.fire((Object)new NotificationEvent(this.getSectionSetupErrorMessage(section), NotificationEvent.NotificationType.WARNING));
            return this.promises.resolve();
        });
    }

    String getSectionSetupErrorMessage(Section<ProjectScreenModel> section) {
        return this.view.getSectionSetupErrorMessage(section.getView().getTitle());
    }

    public void showSaveModal() {
        if (this.userCanUpdateProject()) {
            this.sectionManager.validateAll().then(i -> {
                this.savePopUpPresenter.show(this::save);
                return this.promises.resolve();
            }).catch_(o -> this.promises.catchOrExecute(o, e -> {
                this.view.hideBusyIndicator();
                return this.promises.reject(e);
            }, section -> {
                this.view.hideBusyIndicator();
                return this.sectionManager.goTo((Section<ProjectScreenModel>)section);
            }));
        }
    }

    void save(String comment) {
        this.promises.reduceLazilyChaining(this.getSavingSteps(comment), this::executeSavingStep).catch_(o -> this.promises.catchOrExecute(o, arg_0 -> ((Promises)this.promises).reject(arg_0), this.sectionManager::goTo));
    }

    private Promise<Void> executeSavingStep(Supplier<Promise<Void>> chain, SavingStep savingStep) {
        return savingStep.execute(chain);
    }

    private List<SavingStep> getSavingSteps(String comment) {
        Stream<SavingStep> saveSectionsSteps = this.sectionManager.getSections().stream().map(section -> chain -> section.save(comment, chain));
        Stream<SavingStep> commonSavingSteps = Stream.of(chain -> this.saveProjectScreenModel(comment, DeploymentMode.VALIDATED, chain), chain -> this.sectionManager.resetAllDirtyIndicators(), chain -> this.displaySuccessMessage());
        return Stream.concat(saveSectionsSteps, commonSavingSteps).collect(Collectors.toList());
    }

    Promise<Void> displaySuccessMessage() {
        this.view.hideBusyIndicator();
        this.notificationEvent.fire((Object)new NotificationEvent(this.view.getSaveSuccessMessage(), NotificationEvent.NotificationType.SUCCESS));
        return this.promises.resolve();
    }

    Promise<Void> saveProjectScreenModel(String comment, DeploymentMode mode, Supplier<Promise<Void>> chain) {
        if (this.concurrentPomUpdateInfo != null) {
            this.handlePomConcurrentUpdate(comment, chain);
            return this.promises.reject(this.sectionManager.getCurrentSection());
        }
        return this.promises.promisify(this.projectScreenService, s -> s.save((Path)this.pathToPom, this.model, comment, mode)).then(workspaceProject -> {
            this.projectContext.updateProjectModule(workspaceProject.getMainModule());
            return this.promises.resolve();
        }).catch_(o -> this.promises.catchOrExecute(o, arg_0 -> this.lambda$null$24(comment, (Supplier)chain, arg_0), x -> {
            this.view.hideBusyIndicator();
            return this.promises.reject(x);
        }));
    }

    void handlePomConcurrentUpdate(String comment, Supplier<Promise<Void>> chain) {
        ConcurrentChangePopup.newConcurrentUpdate((Path)this.concurrentPomUpdateInfo.getPath(), (User)this.concurrentPomUpdateInfo.getIdentity(), () -> this.forceSave(comment, chain), () -> {}, this::reset).show();
    }

    Promise<Void> handlePomConcurrentUpdate(String comment, Supplier<Promise<Void>> saveChain, GAVAlreadyExistsException exception) {
        this.view.hideBusyIndicator();
        this.conflictingRepositoriesPopup.setContent(this.model.getPOM().getGav(), exception.getRepositories(), () -> this.forceSave(comment, saveChain));
        this.conflictingRepositoriesPopup.show();
        return this.promises.reject(this.sectionManager.getCurrentSection());
    }

    void forceSave(String comment, Supplier<Promise<Void>> chain) {
        this.concurrentPomUpdateInfo = null;
        this.conflictingRepositoriesPopup.hide();
        this.saveProjectScreenModel(comment, DeploymentMode.FORCED, chain).then(i -> (Promise)chain.get());
    }

    public void onSettingsSectionChanged(@Observes SettingsSectionChange<ProjectScreenModel> settingsSectionChange) {
        if (!this.sectionManager.manages(settingsSectionChange.getSection())) {
            return;
        }
        this.sectionManager.updateDirtyIndicator(settingsSectionChange.getSection());
    }

    public boolean userCanUpdateProject() {
        return this.projectContext.getActiveWorkspaceProject().isPresent() && this.projectController.canUpdateProject((WorkspaceProject)this.projectContext.getActiveWorkspaceProject().get());
    }

    public boolean mayClose() {
        return !this.sectionManager.hasDirtySections();
    }

    public void reset() {
        if (this.userCanUpdateProject()) {
            this.setupUsingCurrentSection();
        }
    }

    public View getView() {
        return this.view;
    }

    private /* synthetic */ Promise lambda$null$24(String comment, Supplier chain, RuntimeException e) {
        if (e instanceof GAVAlreadyExistsException) {
            return this.handlePomConcurrentUpdate(comment, chain, (GAVAlreadyExistsException)e);
        }
        this.view.hideBusyIndicator();
        return this.promises.resolve();
    }

    @FunctionalInterface
    private static interface SavingStep {
        public Promise<Void> execute(Supplier<Promise<Void>> var1);
    }

    public static interface View
    extends UberElemental<SettingsPresenter>,
    HasBusyIndicator {
        public void showBusyIndicator();

        public HTMLElement getMenuItemsContainer();

        public String getSaveSuccessMessage();

        public String getLoadErrorMessage();

        public String getSectionSetupErrorMessage(String var1);

        public void show();

        public void hide();

        public HTMLElement getContentContainer();

        public void disableActions();
    }
}

