/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.settings.util.select;

import elemental2.dom.Element;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.widgets.client.widget.KieSelectElement;

@Dependent
public class KieEnumSelectElement<T extends Enum<T>> {
    private final KieSelectElement kieSelectElement;
    private final TranslationService translationService;
    Class<T> componentType;

    @Inject
    public KieEnumSelectElement(KieSelectElement kieSelectElement, TranslationService translationService) {
        this.kieSelectElement = kieSelectElement;
        this.translationService = translationService;
    }

    public void setup(Element element, T[] values, T initialValue, Consumer<T> onChange) {
        this.componentType = values.getClass().getComponentType();
        this.kieSelectElement.setup(element, this.buildOptions((Enum[])values), ((Enum)initialValue).name(), name -> onChange.accept(this.toEnum((String)name)));
    }

    List<KieSelectElement.Option> buildOptions(T[] values) {
        return Arrays.stream(values).map(this::newOption).collect(Collectors.toList());
    }

    KieSelectElement.Option newOption(T e) {
        return new KieSelectElement.Option(this.getLabel(e), ((Enum)e).name());
    }

    String getLabel(T e) {
        return this.translationService.format(((Enum)e).name(), new Object[0]);
    }

    public T getValue() {
        return this.toEnum(this.kieSelectElement.getValue());
    }

    T toEnum(String value) {
        return Enum.valueOf(this.componentType, value);
    }
}

