/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.util;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.repositories.ConflictingRepositoriesPopup;
import org.guvnor.common.services.project.client.type.POMResourceType;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.project.service.GAVAlreadyExistsException;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.defaulteditor.client.editor.KieTextEditorPresenter;
import org.kie.workbench.common.screens.defaulteditor.client.editor.KieTextEditorView;
import org.kie.workbench.common.screens.projecteditor.model.InvalidPomException;
import org.kie.workbench.common.screens.projecteditor.service.PomEditorService;
import org.kie.workbench.common.widgets.client.callbacks.CommandWithThrowableDrivenErrorCallback;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.ext.widgets.common.client.ace.AceEditorMode;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.Menus;

@WorkbenchEditor(identifier="PomEditor", supportedTypes={POMResourceType.class}, priority=2)
public class PomEditor
extends KieTextEditorPresenter {
    private final Caller<PomEditorService> pomEditorService;
    private final ConflictingRepositoriesPopup conflictingRepositoriesPopup;
    public final Event<NotificationEvent> notificationEvent;
    public final TranslationService translationService;

    @Inject
    public PomEditor(KieTextEditorView baseView, Caller<PomEditorService> pomEditorService, ConflictingRepositoriesPopup conflictingRepositoriesPopup, Event<NotificationEvent> notificationEvent, TranslationService translationService) {
        super(baseView);
        this.pomEditorService = pomEditorService;
        this.conflictingRepositoriesPopup = conflictingRepositoriesPopup;
        this.notificationEvent = notificationEvent;
        this.translationService = translationService;
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        super.onStartup(path, place);
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return super.getMenus();
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    @WorkbenchPartView
    public IsWidget asWidget() {
        return super.getWidget();
    }

    public AceEditorMode getAceEditorMode() {
        return AceEditorMode.XML;
    }

    protected void save(String commitMessage) {
        this.doSave(commitMessage, DeploymentMode.VALIDATED);
    }

    private void doSave(String commitMessage, DeploymentMode mode) {
        this.view.showBusyIndicator(CommonConstants.INSTANCE.Saving());
        ((PomEditorService)this.pomEditorService.call(this.getSaveSuccessCallback(this.view.getContent().hashCode()), (ErrorCallback)new CommandWithThrowableDrivenErrorCallback((HasBusyIndicator)this.busyIndicatorView, this.saveErrorCallbackConfig(commitMessage)))).save((Path)this.versionRecordManager.getCurrentPath(), this.view.getContent(), this.metadata, commitMessage, mode);
    }

    private Map<Class<? extends Throwable>, CommandWithThrowableDrivenErrorCallback.CommandWithThrowable> saveErrorCallbackConfig(final String commitMessage) {
        return new HashMap<Class<? extends Throwable>, CommandWithThrowableDrivenErrorCallback.CommandWithThrowable>(){
            {
                this.put(GAVAlreadyExistsException.class, t -> {
                    PomEditor.this.view.hideBusyIndicator();
                    GAVAlreadyExistsException e = (GAVAlreadyExistsException)t;
                    PomEditor.this.conflictingRepositoriesPopup.setContent(e.getGAV(), e.getRepositories(), () -> {
                        PomEditor.this.conflictingRepositoriesPopup.hide();
                        PomEditor.this.doSave(commitMessage, DeploymentMode.FORCED);
                    });
                    PomEditor.this.conflictingRepositoriesPopup.show();
                });
                this.put(InvalidPomException.class, t -> {
                    PomEditor.this.view.hideBusyIndicator();
                    InvalidPomException e = (InvalidPomException)t;
                    String message = PomEditor.this.translationService.format("InvalidPom", new Object[]{e.getLineNumber(), e.getColumnNumber()});
                    PomEditor.this.notificationEvent.fire((Object)new NotificationEvent(message, NotificationEvent.NotificationType.ERROR));
                });
            }
        };
    }
}

